/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs_bedrock.text.utils;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lenni0451.mcstructs_bedrock.text.ABedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.components.StringBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.utils.TranslatorOptions;

public class BedrockTranslator {
    private static final Pattern TRANSLATION_KEY_PATTERN = Pattern.compile("%%|%(?:([\\w._\\-]+)([^\\w._\\-]|$))?");
    private static final Pattern DOLLAR_REPLACE = Pattern.compile("\\$[ds]");
    private static final Pattern S_ARGS_PATTERN = Pattern.compile("%[ds]");
    private static final Pattern ARGS_PATTERN = Pattern.compile("%([ds\\d])");

    public static String translate(String key, Function<String, String> translator, Object[] args, TranslatorOptions ... options) {
        List<TranslatorOptions> enabledOptions = Arrays.asList(options);
        StringBuilder out = new StringBuilder();
        String translated = BedrockTranslator.fillTranslations(key, translator, enabledOptions);
        translated = BedrockTranslator.replaceDollar(translated);
        if (args.length != 0) {
            Matcher matcher = ARGS_PATTERN.matcher(translated);
            int argIndex = 0;
            int numArgOffset = BedrockTranslator.countSArgs(translated);
            int start = 0;
            while (matcher.find()) {
                int matchStart = matcher.start();
                int matchEnd = matcher.end();
                if (matchStart > start) {
                    out.append(translated, start, matchStart);
                }
                start = matchEnd;
                String match = matcher.group(1);
                if (match.equals("d") || match.equals("s")) {
                    out.append(BedrockTranslator.getArg(args, translator, enabledOptions, argIndex++));
                    continue;
                }
                out.append(BedrockTranslator.getArg(args, translator, enabledOptions, numArgOffset + Integer.parseInt(match) - 1));
            }
            if (start < translated.length()) {
                out.append(translated, start, translated.length());
            }
        } else {
            out.append(translated);
        }
        return out.toString();
    }

    private static String fillTranslations(String s, Function<String, String> translator, List<TranslatorOptions> enabledOptions) {
        if (enabledOptions.contains((Object)TranslatorOptions.IGNORE_STARTING_PERCENT) && s.startsWith("%")) {
            s = "%" + s;
        }
        StringBuilder out = new StringBuilder();
        Matcher matcher = TRANSLATION_KEY_PATTERN.matcher(s);
        int start = 0;
        while (matcher.find()) {
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            if (matchStart > start) {
                out.append(s, start, matchStart);
            }
            start = matchEnd;
            String match = matcher.group();
            if (match.equals("%%")) {
                out.append("%");
                continue;
            }
            String key = matcher.group(1);
            if (key == null) continue;
            String terminator = matcher.group(2);
            out.append(translator.apply(key));
            if (terminator == null) continue;
            out.append(terminator);
        }
        if (start == 0 && !enabledOptions.contains((Object)TranslatorOptions.REQUIRE_PERCENT)) {
            out.append(translator.apply(s));
        } else if (start < s.length()) {
            out.append(s, start, s.length());
        }
        return out.toString();
    }

    private static String replaceDollar(String s) {
        return DOLLAR_REPLACE.matcher(s).replaceAll("");
    }

    private static int countSArgs(String s) {
        int count = 0;
        Matcher matcher = S_ARGS_PATTERN.matcher(s);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    private static String getArg(Object[] args, Function<String, String> translator, List<TranslatorOptions> enabledOptions, int index) {
        if (index < 0 || index >= args.length) {
            return "";
        }
        boolean skipTranslation = enabledOptions.contains((Object)TranslatorOptions.SKIP_ARGS_TRANSLATION);
        Object arg = args[index];
        if (arg instanceof String) {
            String s = (String)arg;
            if (s.startsWith("%") && !skipTranslation) {
                return translator.apply(s.substring(1));
            }
        } else {
            if (arg instanceof StringBedrockComponent) {
                StringBedrockComponent component = (StringBedrockComponent)arg;
                if (component.getText().startsWith("%") && !skipTranslation) {
                    return translator.apply(component.getText().substring(1));
                }
                return component.asString();
            }
            if (arg instanceof ABedrockComponent) {
                return ((ABedrockComponent)arg).asString();
            }
        }
        return arg.toString();
    }
}

