/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.Base64;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import net.lenni0451.reflect.ClassLoaders;
import net.lenni0451.reflect.Fields;
import net.lenni0451.reflect.JVMConstants;
import net.lenni0451.reflect.Methods;

public class Agents {
    private static final String DUMMY_AGENT_CLASS = "yv66vgAAADQAEQEAIW5ldC9sZW5uaTA0NTEvcmVmbGVjdC9BZ2VudExvYWRlcgcAAQEAEGphdmEvbGFuZy9PYmplY3QHAAMBAA9pbnN0cnVtZW50YXRpb24BACZMamF2YS9sYW5nL2luc3RydW1lbnQvSW5zdHJ1bWVudGF0aW9uOwEABjxpbml0PgEAAygpVgwABwAICgAEAAkBAAlhZ2VudG1haW4BADsoTGphdmEvbGFuZy9TdHJpbmc7TGphdmEvbGFuZy9pbnN0cnVtZW50L0luc3RydW1lbnRhdGlvbjspVgwABQAGCQACAA0BAAdwcmVtYWluAQAEQ29kZQABAAIABAAAAAEACQAFAAYAAAADAAEABwAIAAEAEAAAABEAAQABAAAABSq3AAqxAAAAAAAJAAsADAABABAAAAARAAEAAgAAAAUrswAOsQAAAAAACQAPAAwAAQAQAAAAEQABAAIAAAAFK7MADrEAAAAAAAA=";

    public static File createDummyAgent(Class<?> agentClass) throws IOException {
        File agentJar = File.createTempFile("DummyAgent", ".jar");
        agentJar.deleteOnExit();
        Agents.createDummyAgent(agentJar, agentClass.getName());
        return agentJar;
    }

    public static void createDummyAgent(File agentJar, String agentName) throws IOException {
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(agentJar));
        jos.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        manifest.getMainAttributes().putValue("Launcher-Agent-Class", agentName);
        manifest.getMainAttributes().putValue("Can-Redefine-Classes", "true");
        manifest.getMainAttributes().putValue("Can-Retransform-Classes", "true");
        manifest.write(jos);
        jos.closeEntry();
        jos.close();
    }

    public static void load(File agentJar) throws ClassNotFoundException {
        Class<?> instrumentationImpl = Class.forName(JVMConstants.CLASS_InstrumentationImpl);
        Method method = Methods.getDeclaredMethod(instrumentationImpl, JVMConstants.METHOD_InstrumentationImpl_loadAgent, String.class);
        if (method == null) {
            throw new IllegalStateException("Loading an Agent during runtime is not possible because the " + JVMConstants.METHOD_InstrumentationImpl_loadAgent + " method does not exist");
        }
        Methods.invoke(null, method, agentJar.getAbsolutePath());
    }

    public static void loadInternal(Class<?> agentClass) throws IOException, ClassNotFoundException {
        Agents.load(Agents.createDummyAgent(agentClass));
    }

    public static Instrumentation getInstrumentation() throws IOException, ClassNotFoundException {
        Class<?> agentLoaderClass;
        String agentLoaderClassName = "net.lenni0451.reflect.AgentLoader";
        try {
            agentLoaderClass = ClassLoader.getSystemClassLoader().loadClass("net.lenni0451.reflect.AgentLoader");
        }
        catch (ClassNotFoundException e) {
            agentLoaderClass = ClassLoaders.defineClass(ClassLoader.getSystemClassLoader(), "net.lenni0451.reflect.AgentLoader", Base64.getDecoder().decode(DUMMY_AGENT_CLASS));
            Agents.load(Agents.createDummyAgent(agentLoaderClass));
        }
        return (Instrumentation)Fields.get(null, Fields.getDeclaredField(agentLoaderClass, "instrumentation"));
    }
}

