/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect.accessor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.lenni0451.reflect.Constructors;
import net.lenni0451.reflect.Methods;
import net.lenni0451.reflect.wrapper.ASMWrapper;

public class FieldAccessor {
    public static <I> I makeSetter(@Nonnull Class<?> invokerClass, Object instance, @Nonnull Field field) {
        String newClassName = ASMWrapper.slash(field.getDeclaringClass()) + "$FieldSetter";
        boolean staticField = Modifier.isStatic(field.getModifiers());
        Method invokerMethod = FieldAccessor.findInvokerMethod(invokerClass, new Class[]{field.getType()}, Void.TYPE);
        ASMWrapper acc = ASMWrapper.create(ASMWrapper.opcode("ACC_SUPER") | ASMWrapper.opcode("ACC_FINAL") | ASMWrapper.opcode("ACC_SYNTHETIC"), newClassName, null, "java/lang/Object", new String[]{ASMWrapper.slash(invokerClass)});
        FieldAccessor.addConstructor(acc, newClassName, () -> instance.getClass(), field);
        ASMWrapper.MethodVisitorAccess mv = acc.visitMethod(ASMWrapper.opcode("ACC_PUBLIC"), invokerMethod.getName(), ASMWrapper.desc(invokerMethod), null, null);
        if (staticField) {
            mv.visitVarInsn(ASMWrapper.getLoadOpcode(invokerMethod.getParameterTypes()[0]), 1);
            if (!invokerMethod.getParameterTypes()[0].equals(field.getType())) {
                mv.visitTypeInsn(ASMWrapper.opcode("CHECKCAST"), ASMWrapper.slash(field.getType()));
            }
            mv.visitFieldInsn(ASMWrapper.opcode("PUTSTATIC"), ASMWrapper.slash(field.getDeclaringClass()), field.getName(), ASMWrapper.desc(field.getType()));
        } else {
            mv.visitVarInsn(ASMWrapper.opcode("ALOAD"), 0);
            mv.visitFieldInsn(ASMWrapper.opcode("GETFIELD"), newClassName, "instance", ASMWrapper.desc(instance.getClass()));
            mv.visitVarInsn(ASMWrapper.getLoadOpcode(invokerMethod.getParameterTypes()[0]), 1);
            if (!invokerMethod.getParameterTypes()[0].equals(field.getType())) {
                mv.visitTypeInsn(ASMWrapper.opcode("CHECKCAST"), ASMWrapper.slash(field.getType()));
            }
            mv.visitFieldInsn(ASMWrapper.opcode("PUTFIELD"), ASMWrapper.slash(field.getDeclaringClass()), field.getName(), ASMWrapper.desc(field.getType()));
        }
        mv.visitInsn(ASMWrapper.opcode("RETURN"));
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        Class<?> clazz = acc.defineMetafactory(field.getDeclaringClass());
        if (staticField) {
            Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
            return (I)Constructors.invoke(constructor, new Object[0]);
        }
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, instance.getClass());
        return (I)Constructors.invoke(constructor, instance);
    }

    public static <I> I makeDynamicSetter(@Nonnull Class<I> invokerClass, @Nonnull Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Dynamic setter can only be used for non-static fields");
        }
        String newClassName = ASMWrapper.slash(field.getDeclaringClass()) + "$DynamicFieldSetter";
        Method invokerMethod = FieldAccessor.findInvokerMethod(invokerClass, new Class[]{field.getDeclaringClass(), field.getType()}, Void.TYPE);
        ASMWrapper acc = ASMWrapper.create(ASMWrapper.opcode("ACC_SUPER") | ASMWrapper.opcode("ACC_FINAL") | ASMWrapper.opcode("ACC_SYNTHETIC"), newClassName, null, "java/lang/Object", new String[]{ASMWrapper.slash(invokerClass)});
        FieldAccessor.addConstructor(acc, newClassName, null, field);
        ASMWrapper.MethodVisitorAccess mv = acc.visitMethod(ASMWrapper.opcode("ACC_PUBLIC"), invokerMethod.getName(), ASMWrapper.desc(invokerMethod), null, null);
        mv.visitVarInsn(ASMWrapper.opcode("ALOAD"), 1);
        if (!invokerMethod.getParameterTypes()[0].equals(field.getDeclaringClass())) {
            mv.visitTypeInsn(ASMWrapper.opcode("CHECKCAST"), ASMWrapper.slash(field.getDeclaringClass()));
        }
        mv.visitVarInsn(ASMWrapper.getLoadOpcode(invokerMethod.getParameterTypes()[1]), 2);
        if (!invokerMethod.getParameterTypes()[1].equals(field.getType())) {
            mv.visitTypeInsn(ASMWrapper.opcode("CHECKCAST"), ASMWrapper.slash(field.getType()));
        }
        mv.visitFieldInsn(ASMWrapper.opcode("PUTFIELD"), ASMWrapper.slash(field.getDeclaringClass()), field.getName(), ASMWrapper.desc(field.getType()));
        mv.visitInsn(ASMWrapper.opcode("RETURN"));
        mv.visitMaxs(2, 3);
        mv.visitEnd();
        Class<?> clazz = acc.defineMetafactory(field.getDeclaringClass());
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
        return (I)Constructors.invoke(constructor, new Object[0]);
    }

    public static <I> I makeGetter(@Nonnull Class<I> invokerClass, Object instance, @Nonnull Field field) {
        String newClassName = ASMWrapper.slash(field.getDeclaringClass()) + "$FieldGetter";
        boolean staticField = Modifier.isStatic(field.getModifiers());
        Method invokerMethod = FieldAccessor.findInvokerMethod(invokerClass, new Class[0], field.getType());
        ASMWrapper acc = ASMWrapper.create(ASMWrapper.opcode("ACC_SUPER") | ASMWrapper.opcode("ACC_FINAL") | ASMWrapper.opcode("ACC_SYNTHETIC"), newClassName, null, "java/lang/Object", new String[]{ASMWrapper.slash(invokerClass)});
        FieldAccessor.addConstructor(acc, newClassName, () -> instance.getClass(), field);
        ASMWrapper.MethodVisitorAccess mv = acc.visitMethod(ASMWrapper.opcode("ACC_PUBLIC"), invokerMethod.getName(), ASMWrapper.desc(invokerMethod), null, null);
        if (staticField) {
            mv.visitFieldInsn(ASMWrapper.opcode("GETSTATIC"), ASMWrapper.slash(field.getDeclaringClass()), field.getName(), ASMWrapper.desc(field.getType()));
        } else {
            mv.visitVarInsn(ASMWrapper.opcode("ALOAD"), 0);
            mv.visitFieldInsn(ASMWrapper.opcode("GETFIELD"), newClassName, "instance", ASMWrapper.desc(instance.getClass()));
            mv.visitFieldInsn(ASMWrapper.opcode("GETFIELD"), ASMWrapper.slash(field.getDeclaringClass()), field.getName(), ASMWrapper.desc(field.getType()));
        }
        if (!field.getType().equals(invokerMethod.getReturnType())) {
            mv.visitTypeInsn(ASMWrapper.opcode("CHECKCAST"), ASMWrapper.slash(invokerMethod.getReturnType()));
        }
        mv.visitInsn(ASMWrapper.getReturnOpcode(invokerMethod.getReturnType()));
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        Class<?> clazz = acc.defineMetafactory(field.getDeclaringClass());
        if (staticField) {
            Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
            return (I)Constructors.invoke(constructor, new Object[0]);
        }
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, instance.getClass());
        return (I)Constructors.invoke(constructor, instance);
    }

    public static <I> I makeDynamicGetter(@Nonnull Class<I> invokerClass, @Nonnull Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Dynamic setter can only be used for non-static fields");
        }
        String newClassName = ASMWrapper.slash(field.getDeclaringClass()) + "$DynamicFieldGetter";
        Method invokerMethod = FieldAccessor.findInvokerMethod(invokerClass, new Class[]{field.getDeclaringClass()}, field.getType());
        ASMWrapper acc = ASMWrapper.create(ASMWrapper.opcode("ACC_SUPER") | ASMWrapper.opcode("ACC_FINAL") | ASMWrapper.opcode("ACC_SYNTHETIC"), newClassName, null, "java/lang/Object", new String[]{ASMWrapper.slash(invokerClass)});
        FieldAccessor.addConstructor(acc, newClassName, null, field);
        ASMWrapper.MethodVisitorAccess mv = acc.visitMethod(ASMWrapper.opcode("ACC_PUBLIC"), invokerMethod.getName(), ASMWrapper.desc(invokerMethod), null, null);
        mv.visitVarInsn(ASMWrapper.opcode("ALOAD"), 1);
        if (!invokerMethod.getParameterTypes()[0].equals(field.getDeclaringClass())) {
            mv.visitTypeInsn(ASMWrapper.opcode("CHECKCAST"), ASMWrapper.slash(field.getDeclaringClass()));
        }
        mv.visitFieldInsn(ASMWrapper.opcode("GETFIELD"), ASMWrapper.slash(field.getDeclaringClass()), field.getName(), ASMWrapper.desc(field.getType()));
        if (!invokerMethod.getReturnType().equals(field.getType())) {
            mv.visitTypeInsn(ASMWrapper.opcode("CHECKCAST"), ASMWrapper.slash(invokerMethod.getReturnType()));
        }
        mv.visitInsn(ASMWrapper.getReturnOpcode(invokerMethod.getReturnType()));
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        Class<?> clazz = acc.defineMetafactory(field.getDeclaringClass());
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
        return (I)Constructors.invoke(constructor, new Object[0]);
    }

    private static Method findInvokerMethod(Class<?> invokerClass, Class<?>[] parameterTypes, Class<?> returnType) {
        if (!Modifier.isInterface(invokerClass.getModifiers())) {
            throw new IllegalArgumentException("The invoker class must be an interface");
        }
        int abstractMethods = 0;
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method invokerMethod : Methods.getDeclaredMethods(invokerClass)) {
            if (!Modifier.isAbstract(invokerMethod.getModifiers())) continue;
            if (++abstractMethods > 1) {
                throw new IllegalArgumentException("The invoker class must only have one abstract method");
            }
            if (invokerMethod.getParameterCount() != parameterTypes.length || !invokerMethod.getReturnType().isAssignableFrom(returnType)) continue;
            boolean hasIncompatibleParameter = false;
            Class<?>[] invokerParameterTypes = invokerMethod.getParameterTypes();
            for (int i = 0; i < invokerParameterTypes.length; ++i) {
                if (invokerParameterTypes[i].isAssignableFrom(parameterTypes[i])) continue;
                hasIncompatibleParameter = true;
                break;
            }
            if (hasIncompatibleParameter) continue;
            methods.add(invokerMethod);
        }
        if (methods.size() != 1) {
            throw new IllegalArgumentException("Could not find a valid invoker method for: " + ASMWrapper.desc(parameterTypes, returnType));
        }
        return (Method)methods.get(0);
    }

    private static void addConstructor(ASMWrapper acc, String newClassName, @Nullable Supplier<Class<?>> instanceType, Field field) {
        if (Modifier.isStatic(field.getModifiers()) || instanceType == null) {
            ASMWrapper.MethodVisitorAccess mv = acc.visitMethod(ASMWrapper.opcode("ACC_PUBLIC"), "<init>", "()V", null, null);
            mv.visitVarInsn(ASMWrapper.opcode("ALOAD"), 0);
            mv.visitMethodInsn(ASMWrapper.opcode("INVOKESPECIAL"), "java/lang/Object", "<init>", "()V", false);
            mv.visitInsn(ASMWrapper.opcode("RETURN"));
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        } else {
            String instanceTypeDesc = ASMWrapper.desc(instanceType.get());
            acc.visitField(ASMWrapper.opcode("ACC_PRIVATE") | ASMWrapper.opcode("ACC_FINAL"), "instance", instanceTypeDesc, null, null);
            ASMWrapper.MethodVisitorAccess mv = acc.visitMethod(ASMWrapper.opcode("ACC_PUBLIC"), "<init>", "(" + instanceTypeDesc + ")V", null, null);
            mv.visitVarInsn(ASMWrapper.opcode("ALOAD"), 0);
            mv.visitMethodInsn(ASMWrapper.opcode("INVOKESPECIAL"), "java/lang/Object", "<init>", "()V", false);
            mv.visitVarInsn(ASMWrapper.opcode("ALOAD"), 0);
            mv.visitVarInsn(ASMWrapper.opcode("ALOAD"), 1);
            mv.visitFieldInsn(ASMWrapper.opcode("PUTFIELD"), newClassName, "instance", instanceTypeDesc);
            mv.visitInsn(ASMWrapper.opcode("RETURN"));
            mv.visitMaxs(2, 2);
            mv.visitEnd();
        }
    }
}

