/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect.stream;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.lenni0451.reflect.JavaBypass;
import net.lenni0451.reflect.stream.constructor.ConstructorStream;
import net.lenni0451.reflect.stream.field.FieldStream;
import net.lenni0451.reflect.stream.method.MethodStream;

public class RStream {
    private final Class<?> clazz;
    private final Object instance;
    private boolean withSuper;
    private FieldStream fieldStream;
    private MethodStream methodStream;
    private ConstructorStream constructorStream;

    public static RStream of(@Nonnull Class<?> clazz) {
        return new RStream(clazz, null);
    }

    public static RStream of(@Nonnull Class<?> clazz, @Nullable Object instance) {
        return new RStream(clazz, instance);
    }

    public static RStream of(@Nonnull String className) {
        return RStream.of(className, null);
    }

    public static RStream of(@Nonnull String className, @Nullable Object instance) {
        try {
            return RStream.of(Class.forName(className), instance);
        }
        catch (ClassNotFoundException e) {
            JavaBypass.UNSAFE.throwException(e);
            return null;
        }
    }

    public static RStream of(@Nonnull Object instance) {
        return new RStream(instance.getClass(), instance);
    }

    private RStream(@Nonnull Class<?> clazz, @Nullable Object instance) {
        this.clazz = clazz;
        this.instance = instance;
    }

    public Class<?> clazz() {
        return this.clazz;
    }

    @Nullable
    public Object instance() {
        return this.instance;
    }

    public RStream withSuper() {
        if (this.withSuper) {
            return this;
        }
        this.withSuper = true;
        this.fieldStream = null;
        this.methodStream = null;
        return this;
    }

    public FieldStream fields() {
        if (this.fieldStream == null) {
            this.fieldStream = new FieldStream(this, this.withSuper);
        }
        return this.fieldStream;
    }

    public ConstructorStream constructors() {
        if (this.constructorStream == null) {
            this.constructorStream = new ConstructorStream(this);
        }
        return this.constructorStream;
    }

    public MethodStream methods() {
        if (this.methodStream == null) {
            this.methodStream = new MethodStream(this, this.withSuper);
        }
        return this.methodStream;
    }
}

