/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect.stream.constructor;

import java.lang.reflect.Constructor;
import net.lenni0451.reflect.Constructors;
import net.lenni0451.reflect.stream.constructor.ConstructorStream;
import net.lenni0451.reflect.stream.general.ModifierWrapper;

public class ConstructorWrapper {
    private final ConstructorStream parent;
    private final Constructor<?> constructor;
    private final ModifierWrapper modifier;

    public ConstructorWrapper(ConstructorStream parent, Constructor<?> constructor) {
        this.parent = parent;
        this.constructor = constructor;
        this.modifier = new ModifierWrapper(constructor.getModifiers());
    }

    public ConstructorStream parent() {
        return this.parent;
    }

    public Constructor<?> raw() {
        return this.constructor;
    }

    public Class<?>[] parameterTypes() {
        return this.constructor.getParameterTypes();
    }

    public Class<?> owner() {
        return this.constructor.getDeclaringClass();
    }

    public ModifierWrapper modifier() {
        return this.modifier;
    }

    public <T> T newInstance(Object ... args) {
        return (T)Constructors.invoke(this.constructor, args);
    }
}

