/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect.stream.field;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.lenni0451.reflect.Fields;
import net.lenni0451.reflect.JavaBypass;
import net.lenni0451.reflect.stream.RStream;
import net.lenni0451.reflect.stream.field.FieldWrapper;

public class FieldStream {
    private final RStream parent;
    private final List<FieldWrapper> fields;

    public FieldStream(RStream parent, boolean withSuper) {
        this.parent = parent;
        this.fields = new ArrayList<FieldWrapper>();
        Class<?> clazz = parent.clazz();
        do {
            for (Field field : Fields.getDeclaredFields(clazz)) {
                this.fields.add(new FieldWrapper(this, field));
            }
        } while (withSuper && (clazz = clazz.getSuperclass()) != null);
    }

    public RStream parent() {
        return this.parent;
    }

    public int size() {
        return this.fields.size();
    }

    public FieldWrapper by(String name) {
        for (FieldWrapper field : this.fields) {
            if (!field.name().equals(name)) continue;
            return field;
        }
        JavaBypass.UNSAFE.throwException(new NoSuchFieldException());
        return null;
    }

    public FieldWrapper by(int index) {
        try {
            return this.fields.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            JavaBypass.UNSAFE.throwException(new NoSuchFieldException());
            return null;
        }
    }

    public FieldStream filter(Predicate<FieldWrapper> filter) {
        this.fields.removeIf(filter.negate());
        return this;
    }

    public FieldStream filter(Class<?> clazz) {
        return this.filter((FieldWrapper field) -> field.type().equals(clazz));
    }

    public FieldStream filter(boolean isStatic) {
        return this.filter((FieldWrapper field) -> field.modifier().isStatic() == isStatic);
    }

    public Iterator<FieldWrapper> iterator() {
        return this.fields.iterator();
    }

    public Stream<FieldWrapper> jstream() {
        return this.fields.stream();
    }

    public FieldStream forEach(Consumer<FieldWrapper> consumer) {
        this.fields.forEach(consumer);
        return this;
    }
}

