/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.mcauth.step.bedrock.playfab;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Objects;
import net.raphimc.mcauth.MinecraftAuth;
import net.raphimc.mcauth.step.AbstractStep;
import net.raphimc.mcauth.step.xbl.StepXblXstsToken;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;

public class StepPlayFabToken
extends AbstractStep<StepXblXstsToken.XblXsts<?>, PlayFabToken> {
    public static final String PLAY_FAB_URL = "https://" + "20CA2".toLowerCase() + ".playfabapi.com/Client/LoginWithXbox";

    public StepPlayFabToken(AbstractStep<?, StepXblXstsToken.XblXsts<?>> prevStep) {
        super(prevStep);
    }

    @Override
    public PlayFabToken applyStep(HttpClient httpClient, StepXblXstsToken.XblXsts<?> prevResult) throws Exception {
        MinecraftAuth.LOGGER.info("Authenticating with PlayFab...");
        JsonObject postData = new JsonObject();
        postData.addProperty("CreateAccount", Boolean.valueOf(true));
        postData.add("EncryptedRequest", null);
        JsonObject infoRequestParameters = new JsonObject();
        infoRequestParameters.addProperty("GetCharacterInventories", Boolean.valueOf(false));
        infoRequestParameters.addProperty("GetCharacterList", Boolean.valueOf(false));
        infoRequestParameters.addProperty("GetPlayerProfile", Boolean.valueOf(true));
        infoRequestParameters.addProperty("GetPlayerStatistics", Boolean.valueOf(false));
        infoRequestParameters.addProperty("GetTitleData", Boolean.valueOf(false));
        infoRequestParameters.addProperty("GetUserAccountInfo", Boolean.valueOf(true));
        infoRequestParameters.addProperty("GetUserData", Boolean.valueOf(false));
        infoRequestParameters.addProperty("GetUserInventory", Boolean.valueOf(false));
        infoRequestParameters.addProperty("GetUserReadOnlyData", Boolean.valueOf(false));
        infoRequestParameters.addProperty("GetUserVirtualCurrency", Boolean.valueOf(false));
        infoRequestParameters.add("PlayerStatisticNames", null);
        infoRequestParameters.add("ProfileConstraints", null);
        infoRequestParameters.add("TitleDataKeys", null);
        infoRequestParameters.add("UserDataKeys", null);
        infoRequestParameters.add("UserReadOnlyDataKeys", null);
        postData.add("InfoRequestParameters", (JsonElement)infoRequestParameters);
        postData.add("PlayerSecret", null);
        postData.addProperty("TitleId", "20CA2");
        postData.addProperty("XboxToken", "XBL3.0 x=" + prevResult.userHash() + ";" + prevResult.token());
        HttpPost httpPost = new HttpPost(PLAY_FAB_URL);
        httpPost.setEntity(new StringEntity(postData.toString(), ContentType.APPLICATION_JSON));
        String response = httpClient.execute((HttpUriRequest)httpPost, new BasicResponseHandler());
        JsonObject obj = JsonParser.parseString((String)response).getAsJsonObject();
        JsonObject data = obj.getAsJsonObject("data");
        JsonObject entityToken = data.getAsJsonObject("EntityToken");
        PlayFabToken result = new PlayFabToken(Instant.parse(entityToken.get("TokenExpiration").getAsString()).toEpochMilli(), entityToken.get("EntityToken").getAsString(), entityToken.get("Entity").getAsJsonObject().get("Id").getAsString(), data.get("SessionTicket").getAsString(), data.get("PlayFabId").getAsString(), prevResult);
        MinecraftAuth.LOGGER.info("Got PlayFab Token, expires: " + Instant.ofEpochMilli(result.expireTimeMs).atZone(ZoneId.systemDefault()));
        return result;
    }

    @Override
    public PlayFabToken refresh(HttpClient httpClient, PlayFabToken result) throws Exception {
        if (result == null || result.isExpired()) {
            return super.refresh(httpClient, result);
        }
        return result;
    }

    @Override
    public PlayFabToken fromJson(JsonObject json) throws Exception {
        StepXblXstsToken.XblXsts prev = this.prevStep != null ? (StepXblXstsToken.XblXsts)this.prevStep.fromJson(json.getAsJsonObject("prev")) : null;
        return new PlayFabToken(json.get("expireTimeMs").getAsLong(), json.get("entityToken").getAsString(), json.get("entityId").getAsString(), json.get("sessionTicket").getAsString(), json.get("playFabId").getAsString(), prev);
    }

    public static final class PlayFabToken
    implements AbstractStep.StepResult<StepXblXstsToken.XblXsts<?>> {
        private final long expireTimeMs;
        private final String entityToken;
        private final String entityId;
        private final String sessionTicket;
        private final String playFabId;
        private final StepXblXstsToken.XblXsts<?> prevResult;

        public PlayFabToken(long expireTimeMs, String entityToken, String entityId, String sessionTicket, String playFabId, StepXblXstsToken.XblXsts<?> prevResult) {
            this.expireTimeMs = expireTimeMs;
            this.entityToken = entityToken;
            this.entityId = entityId;
            this.sessionTicket = sessionTicket;
            this.playFabId = playFabId;
            this.prevResult = prevResult;
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("expireTimeMs", (Number)this.expireTimeMs);
            json.addProperty("entityToken", this.entityToken);
            json.addProperty("entityId", this.entityId);
            json.addProperty("sessionTicket", this.sessionTicket);
            json.addProperty("playFabId", this.playFabId);
            if (this.prevResult != null) {
                json.add("prev", (JsonElement)this.prevResult.toJson());
            }
            return json;
        }

        @Override
        public boolean isExpired() {
            return this.expireTimeMs <= System.currentTimeMillis();
        }

        public long expireTimeMs() {
            return this.expireTimeMs;
        }

        public String entityToken() {
            return this.entityToken;
        }

        public String entityId() {
            return this.entityId;
        }

        public String sessionTicket() {
            return this.sessionTicket;
        }

        public String playFabId() {
            return this.playFabId;
        }

        @Override
        public StepXblXstsToken.XblXsts<?> prevResult() {
            return this.prevResult;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlayFabToken that = (PlayFabToken)o;
            return this.expireTimeMs == that.expireTimeMs && Objects.equals(this.entityToken, that.entityToken) && Objects.equals(this.entityId, that.entityId) && Objects.equals(this.sessionTicket, that.sessionTicket) && Objects.equals(this.playFabId, that.playFabId) && Objects.equals(this.prevResult, that.prevResult);
        }

        public int hashCode() {
            return Objects.hash(this.expireTimeMs, this.entityToken, this.entityId, this.sessionTicket, this.playFabId, this.prevResult);
        }

        public String toString() {
            return "PlayFabToken{expireTimeMs=" + this.expireTimeMs + ", entityToken='" + this.entityToken + '\'' + ", entityId='" + this.entityId + '\'' + ", sessionTicket='" + this.sessionTicket + '\'' + ", playFabId='" + this.playFabId + '\'' + ", prevResult=" + this.prevResult + '}';
        }
    }
}

