/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.mcauth.step.java;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.raphimc.mcauth.MinecraftAuth;
import net.raphimc.mcauth.step.AbstractStep;
import net.raphimc.mcauth.step.java.StepMCToken;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;

public class StepGameOwnership
extends AbstractStep<StepMCToken.MCToken, GameOwnership> {
    public static final String MINECRAFT_OWNERSHIP_URL = "https://api.minecraftservices.com/entitlements/mcstore";

    public StepGameOwnership(AbstractStep<?, StepMCToken.MCToken> prevStep) {
        super(prevStep);
    }

    @Override
    public GameOwnership applyStep(HttpClient httpClient, StepMCToken.MCToken prevResult) throws Exception {
        MinecraftAuth.LOGGER.info("Getting game ownership...");
        HttpGet httpGet = new HttpGet(MINECRAFT_OWNERSHIP_URL);
        httpGet.addHeader("Authorization", prevResult.token_type() + " " + prevResult.access_token());
        String response = httpClient.execute((HttpUriRequest)httpGet, new BasicResponseHandler());
        JsonObject obj = JsonParser.parseString((String)response).getAsJsonObject();
        ArrayList<String> items = new ArrayList<String>();
        JsonArray itemsArr = obj.getAsJsonArray("items");
        for (JsonElement item : itemsArr) {
            items.add(item.getAsJsonObject().get("name").getAsString());
        }
        GameOwnership result = new GameOwnership(items, prevResult);
        MinecraftAuth.LOGGER.info("Got GameOwnership, games: " + result.items);
        if (!result.items.contains("product_minecraft") || !result.items.contains("game_minecraft")) {
            MinecraftAuth.LOGGER.warn("Microsoft account does not own minecraft!");
        }
        return result;
    }

    @Override
    public GameOwnership fromJson(JsonObject json) throws Exception {
        StepMCToken.MCToken prev = this.prevStep != null ? (StepMCToken.MCToken)this.prevStep.fromJson(json.getAsJsonObject("prev")) : null;
        return new GameOwnership((List)new Gson().fromJson(json.get("items"), List.class), prev);
    }

    public static final class GameOwnership
    implements AbstractStep.StepResult<StepMCToken.MCToken> {
        private final List<String> items;
        private final StepMCToken.MCToken prevResult;

        public GameOwnership(List<String> items, StepMCToken.MCToken prevResult) {
            this.items = items;
            this.prevResult = prevResult;
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.add("items", new Gson().toJsonTree(this.items));
            if (this.prevResult != null) {
                json.add("prev", (JsonElement)this.prevResult.toJson());
            }
            return json;
        }

        public List<String> items() {
            return this.items;
        }

        @Override
        public StepMCToken.MCToken prevResult() {
            return this.prevResult;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            GameOwnership that = (GameOwnership)obj;
            return Objects.equals(this.items, that.items) && Objects.equals(this.prevResult, that.prevResult);
        }

        public int hashCode() {
            return Objects.hash(this.items, this.prevResult);
        }

        public String toString() {
            return "GameOwnership[items=" + this.items + ", prevResult=" + this.prevResult + ']';
        }
    }
}

