/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.mcauth.step.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.UUID;
import net.raphimc.mcauth.MinecraftAuth;
import net.raphimc.mcauth.step.AbstractStep;
import net.raphimc.mcauth.step.java.StepGameOwnership;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;

public class StepMCProfile
extends AbstractStep<StepGameOwnership.GameOwnership, MCProfile> {
    public static final String MINECRAFT_PROFILE_URL = "https://api.minecraftservices.com/minecraft/profile";

    public StepMCProfile(AbstractStep<?, StepGameOwnership.GameOwnership> prevStep) {
        super(prevStep);
    }

    @Override
    public MCProfile applyStep(HttpClient httpClient, StepGameOwnership.GameOwnership prevResult) throws Exception {
        MinecraftAuth.LOGGER.info("Getting profile...");
        HttpGet httpGet = new HttpGet(MINECRAFT_PROFILE_URL);
        httpGet.addHeader("Authorization", prevResult.prevResult().token_type() + " " + prevResult.prevResult().access_token());
        String response = httpClient.execute((HttpUriRequest)httpGet, new BasicResponseHandler());
        JsonObject obj = JsonParser.parseString((String)response).getAsJsonObject();
        if (obj.has("error")) {
            throw new IOException("No valid minecraft profile found: " + obj);
        }
        MCProfile result = new MCProfile(UUID.fromString(obj.get("id").getAsString().replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5")), obj.get("name").getAsString(), new URL(obj.get("skins").getAsJsonArray().get(0).getAsJsonObject().get("url").getAsString()), prevResult);
        MinecraftAuth.LOGGER.info("Got MC Profile, name: " + result.name + ", uuid: " + result.id);
        return result;
    }

    @Override
    public MCProfile fromJson(JsonObject json) throws Exception {
        StepGameOwnership.GameOwnership prev = this.prevStep != null ? (StepGameOwnership.GameOwnership)this.prevStep.fromJson(json.getAsJsonObject("prev")) : null;
        return new MCProfile(UUID.fromString(json.get("id").getAsString()), json.get("name").getAsString(), new URL(json.get("skin_url").getAsString()), prev);
    }

    public static final class MCProfile
    implements AbstractStep.StepResult<StepGameOwnership.GameOwnership> {
        private final UUID id;
        private final String name;
        private final URL skin_url;
        private final StepGameOwnership.GameOwnership prevResult;

        public MCProfile(UUID id, String name, URL skin_url, StepGameOwnership.GameOwnership prevResult) {
            this.id = id;
            this.name = name;
            this.skin_url = skin_url;
            this.prevResult = prevResult;
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("id", this.id.toString());
            json.addProperty("name", this.name);
            json.addProperty("skin_url", this.skin_url.toString());
            if (this.prevResult != null) {
                json.add("prev", (JsonElement)this.prevResult.toJson());
            }
            return json;
        }

        public UUID id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public URL skin_url() {
            return this.skin_url;
        }

        @Override
        public StepGameOwnership.GameOwnership prevResult() {
            return this.prevResult;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            MCProfile that = (MCProfile)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.skin_url, that.skin_url) && Objects.equals(this.prevResult, that.prevResult);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.skin_url, this.prevResult);
        }

        public String toString() {
            return "MCProfile[id=" + this.id + ", name=" + this.name + ", skin_url=" + this.skin_url + ", prevResult=" + this.prevResult + ']';
        }
    }
}

