/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.mcauth.step.msa;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.raphimc.mcauth.step.AbstractStep;
import org.apache.http.client.HttpClient;

public class MsaCodeStep<I extends AbstractStep.StepResult<?>>
extends AbstractStep<I, MsaCode> {
    protected final String clientId;
    protected final String scope;
    protected final String clientSecret;

    public MsaCodeStep(AbstractStep<?, I> prevStep, String clientId, String scope, String clientSecret) {
        super(prevStep);
        this.clientId = clientId;
        this.scope = scope;
        this.clientSecret = clientSecret;
    }

    @Override
    public MsaCode applyStep(HttpClient httpClient, I prevResult) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public MsaCode fromJson(JsonObject json) throws Exception {
        return new MsaCode(json.get("code").getAsString(), json.get("clientId").getAsString(), json.get("scope").getAsString(), json.get("clientSecret") != null ? json.get("clientSecret").getAsString() : null, null);
    }

    public static final class MsaCode
    implements AbstractStep.StepResult<AbstractStep.StepResult<?>> {
        private final String code;
        private final String clientId;
        private final String scope;
        private final String clientSecret;
        private final String redirectUri;

        public MsaCode(String code, String clientId, String scope, String clientSecret, String redirectUri) {
            this.code = code;
            this.clientId = clientId;
            this.scope = scope;
            this.clientSecret = clientSecret;
            this.redirectUri = redirectUri;
        }

        @Override
        public AbstractStep.StepResult<?> prevResult() {
            return null;
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("code", this.code);
            json.addProperty("clientId", this.clientId);
            json.addProperty("scope", this.scope);
            json.addProperty("clientSecret", this.clientSecret);
            return json;
        }

        public String code() {
            return this.code;
        }

        public String clientId() {
            return this.clientId;
        }

        public String scope() {
            return this.scope;
        }

        public String clientSecret() {
            return this.clientSecret;
        }

        public String redirectUri() {
            return this.redirectUri;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MsaCode msaCode = (MsaCode)o;
            return Objects.equals(this.code, msaCode.code) && Objects.equals(this.clientId, msaCode.clientId) && Objects.equals(this.scope, msaCode.scope) && Objects.equals(this.clientSecret, msaCode.clientSecret) && Objects.equals(this.redirectUri, msaCode.redirectUri);
        }

        public int hashCode() {
            return Objects.hash(this.code, this.clientId, this.scope, this.clientSecret, this.redirectUri);
        }

        public String toString() {
            return "MsaCode{code='" + this.code + '\'' + ", clientId='" + this.clientId + '\'' + ", scope='" + this.scope + '\'' + ", clientSecret='" + this.clientSecret + '\'' + ", redirectUri='" + this.redirectUri + '\'' + '}';
        }
    }
}

