/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.mcauth.step.msa;

import com.google.gson.JsonObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.raphimc.mcauth.MinecraftAuth;
import net.raphimc.mcauth.step.AbstractStep;
import net.raphimc.mcauth.step.msa.MsaCodeStep;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class StepCredentialsMsaCode
extends MsaCodeStep<MsaCredentials> {
    public static final String AUTHORIZE_URL = "https://login.live.com/oauth20_authorize.srf";
    private final String redirectUri;

    public StepCredentialsMsaCode(String clientId, String scope, String redirectUri) {
        this(clientId, scope, null, redirectUri);
    }

    public StepCredentialsMsaCode(String clientId, String scope, String clientSecret, String redirectUri) {
        super(null, clientId, scope, clientSecret);
        this.redirectUri = redirectUri;
    }

    @Override
    public MsaCodeStep.MsaCode applyStep(HttpClient httpClient, MsaCredentials prevResult) throws Exception {
        MinecraftAuth.LOGGER.info("Trying to get MSA Code using email and password...");
        if (prevResult == null) {
            throw new IllegalStateException("Missing StepCredentialsMsaCode.MsaCredentials input");
        }
        BasicCookieStore cookieStore = new BasicCookieStore();
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore(cookieStore);
        HttpGet httpGet = new HttpGet(this.getAuthenticationUrl());
        httpGet.setHeader("Accept", ContentType.TEXT_HTML.getMimeType());
        String getResponse = httpClient.execute(httpGet, new BasicResponseHandler(), (HttpContext)context);
        String urlPost = getResponse.substring(getResponse.indexOf("urlPost:"));
        urlPost = urlPost.substring(urlPost.indexOf("'") + 1);
        urlPost = urlPost.substring(0, urlPost.indexOf("'"));
        String sFTTag = getResponse.substring(getResponse.indexOf("sFTTag:"));
        sFTTag = sFTTag.substring(sFTTag.indexOf("value=\""));
        sFTTag = sFTTag.substring(sFTTag.indexOf("\"") + 1);
        sFTTag = sFTTag.substring(0, sFTTag.indexOf("\""));
        ArrayList<BasicNameValuePair> postData = new ArrayList<BasicNameValuePair>();
        postData.add(new BasicNameValuePair("login", prevResult.email));
        postData.add(new BasicNameValuePair("loginfmt", prevResult.email));
        postData.add(new BasicNameValuePair("passwd", prevResult.password));
        postData.add(new BasicNameValuePair("PPFT", sFTTag));
        HttpPost httpPost = new HttpPost(urlPost);
        httpPost.setHeader("Accept", ContentType.TEXT_HTML.getMimeType());
        httpPost.setEntity(new UrlEncodedFormEntity(postData, StandardCharsets.UTF_8));
        try (CloseableHttpResponse postResponse = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)httpPost, context);){
            EntityUtils.consume(postResponse.getEntity());
            StatusLine statusLine = postResponse.getStatusLine();
            if (statusLine.getStatusCode() != 302) {
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            URI redirect = new URI(postResponse.getFirstHeader("Location").getValue());
            String code = URLEncodedUtils.parse(redirect, StandardCharsets.UTF_8).stream().filter(p -> p.getName().equals("code")).map(NameValuePair::getValue).findFirst().orElseThrow(() -> new IllegalStateException("Could not extract code from redirect url"));
            MsaCodeStep.MsaCode result = new MsaCodeStep.MsaCode(code, this.clientId, this.scope, this.clientSecret, this.redirectUri);
            MinecraftAuth.LOGGER.info("Got MSA Code");
            MsaCodeStep.MsaCode msaCode = result;
            return msaCode;
        }
    }

    private URI getAuthenticationUrl() throws URISyntaxException {
        return new URIBuilder(AUTHORIZE_URL).setParameter("client_id", this.clientId).setParameter("redirect_uri", this.redirectUri).setParameter("response_type", "code").setParameter("scope", this.scope).build();
    }

    public static final class MsaCredentials
    implements AbstractStep.InitialInput {
        private final String email;
        private final String password;

        public MsaCredentials(String email, String password) {
            this.email = email;
            this.password = password;
        }

        public static MsaCredentials fromJson(JsonObject json) {
            return new MsaCredentials(json.get("email").getAsString(), json.get("password").getAsString());
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("email", this.email);
            json.addProperty("password", this.password);
            return json;
        }

        public String email() {
            return this.email;
        }

        public String password() {
            return this.password;
        }
    }
}

