/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.mcauth.step.msa;

import com.google.gson.JsonObject;
import java.net.ServerSocket;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.function.Consumer;
import net.raphimc.mcauth.MinecraftAuth;
import net.raphimc.mcauth.step.AbstractStep;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URIBuilder;

public class StepExternalBrowser
extends AbstractStep<ExternalBrowserCallback, ExternalBrowser> {
    public static final String AUTHORIZE_URL = "https://login.live.com/oauth20_authorize.srf";
    private final String clientId;
    private final String scope;
    private final String redirectUri;

    public StepExternalBrowser(String clientId, String scope, String redirectUri) {
        super(null);
        this.clientId = clientId;
        this.scope = scope;
        this.redirectUri = redirectUri;
        if (this.redirectUri.endsWith("/")) {
            throw new IllegalArgumentException("Redirect URI must not end with a slash");
        }
    }

    @Override
    public ExternalBrowser applyStep(HttpClient httpClient, ExternalBrowserCallback prevResult) throws Exception {
        MinecraftAuth.LOGGER.info("Creating URL for MSA login via external browser...");
        if (prevResult == null) {
            throw new IllegalStateException("Missing StepExternalBrowser.ExternalBrowserCallback input");
        }
        try (ServerSocket localServer = new ServerSocket(0);){
            int localPort = localServer.getLocalPort();
            ExternalBrowser result = new ExternalBrowser(this.getAuthenticationUrl(localPort), this.redirectUri + ":" + localPort, localPort);
            MinecraftAuth.LOGGER.info("Created external browser MSA authentication URL: " + result.authenticationUrl);
            prevResult.callback.accept(result);
            ExternalBrowser externalBrowser = result;
            return externalBrowser;
        }
    }

    @Override
    public ExternalBrowser fromJson(JsonObject json) throws Exception {
        return new ExternalBrowser(json.get("authenticationUrl").getAsString(), json.get("redirectUri").getAsString(), json.get("port").getAsInt());
    }

    private String getAuthenticationUrl(int localPort) throws URISyntaxException {
        return new URIBuilder(AUTHORIZE_URL).setParameter("client_id", this.clientId).setParameter("redirect_uri", this.redirectUri + ":" + localPort).setParameter("response_type", "code").setParameter("prompt", "select_account").setParameter("scope", this.scope).build().toString();
    }

    public static final class ExternalBrowserCallback
    implements AbstractStep.InitialInput {
        private final Consumer<ExternalBrowser> callback;

        public ExternalBrowserCallback(Consumer<ExternalBrowser> callback) {
            this.callback = callback;
        }

        public Consumer<ExternalBrowser> callback() {
            return this.callback;
        }
    }

    public static final class ExternalBrowser
    implements AbstractStep.StepResult<AbstractStep.StepResult<?>> {
        private final String authenticationUrl;
        private final String redirectUri;
        private final int port;

        public ExternalBrowser(String authenticationUrl, String redirectUri, int port) {
            this.authenticationUrl = authenticationUrl;
            this.redirectUri = redirectUri;
            this.port = port;
        }

        @Override
        public AbstractStep.StepResult<?> prevResult() {
            return null;
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("authenticationUrl", this.authenticationUrl);
            json.addProperty("redirectUri", this.redirectUri);
            json.addProperty("port", (Number)this.port);
            return json;
        }

        public String authenticationUrl() {
            return this.authenticationUrl;
        }

        public String redirectUri() {
            return this.redirectUri;
        }

        public int port() {
            return this.port;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ExternalBrowser that = (ExternalBrowser)obj;
            return Objects.equals(this.authenticationUrl, that.authenticationUrl) && Objects.equals(this.redirectUri, that.redirectUri) && this.port == that.port;
        }

        public int hashCode() {
            return Objects.hash(this.authenticationUrl, this.redirectUri, this.port);
        }

        public String toString() {
            return "ExternalBrowser[authenticationUrl=" + this.authenticationUrl + ", redirectUri=" + this.redirectUri + ", port=" + this.port + ']';
        }
    }
}

