/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.mcauth.step.msa;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import net.raphimc.mcauth.MinecraftAuth;
import net.raphimc.mcauth.step.AbstractStep;
import net.raphimc.mcauth.util.MsaResponseHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;

public class StepMsaDeviceCode
extends AbstractStep<MsaDeviceCodeCallback, MsaDeviceCode> {
    public static final String CONNECT_URL = "https://login.live.com/oauth20_connect.srf";
    private final String clientId;
    private final String scope;

    public StepMsaDeviceCode(String clientId, String scope) {
        super(null);
        this.clientId = clientId;
        this.scope = scope;
    }

    @Override
    public MsaDeviceCode applyStep(HttpClient httpClient, MsaDeviceCodeCallback prevResult) throws Exception {
        MinecraftAuth.LOGGER.info("Getting device code for MSA login...");
        if (prevResult == null) {
            throw new IllegalStateException("Missing StepMsaDeviceCode.MsaDeviceCodeCallback input");
        }
        ArrayList<BasicNameValuePair> postData = new ArrayList<BasicNameValuePair>();
        postData.add(new BasicNameValuePair("client_id", this.clientId));
        postData.add(new BasicNameValuePair("response_type", "device_code"));
        postData.add(new BasicNameValuePair("scope", this.scope));
        HttpPost httpPost = new HttpPost(CONNECT_URL);
        httpPost.setEntity(new UrlEncodedFormEntity(postData, StandardCharsets.UTF_8));
        String response = httpClient.execute((HttpUriRequest)httpPost, new MsaResponseHandler());
        JsonObject obj = JsonParser.parseString((String)response).getAsJsonObject();
        MsaDeviceCode result = new MsaDeviceCode(System.currentTimeMillis() + obj.get("expires_in").getAsLong() * 1000L, obj.get("interval").getAsLong() * 1000L, obj.get("device_code").getAsString(), obj.get("user_code").getAsString(), obj.get("verification_uri").getAsString());
        MinecraftAuth.LOGGER.info("Got MSA device code, expires: " + Instant.ofEpochMilli(result.expireTimeMs).atZone(ZoneId.systemDefault()));
        prevResult.callback.accept(result);
        return result;
    }

    @Override
    public MsaDeviceCode fromJson(JsonObject json) throws Exception {
        return new MsaDeviceCode(json.get("expireTimeMs").getAsLong(), json.get("intervalMs").getAsLong(), json.get("deviceCode").getAsString(), json.get("userCode").getAsString(), json.get("verificationUrl").getAsString());
    }

    public static final class MsaDeviceCodeCallback
    implements AbstractStep.InitialInput {
        private final Consumer<MsaDeviceCode> callback;

        public MsaDeviceCodeCallback(Consumer<MsaDeviceCode> callback) {
            this.callback = callback;
        }

        public Consumer<MsaDeviceCode> callback() {
            return this.callback;
        }
    }

    public static final class MsaDeviceCode
    implements AbstractStep.StepResult<AbstractStep.StepResult<?>> {
        private final long expireTimeMs;
        private final long intervalMs;
        private final String deviceCode;
        private final String userCode;
        private final String verificationUri;

        public MsaDeviceCode(long expireTimeMs, long intervalMs, String deviceCode, String userCode, String verificationUri) {
            this.expireTimeMs = expireTimeMs;
            this.intervalMs = intervalMs;
            this.deviceCode = deviceCode;
            this.userCode = userCode;
            this.verificationUri = verificationUri;
        }

        @Override
        public AbstractStep.StepResult<?> prevResult() {
            return null;
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("expireTimeMs", (Number)this.expireTimeMs);
            json.addProperty("intervalMs", (Number)this.intervalMs);
            json.addProperty("deviceCode", this.deviceCode);
            json.addProperty("userCode", this.userCode);
            json.addProperty("verificationUri", this.verificationUri);
            return json;
        }

        @Override
        public boolean isExpired() throws Exception {
            return this.expireTimeMs <= System.currentTimeMillis();
        }

        public long expireTimeMs() {
            return this.expireTimeMs;
        }

        public long intervalMs() {
            return this.intervalMs;
        }

        public String deviceCode() {
            return this.deviceCode;
        }

        public String userCode() {
            return this.userCode;
        }

        public String verificationUri() {
            return this.verificationUri;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            MsaDeviceCode that = (MsaDeviceCode)obj;
            return this.expireTimeMs == that.expireTimeMs && this.intervalMs == that.intervalMs && Objects.equals(this.deviceCode, that.deviceCode) && Objects.equals(this.userCode, that.userCode) && Objects.equals(this.verificationUri, that.verificationUri);
        }

        public int hashCode() {
            return Objects.hash(this.expireTimeMs, this.intervalMs, this.deviceCode, this.userCode, this.verificationUri);
        }

        public String toString() {
            return "MsaDeviceCode[expireTimeMs=" + this.expireTimeMs + ", intervalMs=" + this.intervalMs + ", deviceCode=" + this.deviceCode + ", userCode=" + this.userCode + ", verificationUri=" + this.verificationUri + ']';
        }
    }
}

