/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.mcauth.step.msa;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import net.raphimc.mcauth.MinecraftAuth;
import net.raphimc.mcauth.step.AbstractStep;
import net.raphimc.mcauth.step.msa.MsaCodeStep;
import net.raphimc.mcauth.step.msa.StepMsaDeviceCode;
import net.raphimc.mcauth.util.MsaResponseHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;

public class StepMsaDeviceCodeMsaCode
extends MsaCodeStep<StepMsaDeviceCode.MsaDeviceCode> {
    public static final String TOKEN_URL = "https://login.live.com/oauth20_token.srf";
    private final int timeout;

    public StepMsaDeviceCodeMsaCode(AbstractStep<?, StepMsaDeviceCode.MsaDeviceCode> prevStep, String clientId, String scope, int timeout) {
        this(prevStep, clientId, scope, null, timeout);
    }

    public StepMsaDeviceCodeMsaCode(AbstractStep<?, StepMsaDeviceCode.MsaDeviceCode> prevStep, String clientId, String scope, String clientSecret, int timeout) {
        super(prevStep, clientId, scope, clientSecret);
        this.timeout = timeout;
    }

    @Override
    public MsaCodeStep.MsaCode applyStep(HttpClient httpClient, StepMsaDeviceCode.MsaDeviceCode prevResult) throws Exception {
        MinecraftAuth.LOGGER.info("Waiting for MSA login via device code...");
        long start = System.currentTimeMillis();
        while (!prevResult.isExpired() && System.currentTimeMillis() - start <= (long)this.timeout) {
            ArrayList<BasicNameValuePair> postData = new ArrayList<BasicNameValuePair>();
            postData.add(new BasicNameValuePair("client_id", this.clientId));
            postData.add(new BasicNameValuePair("device_code", prevResult.deviceCode()));
            postData.add(new BasicNameValuePair("grant_type", "device_code"));
            HttpPost httpPost = new HttpPost(TOKEN_URL);
            httpPost.setEntity(new UrlEncodedFormEntity(postData, StandardCharsets.UTF_8));
            try {
                String response = httpClient.execute((HttpUriRequest)httpPost, new MsaResponseHandler());
                JsonObject obj = JsonParser.parseString((String)response).getAsJsonObject();
                MsaCodeStep.MsaCode result = new MsaCodeStep.MsaCode(obj.get("refresh_token").getAsString(), this.clientId, this.scope, this.clientSecret, null);
                MinecraftAuth.LOGGER.info("Got MSA Code");
                return result;
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 400 && e.getReasonPhrase().startsWith("authorization_pending")) {
                    Thread.sleep(prevResult.intervalMs());
                    continue;
                }
                throw e;
            }
        }
        throw new TimeoutException("Failed to get MSA Code. Login timed out");
    }
}

