/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.mcauth.step.xbl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import net.raphimc.mcauth.MinecraftAuth;
import net.raphimc.mcauth.step.AbstractStep;
import net.raphimc.mcauth.util.CryptUtil;
import net.raphimc.mcauth.util.XblResponseHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class StepXblDeviceToken
extends AbstractStep<AbstractStep.StepResult<?>, XblDeviceToken> {
    public static final String XBL_DEVICE_URL = "https://device.auth.xboxlive.com/device/authenticate";
    private final String deviceType;

    public StepXblDeviceToken(String deviceType) {
        super(null);
        this.deviceType = deviceType;
    }

    @Override
    public XblDeviceToken applyStep(HttpClient httpClient, AbstractStep.StepResult<?> prevResult) throws Exception {
        MinecraftAuth.LOGGER.info("Authenticating device with Xbox Live...");
        UUID id = UUID.randomUUID();
        KeyPairGenerator secp256r1 = KeyPairGenerator.getInstance("EC");
        secp256r1.initialize(new ECGenParameterSpec("secp256r1"));
        KeyPair ecdsa256KeyPair = secp256r1.generateKeyPair();
        ECPublicKey publicKey = (ECPublicKey)ecdsa256KeyPair.getPublic();
        ECPrivateKey privateKey = (ECPrivateKey)ecdsa256KeyPair.getPrivate();
        JsonObject postData = new JsonObject();
        JsonObject properties = new JsonObject();
        properties.addProperty("AuthMethod", "ProofOfPossession");
        properties.addProperty("DeviceType", this.deviceType);
        properties.addProperty("Id", "{" + id + "}");
        properties.add("ProofKey", (JsonElement)CryptUtil.getProofKey(publicKey));
        properties.addProperty("Version", "0.0.0");
        postData.add("Properties", (JsonElement)properties);
        postData.addProperty("RelyingParty", "http://auth.xboxlive.com");
        postData.addProperty("TokenType", "JWT");
        HttpPost httpPost = new HttpPost(XBL_DEVICE_URL);
        httpPost.setEntity(new StringEntity(postData.toString(), ContentType.APPLICATION_JSON));
        httpPost.addHeader("x-xbl-contract-version", "1");
        httpPost.addHeader(CryptUtil.getSignatureHeader(httpPost, privateKey));
        String response = httpClient.execute((HttpUriRequest)httpPost, new XblResponseHandler());
        JsonObject obj = JsonParser.parseString((String)response).getAsJsonObject();
        XblDeviceToken result = new XblDeviceToken(publicKey, privateKey, id, Instant.parse(obj.get("NotAfter").getAsString()).toEpochMilli(), obj.get("Token").getAsString(), obj.getAsJsonObject("DisplayClaims").getAsJsonObject("xdi").get("did").getAsString());
        MinecraftAuth.LOGGER.info("Got XBL Device Token, expires: " + Instant.ofEpochMilli(result.expireTimeMs).atZone(ZoneId.systemDefault()));
        return result;
    }

    @Override
    public XblDeviceToken refresh(HttpClient httpClient, XblDeviceToken result) throws Exception {
        if (result == null || result.isExpired()) {
            return this.applyStep(httpClient, (AbstractStep.StepResult)null);
        }
        return result;
    }

    @Override
    public XblDeviceToken fromJson(JsonObject json) throws Exception {
        return new XblDeviceToken((ECPublicKey)CryptUtil.EC_KEYFACTORY.generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode(json.get("publicKey").getAsString()))), (ECPrivateKey)CryptUtil.EC_KEYFACTORY.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(json.get("privateKey").getAsString()))), UUID.fromString(json.get("id").getAsString()), json.get("expireTimeMs").getAsLong(), json.get("token").getAsString(), json.get("deviceId").getAsString());
    }

    public static final class XblDeviceToken
    implements AbstractStep.StepResult<AbstractStep.StepResult<?>> {
        private final ECPublicKey publicKey;
        private final ECPrivateKey privateKey;
        private final UUID id;
        private final long expireTimeMs;
        private final String token;
        private final String deviceId;

        public XblDeviceToken(ECPublicKey publicKey, ECPrivateKey privateKey, UUID id, long expireTimeMs, String token, String deviceId) {
            this.publicKey = publicKey;
            this.privateKey = privateKey;
            this.id = id;
            this.expireTimeMs = expireTimeMs;
            this.token = token;
            this.deviceId = deviceId;
        }

        @Override
        public AbstractStep.StepResult<?> prevResult() {
            return null;
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("publicKey", Base64.getEncoder().encodeToString(this.publicKey.getEncoded()));
            json.addProperty("privateKey", Base64.getEncoder().encodeToString(this.privateKey.getEncoded()));
            json.addProperty("id", this.id.toString());
            json.addProperty("expireTimeMs", (Number)this.expireTimeMs);
            json.addProperty("token", this.token);
            json.addProperty("deviceId", this.deviceId);
            return json;
        }

        @Override
        public boolean isExpired() {
            return this.expireTimeMs <= System.currentTimeMillis();
        }

        public ECPublicKey publicKey() {
            return this.publicKey;
        }

        public ECPrivateKey privateKey() {
            return this.privateKey;
        }

        public UUID id() {
            return this.id;
        }

        public long expireTimeMs() {
            return this.expireTimeMs;
        }

        public String token() {
            return this.token;
        }

        public String deviceId() {
            return this.deviceId;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            XblDeviceToken that = (XblDeviceToken)obj;
            return Objects.equals(this.publicKey, that.publicKey) && Objects.equals(this.privateKey, that.privateKey) && Objects.equals(this.id, that.id) && this.expireTimeMs == that.expireTimeMs && Objects.equals(this.token, that.token) && Objects.equals(this.deviceId, that.deviceId);
        }

        public int hashCode() {
            return Objects.hash(this.publicKey, this.privateKey, this.id, this.expireTimeMs, this.token, this.deviceId);
        }

        public String toString() {
            return "XblDeviceToken[publicKey=" + this.publicKey + ", privateKey=" + this.privateKey + ", id=" + this.id + ", expireTimeMs=" + this.expireTimeMs + ", token=" + this.token + ", deviceId=" + this.deviceId + ']';
        }
    }
}

