/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.mcauth.step.xbl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Objects;
import net.raphimc.mcauth.MinecraftAuth;
import net.raphimc.mcauth.step.AbstractStep;
import net.raphimc.mcauth.step.xbl.StepXblTitleToken;
import net.raphimc.mcauth.step.xbl.StepXblUserToken;
import net.raphimc.mcauth.step.xbl.StepXblXstsToken;
import net.raphimc.mcauth.step.xbl.session.StepFullXblSession;
import net.raphimc.mcauth.step.xbl.session.StepInitialXblSession;
import net.raphimc.mcauth.util.CryptUtil;
import net.raphimc.mcauth.util.XblResponseHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class StepXblSisuAuthentication
extends AbstractStep<StepInitialXblSession.InitialXblSession, StepXblXstsToken.XblXsts<?>> {
    public static final String XBL_SISU_URL = "https://sisu.xboxlive.com/authorize";
    private final String relyingParty;

    public StepXblSisuAuthentication(AbstractStep<?, StepInitialXblSession.InitialXblSession> prevStep, String relyingParty) {
        super(prevStep);
        this.relyingParty = relyingParty;
    }

    @Override
    public XblSisuTokens applyStep(HttpClient httpClient, StepInitialXblSession.InitialXblSession prevResult) throws Exception {
        MinecraftAuth.LOGGER.info("Authenticating with Xbox Live using SISU...");
        if (prevResult.prevResult2() == null) {
            throw new IllegalStateException("A XBL Device Token is needed for SISU authentication");
        }
        JsonObject postData = new JsonObject();
        postData.addProperty("AccessToken", "t=" + prevResult.prevResult().access_token());
        postData.addProperty("DeviceToken", prevResult.prevResult2().token());
        postData.addProperty("AppId", prevResult.prevResult().prevResult().clientId());
        postData.add("ProofKey", (JsonElement)CryptUtil.getProofKey(prevResult.prevResult2().publicKey()));
        postData.addProperty("SiteName", "user.auth.xboxlive.com");
        postData.addProperty("RelyingParty", this.relyingParty);
        postData.addProperty("Sandbox", "RETAIL");
        postData.addProperty("UseModernGamertag", Boolean.valueOf(true));
        HttpPost httpPost = new HttpPost(XBL_SISU_URL);
        httpPost.setEntity(new StringEntity(postData.toString(), ContentType.APPLICATION_JSON));
        httpPost.addHeader(CryptUtil.getSignatureHeader(httpPost, prevResult.prevResult2().privateKey()));
        String response = httpClient.execute((HttpUriRequest)httpPost, new XblResponseHandler());
        JsonObject obj = JsonParser.parseString((String)response).getAsJsonObject();
        XblSisuTokens result = new XblSisuTokens(new XblSisuTokens.SisuTitleToken(Instant.parse(obj.getAsJsonObject("TitleToken").get("NotAfter").getAsString()).toEpochMilli(), obj.getAsJsonObject("TitleToken").get("Token").getAsString(), obj.getAsJsonObject("TitleToken").getAsJsonObject("DisplayClaims").getAsJsonObject("xti").get("tid").getAsString()), new XblSisuTokens.SisuUserToken(Instant.parse(obj.getAsJsonObject("UserToken").get("NotAfter").getAsString()).toEpochMilli(), obj.getAsJsonObject("UserToken").get("Token").getAsString(), obj.getAsJsonObject("UserToken").getAsJsonObject("DisplayClaims").getAsJsonArray("xui").get(0).getAsJsonObject().get("uhs").getAsString()), new XblSisuTokens.SisuXstsToken(Instant.parse(obj.getAsJsonObject("AuthorizationToken").get("NotAfter").getAsString()).toEpochMilli(), obj.getAsJsonObject("AuthorizationToken").get("Token").getAsString(), obj.getAsJsonObject("AuthorizationToken").getAsJsonObject("DisplayClaims").getAsJsonArray("xui").get(0).getAsJsonObject().get("uhs").getAsString()), prevResult);
        MinecraftAuth.LOGGER.info("Got XBL Title+User+XSTS Token, expires: " + Instant.ofEpochMilli(result.expireTimeMs()).atZone(ZoneId.systemDefault()));
        return result;
    }

    @Override
    public StepXblXstsToken.XblXsts<?> refresh(HttpClient httpClient, StepXblXstsToken.XblXsts<?> result) throws Exception {
        if (result == null || result.isExpired()) {
            return super.refresh(httpClient, result);
        }
        return result;
    }

    @Override
    public XblSisuTokens fromJson(JsonObject json) throws Exception {
        StepInitialXblSession.InitialXblSession prev = this.prevStep != null ? (StepInitialXblSession.InitialXblSession)this.prevStep.fromJson(json.getAsJsonObject("prev")) : null;
        return new XblSisuTokens(XblSisuTokens.SisuTitleToken.fromJson(json.getAsJsonObject("titleToken")), XblSisuTokens.SisuUserToken.fromJson(json.getAsJsonObject("userToken")), XblSisuTokens.SisuXstsToken.fromJson(json.getAsJsonObject("xstsToken")), prev);
    }

    public static final class XblSisuTokens
    implements AbstractStep.StepResult<StepInitialXblSession.InitialXblSession>,
    StepXblXstsToken.XblXsts<StepInitialXblSession.InitialXblSession> {
        private final SisuTitleToken titleToken;
        private final SisuUserToken userToken;
        private final SisuXstsToken xstsToken;
        private final StepInitialXblSession.InitialXblSession prevResult;

        public XblSisuTokens(SisuTitleToken titleToken, SisuUserToken userToken, SisuXstsToken xstsToken, StepInitialXblSession.InitialXblSession prevResult) {
            this.titleToken = titleToken;
            this.userToken = userToken;
            this.xstsToken = xstsToken;
            this.prevResult = prevResult;
        }

        @Override
        public long expireTimeMs() {
            return Math.min(Math.min(this.xstsToken.expireTimeMs, this.titleToken.expireTimeMs), this.userToken.expireTimeMs);
        }

        @Override
        public String token() {
            return this.xstsToken.token;
        }

        @Override
        public String userHash() {
            return this.xstsToken.userHash;
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.add("titleToken", (JsonElement)this.titleToken.toJson());
            json.add("userToken", (JsonElement)this.userToken.toJson());
            json.add("xstsToken", (JsonElement)this.xstsToken.toJson());
            if (this.prevResult != null) {
                json.add("prev", (JsonElement)this.prevResult.toJson());
            }
            return json;
        }

        @Override
        public boolean isExpired() {
            return this.expireTimeMs() <= System.currentTimeMillis();
        }

        @Override
        public StepFullXblSession.FullXblSession fullXblSession() {
            StepXblUserToken.XblUserToken userToken = new StepXblUserToken.XblUserToken(this.userToken.expireTimeMs, this.userToken.token, this.userToken.userHash, this.prevResult);
            StepXblTitleToken.XblTitleToken titleToken = new StepXblTitleToken.XblTitleToken(this.titleToken.expireTimeMs, this.titleToken.token, this.titleToken.titleId, this.prevResult);
            return new StepFullXblSession.FullXblSession(userToken, titleToken);
        }

        public SisuTitleToken titleToken() {
            return this.titleToken;
        }

        public SisuUserToken userToken() {
            return this.userToken;
        }

        public SisuXstsToken xstsToken() {
            return this.xstsToken;
        }

        @Override
        public StepInitialXblSession.InitialXblSession prevResult() {
            return this.prevResult;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            XblSisuTokens that = (XblSisuTokens)obj;
            return Objects.equals(this.titleToken, that.titleToken) && Objects.equals(this.userToken, that.userToken) && Objects.equals(this.xstsToken, that.xstsToken) && Objects.equals(this.prevResult, that.prevResult);
        }

        public int hashCode() {
            return Objects.hash(this.titleToken, this.userToken, this.xstsToken, this.prevResult);
        }

        public String toString() {
            return "XblSisuTokens[titleToken=" + this.titleToken + ", userToken=" + this.userToken + ", xstsToken=" + this.xstsToken + ", prevResult=" + this.prevResult + ']';
        }

        public static final class SisuXstsToken {
            private final long expireTimeMs;
            private final String token;
            private final String userHash;

            public SisuXstsToken(long expireTimeMs, String token, String userHash) {
                this.expireTimeMs = expireTimeMs;
                this.token = token;
                this.userHash = userHash;
            }

            public static SisuXstsToken fromJson(JsonObject json) {
                return new SisuXstsToken(json.get("expireTimeMs").getAsLong(), json.get("token").getAsString(), json.get("userHash").getAsString());
            }

            public JsonObject toJson() {
                JsonObject json = new JsonObject();
                json.addProperty("expireTimeMs", (Number)this.expireTimeMs);
                json.addProperty("token", this.token);
                json.addProperty("userHash", this.userHash);
                return json;
            }

            public long expireTimeMs() {
                return this.expireTimeMs;
            }

            public String token() {
                return this.token;
            }

            public String userHash() {
                return this.userHash;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                SisuXstsToken that = (SisuXstsToken)obj;
                return this.expireTimeMs == that.expireTimeMs && Objects.equals(this.token, that.token) && Objects.equals(this.userHash, that.userHash);
            }

            public int hashCode() {
                return Objects.hash(this.expireTimeMs, this.token, this.userHash);
            }

            public String toString() {
                return "SisuXstsToken[expireTimeMs=" + this.expireTimeMs + ", token=" + this.token + ", userHash=" + this.userHash + ']';
            }
        }

        public static final class SisuUserToken {
            private final long expireTimeMs;
            private final String token;
            private final String userHash;

            public SisuUserToken(long expireTimeMs, String token, String userHash) {
                this.expireTimeMs = expireTimeMs;
                this.token = token;
                this.userHash = userHash;
            }

            public static SisuUserToken fromJson(JsonObject json) {
                return new SisuUserToken(json.get("expireTimeMs").getAsLong(), json.get("token").getAsString(), json.get("userHash").getAsString());
            }

            public JsonObject toJson() {
                JsonObject json = new JsonObject();
                json.addProperty("expireTimeMs", (Number)this.expireTimeMs);
                json.addProperty("token", this.token);
                json.addProperty("userHash", this.userHash);
                return json;
            }

            public long expireTimeMs() {
                return this.expireTimeMs;
            }

            public String token() {
                return this.token;
            }

            public String userHash() {
                return this.userHash;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                SisuUserToken that = (SisuUserToken)obj;
                return this.expireTimeMs == that.expireTimeMs && Objects.equals(this.token, that.token) && Objects.equals(this.userHash, that.userHash);
            }

            public int hashCode() {
                return Objects.hash(this.expireTimeMs, this.token, this.userHash);
            }

            public String toString() {
                return "SisuUserToken[expireTimeMs=" + this.expireTimeMs + ", token=" + this.token + ", userHash=" + this.userHash + ']';
            }
        }

        public static final class SisuTitleToken {
            private final long expireTimeMs;
            private final String token;
            private final String titleId;

            public SisuTitleToken(long expireTimeMs, String token, String titleId) {
                this.expireTimeMs = expireTimeMs;
                this.token = token;
                this.titleId = titleId;
            }

            public static SisuTitleToken fromJson(JsonObject json) {
                return new SisuTitleToken(json.get("expireTimeMs").getAsLong(), json.get("token").getAsString(), json.get("titleId").getAsString());
            }

            public JsonObject toJson() {
                JsonObject json = new JsonObject();
                json.addProperty("expireTimeMs", (Number)this.expireTimeMs);
                json.addProperty("token", this.token);
                json.addProperty("titleId", this.titleId);
                return json;
            }

            public long expireTimeMs() {
                return this.expireTimeMs;
            }

            public String token() {
                return this.token;
            }

            public String titleId() {
                return this.titleId;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                SisuTitleToken that = (SisuTitleToken)obj;
                return this.expireTimeMs == that.expireTimeMs && Objects.equals(this.token, that.token) && Objects.equals(this.titleId, that.titleId);
            }

            public int hashCode() {
                return Objects.hash(this.expireTimeMs, this.token, this.titleId);
            }

            public String toString() {
                return "SisuTitleToken[expireTimeMs=" + this.expireTimeMs + ", token=" + this.token + ", titleId=" + this.titleId + ']';
            }
        }
    }
}

