/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.mcauth.step.xbl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Objects;
import net.raphimc.mcauth.MinecraftAuth;
import net.raphimc.mcauth.step.AbstractStep;
import net.raphimc.mcauth.step.xbl.session.StepInitialXblSession;
import net.raphimc.mcauth.util.CryptUtil;
import net.raphimc.mcauth.util.XblResponseHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class StepXblTitleToken
extends AbstractStep<StepInitialXblSession.InitialXblSession, XblTitleToken> {
    public static final String XBL_TITLE_URL = "https://title.auth.xboxlive.com/title/authenticate";

    public StepXblTitleToken(AbstractStep<?, StepInitialXblSession.InitialXblSession> prevStep) {
        super(prevStep);
    }

    @Override
    public XblTitleToken applyStep(HttpClient httpClient, StepInitialXblSession.InitialXblSession prevResult) throws Exception {
        MinecraftAuth.LOGGER.info("Authenticating title with Xbox Live...");
        if (prevResult.prevResult2() == null) {
            throw new IllegalStateException("A XBL Device Token is needed for Title authentication");
        }
        JsonObject postData = new JsonObject();
        JsonObject properties = new JsonObject();
        properties.addProperty("AuthMethod", "RPS");
        properties.addProperty("SiteName", "user.auth.xboxlive.com");
        properties.addProperty("RpsTicket", "t=" + prevResult.prevResult().access_token());
        properties.addProperty("DeviceToken", prevResult.prevResult2().token());
        properties.add("ProofKey", (JsonElement)CryptUtil.getProofKey(prevResult.prevResult2().publicKey()));
        postData.add("Properties", (JsonElement)properties);
        postData.addProperty("RelyingParty", "http://auth.xboxlive.com");
        postData.addProperty("TokenType", "JWT");
        HttpPost httpPost = new HttpPost(XBL_TITLE_URL);
        httpPost.setEntity(new StringEntity(postData.toString(), ContentType.APPLICATION_JSON));
        httpPost.addHeader("x-xbl-contract-version", "1");
        httpPost.addHeader(CryptUtil.getSignatureHeader(httpPost, prevResult.prevResult2().privateKey()));
        String response = httpClient.execute((HttpUriRequest)httpPost, new XblResponseHandler());
        JsonObject obj = JsonParser.parseString((String)response).getAsJsonObject();
        XblTitleToken result = new XblTitleToken(Instant.parse(obj.get("NotAfter").getAsString()).toEpochMilli(), obj.get("Token").getAsString(), obj.getAsJsonObject("DisplayClaims").getAsJsonObject("xti").get("tid").getAsString(), prevResult);
        MinecraftAuth.LOGGER.info("Got XBL Title Token, expires: " + Instant.ofEpochMilli(result.expireTimeMs).atZone(ZoneId.systemDefault()));
        return result;
    }

    @Override
    public XblTitleToken refresh(HttpClient httpClient, XblTitleToken result) throws Exception {
        if (result == null || result.isExpired()) {
            return super.refresh(httpClient, result);
        }
        return result;
    }

    @Override
    public XblTitleToken fromJson(JsonObject json) throws Exception {
        StepInitialXblSession.InitialXblSession prev = this.prevStep != null ? (StepInitialXblSession.InitialXblSession)this.prevStep.fromJson(json.getAsJsonObject("prev")) : null;
        return new XblTitleToken(json.get("expireTimeMs").getAsLong(), json.get("token").getAsString(), json.get("userHash").getAsString(), prev);
    }

    public static final class XblTitleToken
    implements AbstractStep.StepResult<StepInitialXblSession.InitialXblSession> {
        private final long expireTimeMs;
        private final String token;
        private final String titleId;
        private final StepInitialXblSession.InitialXblSession prevResult;

        public XblTitleToken(long expireTimeMs, String token, String titleId, StepInitialXblSession.InitialXblSession prevResult) {
            this.expireTimeMs = expireTimeMs;
            this.token = token;
            this.titleId = titleId;
            this.prevResult = prevResult;
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("expireTimeMs", (Number)this.expireTimeMs);
            json.addProperty("token", this.token);
            json.addProperty("titleId", this.titleId);
            if (this.prevResult != null) {
                json.add("prev", (JsonElement)this.prevResult.toJson());
            }
            return json;
        }

        @Override
        public boolean isExpired() {
            return this.expireTimeMs <= System.currentTimeMillis();
        }

        public long expireTimeMs() {
            return this.expireTimeMs;
        }

        public String token() {
            return this.token;
        }

        public String titleId() {
            return this.titleId;
        }

        @Override
        public StepInitialXblSession.InitialXblSession prevResult() {
            return this.prevResult;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            XblTitleToken that = (XblTitleToken)obj;
            return this.expireTimeMs == that.expireTimeMs && Objects.equals(this.token, that.token) && Objects.equals(this.titleId, that.titleId) && Objects.equals(this.prevResult, that.prevResult);
        }

        public int hashCode() {
            return Objects.hash(this.expireTimeMs, this.token, this.titleId, this.prevResult);
        }

        public String toString() {
            return "XblTitleToken[expireTimeMs=" + this.expireTimeMs + ", token=" + this.token + ", titleId=" + this.titleId + ", prevResult=" + this.prevResult + ']';
        }
    }
}

