/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.mcauth.step.xbl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Objects;
import net.raphimc.mcauth.MinecraftAuth;
import net.raphimc.mcauth.step.AbstractStep;
import net.raphimc.mcauth.step.xbl.session.StepInitialXblSession;
import net.raphimc.mcauth.util.CryptUtil;
import net.raphimc.mcauth.util.XblResponseHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class StepXblUserToken
extends AbstractStep<StepInitialXblSession.InitialXblSession, XblUserToken> {
    public static final String XBL_USER_URL = "https://user.auth.xboxlive.com/user/authenticate";

    public StepXblUserToken(AbstractStep<?, StepInitialXblSession.InitialXblSession> prevStep) {
        super(prevStep);
    }

    @Override
    public XblUserToken applyStep(HttpClient httpClient, StepInitialXblSession.InitialXblSession prevResult) throws Exception {
        MinecraftAuth.LOGGER.info("Authenticating user with Xbox Live...");
        JsonObject postData = new JsonObject();
        JsonObject properties = new JsonObject();
        properties.addProperty("AuthMethod", "RPS");
        properties.addProperty("SiteName", "user.auth.xboxlive.com");
        properties.addProperty("RpsTicket", (prevResult.prevResult().isTitleClientId() ? "t=" : "d=") + prevResult.prevResult().access_token());
        if (prevResult.prevResult2() != null) {
            properties.add("ProofKey", (JsonElement)CryptUtil.getProofKey(prevResult.prevResult2().publicKey()));
        }
        postData.add("Properties", (JsonElement)properties);
        postData.addProperty("RelyingParty", "http://auth.xboxlive.com");
        postData.addProperty("TokenType", "JWT");
        HttpPost httpPost = new HttpPost(XBL_USER_URL);
        httpPost.setEntity(new StringEntity(postData.toString(), ContentType.APPLICATION_JSON));
        httpPost.addHeader("x-xbl-contract-version", "1");
        if (prevResult.prevResult2() != null) {
            httpPost.addHeader(CryptUtil.getSignatureHeader(httpPost, prevResult.prevResult2().privateKey()));
        }
        String response = httpClient.execute((HttpUriRequest)httpPost, new XblResponseHandler());
        JsonObject obj = JsonParser.parseString((String)response).getAsJsonObject();
        XblUserToken result = new XblUserToken(Instant.parse(obj.get("NotAfter").getAsString()).toEpochMilli(), obj.get("Token").getAsString(), obj.getAsJsonObject("DisplayClaims").getAsJsonArray("xui").get(0).getAsJsonObject().get("uhs").getAsString(), prevResult);
        MinecraftAuth.LOGGER.info("Got XBL User Token, expires: " + Instant.ofEpochMilli(result.expireTimeMs).atZone(ZoneId.systemDefault()));
        return result;
    }

    @Override
    public XblUserToken refresh(HttpClient httpClient, XblUserToken result) throws Exception {
        if (result == null || result.isExpired()) {
            return super.refresh(httpClient, result);
        }
        return result;
    }

    @Override
    public XblUserToken fromJson(JsonObject json) throws Exception {
        StepInitialXblSession.InitialXblSession prev = this.prevStep != null ? (StepInitialXblSession.InitialXblSession)this.prevStep.fromJson(json.getAsJsonObject("prev")) : null;
        return new XblUserToken(json.get("expireTimeMs").getAsLong(), json.get("token").getAsString(), json.get("userHash").getAsString(), prev);
    }

    public static final class XblUserToken
    implements AbstractStep.StepResult<StepInitialXblSession.InitialXblSession> {
        private final long expireTimeMs;
        private final String token;
        private final String userHash;
        private final StepInitialXblSession.InitialXblSession prevResult;

        public XblUserToken(long expireTimeMs, String token, String userHash, StepInitialXblSession.InitialXblSession prevResult) {
            this.expireTimeMs = expireTimeMs;
            this.token = token;
            this.userHash = userHash;
            this.prevResult = prevResult;
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("expireTimeMs", (Number)this.expireTimeMs);
            json.addProperty("token", this.token);
            json.addProperty("userHash", this.userHash);
            if (this.prevResult != null) {
                json.add("prev", (JsonElement)this.prevResult.toJson());
            }
            return json;
        }

        @Override
        public boolean isExpired() {
            return this.expireTimeMs <= System.currentTimeMillis();
        }

        public long expireTimeMs() {
            return this.expireTimeMs;
        }

        public String token() {
            return this.token;
        }

        public String userHash() {
            return this.userHash;
        }

        @Override
        public StepInitialXblSession.InitialXblSession prevResult() {
            return this.prevResult;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            XblUserToken that = (XblUserToken)obj;
            return this.expireTimeMs == that.expireTimeMs && Objects.equals(this.token, that.token) && Objects.equals(this.userHash, that.userHash) && Objects.equals(this.prevResult, that.prevResult);
        }

        public int hashCode() {
            return Objects.hash(this.expireTimeMs, this.token, this.userHash, this.prevResult);
        }

        public String toString() {
            return "XblUserToken[expireTimeMs=" + this.expireTimeMs + ", token=" + this.token + ", userHash=" + this.userHash + ", prevResult=" + this.prevResult + ']';
        }
    }
}

