/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.mcauth.step.xbl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Objects;
import net.raphimc.mcauth.MinecraftAuth;
import net.raphimc.mcauth.step.AbstractStep;
import net.raphimc.mcauth.step.xbl.session.StepFullXblSession;
import net.raphimc.mcauth.step.xbl.session.StepInitialXblSession;
import net.raphimc.mcauth.util.CryptUtil;
import net.raphimc.mcauth.util.XblResponseHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class StepXblXstsToken
extends AbstractStep<StepFullXblSession.FullXblSession, XblXsts<?>> {
    public static final String XBL_XSTS_URL = "https://xsts.auth.xboxlive.com/xsts/authorize";
    private final String relyingParty;

    public StepXblXstsToken(AbstractStep<?, StepFullXblSession.FullXblSession> prevStep, String relyingParty) {
        super(prevStep);
        this.relyingParty = relyingParty;
    }

    @Override
    public XblXstsToken applyStep(HttpClient httpClient, StepFullXblSession.FullXblSession prevResult) throws Exception {
        MinecraftAuth.LOGGER.info("Requesting XSTS Token...");
        JsonObject postData = new JsonObject();
        JsonObject properties = new JsonObject();
        properties.addProperty("SandboxId", "RETAIL");
        JsonArray userTokens = new JsonArray();
        userTokens.add((JsonElement)new JsonPrimitive(prevResult.prevResult().token()));
        properties.add("UserTokens", (JsonElement)userTokens);
        if (prevResult.prevResult2() != null) {
            properties.addProperty("TitleToken", prevResult.prevResult2().token());
            properties.addProperty("DeviceToken", prevResult.prevResult2().prevResult().prevResult2().token());
        }
        postData.add("Properties", (JsonElement)properties);
        postData.addProperty("RelyingParty", this.relyingParty);
        postData.addProperty("TokenType", "JWT");
        HttpPost httpPost = new HttpPost(XBL_XSTS_URL);
        httpPost.setEntity(new StringEntity(postData.toString(), ContentType.APPLICATION_JSON));
        httpPost.addHeader("x-xbl-contract-version", "1");
        if (prevResult.prevResult2() != null) {
            httpPost.addHeader(CryptUtil.getSignatureHeader(httpPost, prevResult.prevResult2().prevResult().prevResult2().privateKey()));
        }
        String response = httpClient.execute((HttpUriRequest)httpPost, new XblResponseHandler());
        JsonObject obj = JsonParser.parseString((String)response).getAsJsonObject();
        XblXstsToken result = new XblXstsToken(Instant.parse(obj.get("NotAfter").getAsString()).toEpochMilli(), obj.get("Token").getAsString(), obj.getAsJsonObject("DisplayClaims").getAsJsonArray("xui").get(0).getAsJsonObject().get("uhs").getAsString(), prevResult);
        MinecraftAuth.LOGGER.info("Got XSTS Token, expires: " + Instant.ofEpochMilli(result.expireTimeMs).atZone(ZoneId.systemDefault()));
        return result;
    }

    @Override
    public XblXsts<?> refresh(HttpClient httpClient, XblXsts<?> result) throws Exception {
        if (result == null || result.isExpired()) {
            return super.refresh(httpClient, result);
        }
        return result;
    }

    @Override
    public XblXstsToken fromJson(JsonObject json) throws Exception {
        StepFullXblSession.FullXblSession prev = this.prevStep != null ? (StepFullXblSession.FullXblSession)this.prevStep.fromJson(json.getAsJsonObject("prev")) : null;
        return new XblXstsToken(json.get("expireTimeMs").getAsLong(), json.get("token").getAsString(), json.get("userHash").getAsString(), prev);
    }

    public static interface XblXsts<P extends AbstractStep.StepResult<?>>
    extends AbstractStep.StepResult<P> {
        public long expireTimeMs();

        public String token();

        public String userHash();

        default public StepInitialXblSession.InitialXblSession initialXblSession() {
            return this.fullXblSession().prevResult().prevResult();
        }

        public StepFullXblSession.FullXblSession fullXblSession();

        @Override
        public JsonObject toJson();
    }

    public static final class XblXstsToken
    implements AbstractStep.StepResult<StepFullXblSession.FullXblSession>,
    XblXsts<StepFullXblSession.FullXblSession> {
        private final long expireTimeMs;
        private final String token;
        private final String userHash;
        private final StepFullXblSession.FullXblSession prevResult;

        public XblXstsToken(long expireTimeMs, String token, String userHash, StepFullXblSession.FullXblSession prevResult) {
            this.expireTimeMs = expireTimeMs;
            this.token = token;
            this.userHash = userHash;
            this.prevResult = prevResult;
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("expireTimeMs", (Number)this.expireTimeMs);
            json.addProperty("token", this.token);
            json.addProperty("userHash", this.userHash);
            if (this.prevResult != null) {
                json.add("prev", (JsonElement)this.prevResult.toJson());
            }
            return json;
        }

        @Override
        public boolean isExpired() {
            return this.expireTimeMs <= System.currentTimeMillis();
        }

        @Override
        public StepFullXblSession.FullXblSession fullXblSession() {
            return this.prevResult;
        }

        @Override
        public long expireTimeMs() {
            return this.expireTimeMs;
        }

        @Override
        public String token() {
            return this.token;
        }

        @Override
        public String userHash() {
            return this.userHash;
        }

        @Override
        public StepFullXblSession.FullXblSession prevResult() {
            return this.prevResult;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            XblXstsToken that = (XblXstsToken)obj;
            return this.expireTimeMs == that.expireTimeMs && Objects.equals(this.token, that.token) && Objects.equals(this.userHash, that.userHash) && Objects.equals(this.prevResult, that.prevResult);
        }

        public int hashCode() {
            return Objects.hash(this.expireTimeMs, this.token, this.userHash, this.prevResult);
        }

        public String toString() {
            return "XblXstsToken[expireTimeMs=" + this.expireTimeMs + ", token=" + this.token + ", userHash=" + this.userHash + ", prevResult=" + this.prevResult + ']';
        }
    }
}

