/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.mcauth.util;

import com.google.gson.JsonObject;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.crypto.EllipticCurveProvider;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.time.Instant;
import java.util.Base64;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;

public class CryptUtil {
    public static final KeyFactory EC_KEYFACTORY;

    public static BasicHeader getSignatureHeader(HttpUriRequest httpRequest, ECPrivateKey privateKey) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        long windowsTimestamp = (Instant.now().getEpochSecond() + 11644473600L) * 10000000L;
        ByteArrayOutputStream signatureContent = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(signatureContent);
        data.writeInt(1);
        data.writeByte(0);
        data.writeLong(windowsTimestamp);
        data.writeByte(0);
        data.write(httpRequest.getMethod().getBytes(StandardCharsets.UTF_8));
        data.writeByte(0);
        data.write((httpRequest.getURI().getPath() + (httpRequest.getURI().getQuery() != null ? httpRequest.getURI().getQuery() : "")).getBytes(StandardCharsets.UTF_8));
        data.writeByte(0);
        if (httpRequest.containsHeader("Authorization")) {
            data.write(httpRequest.getFirstHeader("Authorization").getValue().getBytes(StandardCharsets.UTF_8));
        }
        data.writeByte(0);
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            int read;
            InputStream content = ((HttpEntityEnclosingRequest)((Object)httpRequest)).getEntity().getContent();
            byte[] buffer = new byte[1024];
            while ((read = content.read(buffer)) != -1) {
                data.write(buffer, 0, read);
            }
        }
        data.writeByte(0);
        Signature sha256withECDSA = Signature.getInstance("SHA256withECDSA");
        sha256withECDSA.initSign(privateKey);
        sha256withECDSA.update(signatureContent.toByteArray());
        byte[] signature = sha256withECDSA.sign();
        ByteArrayOutputStream header = new ByteArrayOutputStream();
        data = new DataOutputStream(header);
        data.writeInt(1);
        data.writeLong(windowsTimestamp);
        data.write(EllipticCurveProvider.transcodeDERToConcat(signature, EllipticCurveProvider.getSignatureByteArrayLength(SignatureAlgorithm.ES256)));
        return new BasicHeader("Signature", Base64.getEncoder().encodeToString(header.toByteArray()));
    }

    public static JsonObject getProofKey(ECPublicKey publicKey) {
        JsonObject proofKey = new JsonObject();
        proofKey.addProperty("alg", "ES256");
        proofKey.addProperty("crv", "P-256");
        proofKey.addProperty("kty", "EC");
        proofKey.addProperty("use", "sig");
        proofKey.addProperty("x", CryptUtil.encodeECCoordinate(publicKey.getParams().getCurve().getField().getFieldSize(), publicKey.getW().getAffineX()));
        proofKey.addProperty("y", CryptUtil.encodeECCoordinate(publicKey.getParams().getCurve().getField().getFieldSize(), publicKey.getW().getAffineY()));
        return proofKey;
    }

    private static String encodeECCoordinate(int fieldSize, BigInteger coordinate) {
        int bytesToOutput;
        byte[] notPadded = CryptUtil.bigIntegerToByteArray(coordinate);
        if (notPadded.length >= (bytesToOutput = (fieldSize + 7) / 8)) {
            return Base64.getUrlEncoder().withoutPadding().encodeToString(notPadded);
        }
        byte[] padded = new byte[bytesToOutput];
        System.arraycopy(notPadded, 0, padded, bytesToOutput - notPadded.length, notPadded.length);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(padded);
    }

    private static byte[] bigIntegerToByteArray(BigInteger bigInteger) {
        int bitlen = bigInteger.bitLength();
        bitlen = bitlen + 7 >> 3 << 3;
        byte[] bigBytes = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == bitlen / 8) {
            return bigBytes;
        }
        int startSrc = 0;
        int len = bigBytes.length;
        if (bigInteger.bitLength() % 8 == 0) {
            startSrc = 1;
            --len;
        }
        int startDst = bitlen / 8 - len;
        byte[] resizedBytes = new byte[bitlen / 8];
        System.arraycopy(bigBytes, startSrc, resizedBytes, startDst, len);
        return resizedBytes;
    }

    static {
        try {
            EC_KEYFACTORY = KeyFactory.getInstance("EC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not create EllipticCurve KeyFactory", e);
        }
    }
}

