/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class GameDownloader {
    private static final String GAME_PACKAGE_ID = "383fa522-5568-48d1-94fa-dd44b31f02b3";
    private static final String URL = "https://fe3.delivery.mp.microsoft.com/ClientWebService/client.asmx/secured";
    private static final String DOWNLOAD_URL_XPATH = "//e:Body/cws:GetExtendedUpdateInfo2Response/cws:GetExtendedUpdateInfo2Result/cws:FileLocations/cws:FileLocation[starts-with(cws:Url, 'http://tlu.dl.delivery.mp.microsoft.com')]/cws:Url";
    private int progress;

    public File download() throws Exception {
        this.progress = 0;
        Instant createdAt = Instant.now();
        Instant expiresAt = createdAt.plus(5L, ChronoUnit.MINUTES);
        String payload = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><s:Envelope xmlns:s=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:a=\"http://www.w3.org/2005/08/addressing\">   <s:Header>      <a:Action s:mustUnderstand=\"1\">http://www.microsoft.com/SoftwareDistribution/Server/ClientWebService/GetExtendedUpdateInfo2</a:Action>      <a:MessageID>urn:uuid:5754a03d-d8d5-489f-b24d-efc31b3fd32d</a:MessageID>      <a:To s:mustUnderstand=\"1\">https://fe3.delivery.mp.microsoft.com/ClientWebService/client.asmx/secured</a:To>      <o:Security xmlns:o=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" s:mustUnderstand=\"1\">         <Timestamp xmlns=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\">            <Created>" + createdAt + "</Created>            <Expires>" + expiresAt + "</Expires>         </Timestamp>         <wuws:WindowsUpdateTicketsToken xmlns:wuws=\"http://schemas.microsoft.com/msus/2014/10/WindowsUpdateAuthorization\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\" wsu:id=\"ClientMSA\">            <TicketType Name=\"AAD\" Version=\"1.0\" Policy=\"MBI_SSL\" />         </wuws:WindowsUpdateTicketsToken>      </o:Security>   </s:Header>   <s:Body>      <GetExtendedUpdateInfo2 xmlns=\"http://www.microsoft.com/SoftwareDistribution/Server/ClientWebService\">         <updateIDs>            <UpdateIdentity>               <UpdateID>" + GAME_PACKAGE_ID + "</UpdateID>               <RevisionNumber>1</RevisionNumber>            </UpdateIdentity>         </updateIDs>         <infoTypes>            <XmlUpdateFragmentType>FileUrl</XmlUpdateFragmentType>         </infoTypes>      </GetExtendedUpdateInfo2>   </s:Body></s:Envelope>";
        HttpsURLConnection connection = (HttpsURLConnection)new URL(URL).openConnection();
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }}, new SecureRandom());
        connection.setSSLSocketFactory(sslContext.getSocketFactory());
        connection.setRequestMethod("POST");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/soap+xml; charset=utf-8");
        connection.setRequestProperty("Content-Length", String.valueOf(payload.length()));
        connection.getOutputStream().write(payload.getBytes());
        if (connection.getResponseCode() / 100 != 2) {
            throw new IOException("Bad response code: " + connection.getResponseCode());
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(connection.getInputStream());
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(new NamespaceResolver());
        String downloadUrl = (String)xPath.compile(DOWNLOAD_URL_XPATH).evaluate(doc, XPathConstants.STRING);
        File tempFile = File.createTempFile(GAME_PACKAGE_ID, ".zip");
        tempFile.deleteOnExit();
        URL url = new URL(downloadUrl);
        URLConnection urlConnection = url.openConnection();
        urlConnection.connect();
        int contentLength = urlConnection.getContentLength();
        try (InputStream inputStream = urlConnection.getInputStream();
             OutputStream outputStream = Files.newOutputStream(tempFile.toPath(), new OpenOption[0]);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            int totalBytesRead = 0;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                this.progress = (int)((double)(totalBytesRead += bytesRead) / (double)contentLength * 100.0);
            }
        }
        return tempFile;
    }

    public int getProgress() {
        return this.progress;
    }

    private static class NamespaceResolver
    implements NamespaceContext {
        private NamespaceResolver() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if ("e".equals(prefix)) {
                return "http://www.w3.org/2003/05/soap-envelope";
            }
            if ("cws".equals(prefix)) {
                return "http://www.microsoft.com/SoftwareDistribution/Server/ClientWebService";
            }
            return null;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException();
        }
    }
}

