/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.chunk.block_state;

import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.raphimc.viabedrock.api.model.BedrockBlockState;
import net.raphimc.viabedrock.api.util.NbtUtil;

public class BlockStateSanitizer {
    private final Map<String, Map<String, Set<Object>>> allowedPropertyValues = new HashMap<String, Map<String, Set<Object>>>();

    public BlockStateSanitizer(List<BedrockBlockState> blockStates) {
        for (BedrockBlockState blockState : blockStates) {
            String identifier = ((StringTag)blockState.blockStateTag().get("name")).getValue();
            CompoundTag statesTag = (CompoundTag)blockState.blockStateTag().get("states");
            Map propertyValues = this.allowedPropertyValues.computeIfAbsent(identifier, k -> new HashMap());
            for (Map.Entry<String, Tag> entry : statesTag.entrySet()) {
                propertyValues.computeIfAbsent(entry.getKey(), k -> new LinkedHashSet()).add(entry.getValue().getValue());
            }
        }
    }

    public void sanitize(CompoundTag tag) {
        String property;
        BedrockBlockState.sanitizeName(tag);
        String identifier = ((StringTag)tag.get("name")).getValue();
        CompoundTag statesTag = (CompoundTag)tag.get("states");
        if (statesTag == null) {
            return;
        }
        Map<String, Set<Object>> propertyValues = this.allowedPropertyValues.get(identifier);
        if (propertyValues == null) {
            return;
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry<String, Tag> entry : statesTag.entrySet()) {
            property = entry.getKey();
            Set<Object> allowedValues = propertyValues.get(property);
            if (allowedValues == null) {
                toRemove.add(property);
                continue;
            }
            if (allowedValues.contains(entry.getValue().getValue())) continue;
            entry.setValue(NbtUtil.createTag(allowedValues.iterator().next()));
        }
        for (String string : toRemove) {
            statesTag.remove(string);
        }
        for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
            property = entry.getKey();
            if (statesTag.contains(property)) continue;
            statesTag.put(property, NbtUtil.createTag(((Set)entry.getValue()).iterator().next()));
        }
    }
}

