/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.chunk.block_state;

import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.util.GsonUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.chunk.block_state.BlockStateUpgradeSchema;
import net.raphimc.viabedrock.api.chunk.block_state.JsonBlockStateUpgradeSchema;
import net.raphimc.viabedrock.api.chunk.block_state.ValTagBlockStateUpgradeSchema;
import net.raphimc.viabedrock.api.model.BedrockBlockState;

public class BlockStateUpgrader {
    private final List<BlockStateUpgradeSchema> schemas = new ArrayList<BlockStateUpgradeSchema>();

    public BlockStateUpgrader() {
        this.schemas.add(new ValTagBlockStateUpgradeSchema());
        try {
            String path = "assets/viabedrock/block_state_upgrade_schema";
            try (FileSystem fileSystem = this.getFileSystem(BlockStateUpgrader.class.getClassLoader().getResource("assets/viabedrock/block_state_upgrade_schema").toURI());){
                List files = Files.walk(fileSystem.getPath("assets/viabedrock/block_state_upgrade_schema", new String[0]), new FileVisitOption[0]).filter(f -> !f.toString().equals("assets/viabedrock/block_state_upgrade_schema")).sorted(Comparator.comparing(Path::toString)).collect(Collectors.toList());
                for (Path file : files) {
                    JsonObject json = GsonUtil.getGson().fromJson((Reader)new InputStreamReader(fileSystem.provider().newInputStream(file, new OpenOption[0])), JsonObject.class);
                    this.schemas.add(new JsonBlockStateUpgradeSchema(json));
                }
            }
        }
        catch (Throwable e) {
            ViaBedrock.getPlatform().getLogger().log(Level.SEVERE, "Failed to load block state upgrade schema", e);
            this.schemas.clear();
        }
    }

    public void upgradeToLatest(CompoundTag tag) {
        BedrockBlockState.sanitizeName(tag);
        for (BlockStateUpgradeSchema schema : this.schemas) {
            schema.upgrade(tag);
        }
    }

    private FileSystem getFileSystem(URI uri) throws IOException {
        FileSystem fileSystem;
        try {
            fileSystem = FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException e) {
            fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
        return fileSystem;
    }
}

