/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.chunk.block_state;

import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.util.Pair;
import com.viaversion.viaversion.util.Triple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.raphimc.viabedrock.api.chunk.block_state.BlockStateUpgradeSchema;
import net.raphimc.viabedrock.api.util.NbtUtil;

public class JsonBlockStateUpgradeSchema
extends BlockStateUpgradeSchema {
    public JsonBlockStateUpgradeSchema(JsonObject jsonObject) {
        super(jsonObject.get("maxVersionMajor").getAsInt(), jsonObject.get("maxVersionMinor").getAsInt(), jsonObject.get("maxVersionPatch").getAsInt(), jsonObject.get("maxVersionRevision").getAsInt());
        HashMap<CompoundTag, Object> mappings;
        String identifier;
        HashMap remappedPropertyValuesLookup = new HashMap();
        if (jsonObject.has("remappedPropertyValuesIndex")) {
            JsonObject remappedPropertyValuesIndex = jsonObject.get("remappedPropertyValuesIndex").getAsJsonObject();
            for (Map.Entry<String, JsonElement> entry : remappedPropertyValuesIndex.entrySet()) {
                ArrayList<Pair<Object, Object>> mappings2 = new ArrayList<Pair<Object, Object>>();
                for (JsonElement element : entry.getValue().getAsJsonArray()) {
                    JsonObject jsonObject2 = element.getAsJsonObject();
                    mappings2.add(new Pair<Object, Object>(this.getValue(jsonObject2.get("old").getAsJsonObject()), this.getValue(jsonObject2.get("new").getAsJsonObject())));
                }
                remappedPropertyValuesLookup.put(entry.getKey(), mappings2);
            }
        }
        if (jsonObject.has("remappedStates")) {
            JsonObject remappedStates = jsonObject.get("remappedStates").getAsJsonObject();
            for (Map.Entry<String, JsonElement> entry : remappedStates.entrySet()) {
                identifier = entry.getKey().toLowerCase(Locale.ROOT);
                mappings = new HashMap<CompoundTag, Object>();
                for (JsonElement jsonElement : entry.getValue().getAsJsonArray()) {
                    JsonObject mappingObject = jsonElement.getAsJsonObject();
                    CompoundTag oldStateTag = new CompoundTag();
                    if (mappingObject.get("oldState").isJsonObject()) {
                        for (Map.Entry<String, JsonElement> entry2 : mappingObject.get("oldState").getAsJsonObject().entrySet()) {
                            oldStateTag.put(entry2.getKey(), NbtUtil.createTag(this.getValue(entry2.getValue().getAsJsonObject())));
                        }
                    }
                    CompoundTag newStateTag = new CompoundTag();
                    if (mappingObject.get("newState").isJsonObject()) {
                        for (Map.Entry<String, JsonElement> property2 : mappingObject.get("newState").getAsJsonObject().entrySet()) {
                            newStateTag.put(property2.getKey(), NbtUtil.createTag(this.getValue(property2.getValue().getAsJsonObject())));
                        }
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (mappingObject.has("copiedState")) {
                        for (JsonElement property : mappingObject.get("copiedState").getAsJsonArray()) {
                            arrayList.add(property.getAsString());
                        }
                    }
                    mappings.put(oldStateTag, new Triple(mappingObject.get("newName").getAsString().toLowerCase(Locale.ROOT), newStateTag, arrayList));
                }
                this.actions.add(tag -> {
                    String name = ((StringTag)tag.get("name")).getValue();
                    if (!name.equals(identifier)) {
                        return;
                    }
                    if (tag.get("states") instanceof CompoundTag) {
                        CompoundTag states = (CompoundTag)tag.get("states");
                        for (Map.Entry mapping : mappings.entrySet()) {
                            boolean matches = true;
                            for (Map.Entry<String, Tag> stateTag : ((CompoundTag)mapping.getKey()).entrySet()) {
                                if (stateTag.getValue().equals(states.get(stateTag.getKey()))) continue;
                                matches = false;
                                break;
                            }
                            if (!matches) continue;
                            Triple mappingValue = (Triple)mapping.getValue();
                            CompoundTag newStates = ((CompoundTag)mappingValue.second()).clone();
                            for (String property : (List)mappingValue.third()) {
                                if (!states.contains(property)) continue;
                                newStates.put(property, states.get(property));
                            }
                            tag.put("name", new StringTag((String)mappingValue.first()));
                            tag.put("states", newStates);
                            throw BlockStateUpgradeSchema.StopUpgrade.INSTANCE;
                        }
                    }
                });
            }
        }
        if (jsonObject.has("remappedPropertyValues")) {
            JsonObject remappedPropertyValues = jsonObject.get("remappedPropertyValues").getAsJsonObject();
            for (Map.Entry<String, JsonElement> entry : remappedPropertyValues.entrySet()) {
                identifier = entry.getKey().toLowerCase(Locale.ROOT);
                mappings = new HashMap();
                for (Map.Entry entry3 : entry.getValue().getAsJsonObject().entrySet()) {
                    mappings.put((CompoundTag)entry3.getKey(), remappedPropertyValuesLookup.get(((JsonElement)entry3.getValue()).getAsString()));
                }
                this.actions.add(tag -> {
                    String name = ((StringTag)tag.get("name")).getValue();
                    if (!name.equals(identifier)) {
                        return;
                    }
                    if (tag.get("states") instanceof CompoundTag) {
                        CompoundTag states = (CompoundTag)tag.get("states");
                        for (Map.Entry mapping : mappings.entrySet()) {
                            Object property = states.get((String)mapping.getKey());
                            if (property == null) continue;
                            Object value = ((Tag)property).getValue();
                            for (Pair valueMapping : (List)mapping.getValue()) {
                                if (!valueMapping.key().equals(value)) continue;
                                states.put((String)mapping.getKey(), NbtUtil.createTag(valueMapping.value()));
                            }
                        }
                    }
                });
            }
        }
        if (jsonObject.has("renamedProperties")) {
            JsonObject renamedProperties = jsonObject.get("renamedProperties").getAsJsonObject();
            for (Map.Entry<String, JsonElement> entry : renamedProperties.entrySet()) {
                identifier = entry.getKey().toLowerCase(Locale.ROOT);
                mappings = new HashMap();
                for (Map.Entry entry4 : entry.getValue().getAsJsonObject().entrySet()) {
                    mappings.put((CompoundTag)entry4.getKey(), ((JsonElement)entry4.getValue()).getAsString());
                }
                this.actions.add(tag -> {
                    String name = ((StringTag)tag.get("name")).getValue();
                    if (!name.equals(identifier)) {
                        return;
                    }
                    if (tag.get("states") instanceof CompoundTag) {
                        CompoundTag states = (CompoundTag)tag.get("states");
                        for (Map.Entry mapping : mappings.entrySet()) {
                            Object property = states.remove((String)mapping.getKey());
                            if (property == null) continue;
                            states.put((String)mapping.getValue(), property);
                        }
                    }
                });
            }
        }
        if (jsonObject.has("removedProperties")) {
            JsonObject removedProperties = jsonObject.get("removedProperties").getAsJsonObject();
            for (Map.Entry<String, JsonElement> entry : removedProperties.entrySet()) {
                identifier = entry.getKey().toLowerCase(Locale.ROOT);
                ArrayList<String> toRemove = new ArrayList<String>();
                for (JsonElement jsonElement : entry.getValue().getAsJsonArray()) {
                    toRemove.add(jsonElement.getAsString());
                }
                this.actions.add(tag -> {
                    String name = ((StringTag)tag.get("name")).getValue();
                    if (!name.equals(identifier)) {
                        return;
                    }
                    if (tag.get("states") instanceof CompoundTag) {
                        CompoundTag states = (CompoundTag)tag.get("states");
                        for (String property : toRemove) {
                            states.remove(property);
                        }
                    }
                });
            }
        }
        if (jsonObject.has("addedProperties")) {
            JsonObject addedProperties = jsonObject.get("addedProperties").getAsJsonObject();
            for (Map.Entry<String, JsonElement> entry : addedProperties.entrySet()) {
                identifier = entry.getKey().toLowerCase(Locale.ROOT);
                ArrayList toAdd = new ArrayList();
                for (Map.Entry entry5 : entry.getValue().getAsJsonObject().entrySet()) {
                    toAdd.add(new Pair(entry5.getKey(), this.getValue(((JsonElement)entry5.getValue()).getAsJsonObject())));
                }
                this.actions.add(tag -> {
                    String name = ((StringTag)tag.get("name")).getValue();
                    if (!name.equals(identifier)) {
                        return;
                    }
                    if (tag.get("states") instanceof CompoundTag) {
                        CompoundTag states = (CompoundTag)tag.get("states");
                        for (Pair property : toAdd) {
                            states.put((String)property.key(), NbtUtil.createTag(property.value()));
                        }
                    }
                });
            }
        }
        if (jsonObject.has("renamedIds")) {
            JsonObject renamedIds = jsonObject.get("renamedIds").getAsJsonObject();
            HashMap<String, String> mappings3 = new HashMap<String, String>();
            for (Map.Entry<String, JsonElement> mappingEntry : renamedIds.entrySet()) {
                mappings3.put(mappingEntry.getKey().toLowerCase(Locale.ROOT), mappingEntry.getValue().getAsString().toLowerCase(Locale.ROOT));
            }
            this.actions.add(tag -> {
                String name = ((StringTag)tag.get("name")).getValue();
                if (!mappings3.containsKey(name)) {
                    return;
                }
                tag.put("name", new StringTag((String)mappings3.get(name)));
            });
        }
    }

    private Object getValue(JsonObject obj) {
        if (obj.has("int")) {
            return obj.get("int").getAsInt();
        }
        if (obj.has("byte")) {
            return obj.get("byte").getAsByte();
        }
        if (obj.has("string")) {
            return obj.get("string").getAsString();
        }
        throw new IllegalArgumentException("Unknown json value type");
    }
}

