/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.chunk.datapalette;

import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;

public class BedrockBiomeArray
implements DataPalette,
Cloneable {
    private byte[] biomes;

    public BedrockBiomeArray() {
        this.biomes = new byte[256];
    }

    public BedrockBiomeArray(byte[] biomes) {
        this.biomes = biomes;
    }

    @Override
    public int index(int x, int y, int z) {
        return z << 4 | x;
    }

    @Override
    public int idAt(int sectionCoordinate) {
        return this.biomes[sectionCoordinate] & 0xFF;
    }

    @Override
    public void setIdAt(int sectionCoordinate, int id) {
        if (id > 255) {
            throw new IllegalArgumentException("Too large biome id: " + id);
        }
        this.biomes[sectionCoordinate] = (byte)id;
    }

    @Override
    public int idByIndex(int index) {
        return this.idAt(index);
    }

    @Override
    public void setIdByIndex(int index, int id) {
        this.setIdAt(index, id);
    }

    @Override
    public int paletteIndexAt(int packedCoordinate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPaletteIndexAt(int sectionCoordinate, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addId(int id) {
    }

    @Override
    public void replaceId(int oldId, int newId) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.idAt(i) != oldId) continue;
            this.setIdAt(i, newId);
        }
    }

    @Override
    public int size() {
        return this.biomes.length;
    }

    @Override
    public void clear() {
        this.biomes = new byte[this.biomes.length];
    }

    public BedrockBiomeArray clone() {
        return new BedrockBiomeArray((byte[])this.biomes.clone());
    }
}

