/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.chunk.datapalette;

import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrayList;
import com.viaversion.viaversion.libs.fastutil.ints.IntList;
import com.viaversion.viaversion.libs.fastutil.objects.Object2IntFunction;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import java.util.List;
import net.raphimc.viabedrock.api.chunk.bitarray.BitArray;
import net.raphimc.viabedrock.api.chunk.bitarray.BitArrayVersion;

public class BedrockDataPalette
implements DataPalette,
Cloneable {
    private final IntList palette;
    private BitArray bitArray;
    private List<Tag> tagPalette;

    public BedrockDataPalette() {
        this(BitArrayVersion.V2);
    }

    public BedrockDataPalette(BitArrayVersion version) {
        this.bitArray = version.createArray(4096);
        this.palette = new IntArrayList(version.getEntriesPerWord());
    }

    public BedrockDataPalette(IntList palette, BitArray bitArray) {
        this.palette = palette;
        this.bitArray = bitArray;
    }

    public BedrockDataPalette(List<Tag> tagPalette, BitArray bitArray) {
        this.tagPalette = tagPalette;
        this.bitArray = bitArray;
        this.palette = new IntArrayList(tagPalette.size());
    }

    @Override
    public int index(int x, int y, int z) {
        return (x << 8) + (z << 4) + y;
    }

    @Override
    public int idAt(int sectionCoordinate) {
        this.checkTagPalette();
        return this.palette.getInt(this.bitArray.get(sectionCoordinate));
    }

    @Override
    public void setIdAt(int sectionCoordinate, int id) {
        this.checkTagPalette();
        int index = this.palette.indexOf(id);
        if (index == -1) {
            index = this.palette.size();
            this.addId(id);
        }
        this.bitArray.set(sectionCoordinate, index);
    }

    @Override
    public int idByIndex(int index) {
        this.checkTagPalette();
        return this.palette.getInt(index);
    }

    @Override
    public void setIdByIndex(int index, int id) {
        this.checkTagPalette();
        this.palette.set(index, id);
    }

    @Override
    public int paletteIndexAt(int packedCoordinate) {
        return this.bitArray.get(packedCoordinate);
    }

    @Override
    public void setPaletteIndexAt(int sectionCoordinate, int index) {
        this.bitArray.set(sectionCoordinate, index);
    }

    @Override
    public void addId(int id) {
        BitArrayVersion nextVersion;
        this.palette.add(id);
        BitArrayVersion currentVersion = this.bitArray.getVersion();
        if (this.palette.size() >= currentVersion.getMaxEntryValue() && (nextVersion = currentVersion.getNext()) != null) {
            BitArray newBitArray = nextVersion.createArray(this.bitArray.size());
            for (int i = 0; i < this.bitArray.size(); ++i) {
                newBitArray.set(i, this.bitArray.get(i));
            }
            this.bitArray = newBitArray;
        }
    }

    @Override
    public void replaceId(int oldId, int newId) {
        this.checkTagPalette();
        int index = this.palette.indexOf(oldId);
        if (index == -1) {
            return;
        }
        for (int i = 0; i < this.palette.size(); ++i) {
            if (this.palette.getInt(i) != oldId) continue;
            this.palette.set(i, newId);
        }
    }

    @Override
    public int size() {
        if (this.hasTagPalette()) {
            return this.tagPalette.size();
        }
        return this.palette.size();
    }

    @Override
    public void clear() {
        if (this.hasTagPalette()) {
            this.tagPalette = null;
        }
        this.palette.clear();
    }

    public BedrockDataPalette clone() {
        return new BedrockDataPalette(new IntArrayList(this.palette), this.bitArray.clone());
    }

    public BitArray getBitArray() {
        return this.bitArray;
    }

    public boolean hasTagPalette() {
        return this.tagPalette != null;
    }

    public List<Tag> getTagPalette() {
        return this.tagPalette;
    }

    public void resolveTagPalette(Object2IntFunction<Tag> tagToRuntimeId) {
        if (this.hasTagPalette()) {
            this.palette.clear();
            for (Tag tag : this.tagPalette) {
                this.palette.add(tagToRuntimeId.getInt(tag));
            }
            this.tagPalette = null;
        }
    }

    private void checkTagPalette() {
        if (this.hasTagPalette()) {
            throw new IllegalStateException("The tag palette has not been resolved yet");
        }
    }
}

