/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.chunk.section;

import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.raphimc.viabedrock.api.chunk.datapalette.BedrockDataPalette;
import net.raphimc.viabedrock.api.chunk.section.BedrockChunkSection;

public class BedrockChunkSectionImpl
implements BedrockChunkSection {
    private final List<DataPalette> blockPalettes = new ArrayList<DataPalette>();
    private DataPalette biomePalette;
    private List<int[]> pendingBlockUpdates = new ArrayList<int[]>();

    public BedrockChunkSectionImpl() {
    }

    public BedrockChunkSectionImpl(boolean noPendingBlockUpdates) {
        if (noPendingBlockUpdates) {
            this.pendingBlockUpdates = null;
        }
    }

    @Override
    public int palettesCount(PaletteType type) {
        if (type == PaletteType.BLOCKS) {
            return this.blockPalettes.size();
        }
        if (type == PaletteType.BIOMES) {
            return this.biomePalette != null ? 1 : 0;
        }
        return 0;
    }

    @Override
    public List<DataPalette> palettes(PaletteType type) {
        if (type == PaletteType.BLOCKS) {
            return this.blockPalettes;
        }
        if (type == PaletteType.BIOMES) {
            return this.biomePalette != null ? Collections.singletonList(this.biomePalette) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public void mergeWith(BedrockChunkSection other) {
        if (!this.hasPendingBlockUpdates()) {
            throw new IllegalStateException("This section already has been merged with another section");
        }
        if (this.blockPalettes.isEmpty()) {
            this.blockPalettes.addAll(other.palettes(PaletteType.BLOCKS));
        }
        if (this.biomePalette == null) {
            this.biomePalette = other.palette(PaletteType.BIOMES);
        }
    }

    @Override
    public boolean hasPendingBlockUpdates() {
        return this.pendingBlockUpdates != null;
    }

    @Override
    public void addPendingBlockUpdate(int x, int y, int z, int layer, int blockState) {
        if (!this.hasPendingBlockUpdates()) {
            throw new IllegalStateException("This section already has been merged with another section");
        }
        this.pendingBlockUpdates.add(new int[]{layer, x, y, z, blockState});
    }

    @Override
    public void applyPendingBlockUpdates(int airId) {
        if (this.hasPendingBlockUpdates()) {
            for (int[] blockUpdate : this.pendingBlockUpdates) {
                int prevBlockState;
                DataPalette palette;
                int layer = blockUpdate[0];
                while (this.blockPalettes.size() <= layer) {
                    palette = new BedrockDataPalette();
                    ((BedrockDataPalette)palette).addId(airId);
                    this.addPalette(PaletteType.BLOCKS, palette);
                }
                palette = this.blockPalettes.get(layer);
                int sectionIndex = palette.index(blockUpdate[1], blockUpdate[2], blockUpdate[3]);
                int blockState = blockUpdate[4];
                if (layer > 0 && (prevBlockState = this.blockPalettes.get(layer - 1).idAt(sectionIndex)) == airId) continue;
                palette.setIdAt(sectionIndex, blockState);
            }
            this.pendingBlockUpdates = null;
        }
    }

    @Override
    public void addPalette(PaletteType type, DataPalette palette) {
        if (type == PaletteType.BLOCKS) {
            if (palette == null) {
                throw new IllegalArgumentException("Block palette cannot be null");
            }
            if (this.blockPalettes.size() >= 2) {
                throw new IllegalStateException("This section already has two block palettes");
            }
            this.blockPalettes.add(palette);
        } else if (type == PaletteType.BIOMES) {
            this.biomePalette = palette;
        }
    }

    @Override
    public void removePalette(PaletteType type) {
        if (type == PaletteType.BLOCKS) {
            this.blockPalettes.clear();
        } else if (type == PaletteType.BIOMES) {
            this.biomePalette = null;
        }
    }
}

