/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.http;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.ResourcePack;
import net.raphimc.viabedrock.protocol.rewriter.ResourcePackRewriter;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class ResourcePackHttpServer {
    private final InetSocketAddress bindAddress;
    private final ChannelFuture channelFuture;
    private final BiMap<UUID, UserConnection> connections = HashBiMap.create();

    public ResourcePackHttpServer(InetSocketAddress bindAddress) {
        this.bindAddress = bindAddress;
        this.channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)new NioEventLoopGroup(0)).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                channel.pipeline().addLast("http_codec", (ChannelHandler)new HttpServerCodec());
                channel.pipeline().addLast("chunked_writer", (ChannelHandler)new ChunkedWriteHandler());
                channel.pipeline().addLast("http_handler", (ChannelHandler)new SimpleChannelInboundHandler<Object>(){

                    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws IOException {
                        if (msg instanceof HttpRequest) {
                            HttpRequest request = (HttpRequest)msg;
                            if (!request.method().equals(HttpMethod.GET)) {
                                ctx.close();
                                return;
                            }
                            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(request.uri());
                            if (!queryStringDecoder.parameters().containsKey("token")) {
                                ctx.close();
                                return;
                            }
                            UUID uuid = UUID.fromString(queryStringDecoder.parameters().get("token").get(0));
                            UserConnection user = (UserConnection)ResourcePackHttpServer.this.connections.get((Object)uuid);
                            if (user == null) {
                                ctx.close();
                                return;
                            }
                            try {
                                long start = System.currentTimeMillis();
                                ResourcePack.Content javaContent = ResourcePackRewriter.bedrockToJava(user.get(ResourcePacksStorage.class));
                                byte[] data = javaContent.toZip();
                                Via.getPlatform().getLogger().log(Level.INFO, "Converted packs in " + (System.currentTimeMillis() - start) + "ms");
                                DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                                response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/octet-stream");
                                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)data.length);
                                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                                ctx.write((Object)response);
                                ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput<ByteBuf>)new ChunkedStream((InputStream)new ByteArrayInputStream(data), 65535))).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            }
                            catch (Throwable e) {
                                ViaBedrock.getPlatform().getLogger().log(Level.SEVERE, "Failed to convert resource packs", e);
                                ctx.close();
                            }
                        }
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        ctx.close();
                    }
                });
            }
        }).bind((SocketAddress)bindAddress).syncUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(UUID uuid, UserConnection connection) {
        BiMap<UUID, UserConnection> biMap = this.connections;
        synchronized (biMap) {
            this.connections.put((Object)uuid, (Object)connection);
        }
        connection.getChannel().closeFuture().addListener(future -> {
            BiMap<UUID, UserConnection> biMap = this.connections;
            synchronized (biMap) {
                this.connections.remove((Object)uuid);
            }
        });
    }

    public void stop() {
        if (this.channelFuture != null) {
            this.channelFuture.channel().close();
        }
    }

    public String getUrl() {
        String overrideUrl = ViaBedrock.getConfig().getResourcePackUrl();
        if (!overrideUrl.isEmpty()) {
            return overrideUrl;
        }
        InetSocketAddress bindAddress = (InetSocketAddress)this.channelFuture.channel().localAddress();
        return "http://" + this.bindAddress.getHostString() + ":" + bindAddress.getPort() + "/";
    }

    public Channel getChannel() {
        return this.channelFuture.channel();
    }
}

