/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class LittleEndianByteBufOutputStream
extends ByteBufOutputStream {
    private final ByteBuf buffer;

    public LittleEndianByteBufOutputStream(ByteBuf buffer) {
        super(buffer);
        this.buffer = buffer;
    }

    public void writeChar(int v) {
        this.buffer.writeChar((int)Character.reverseBytes((char)v));
    }

    public void writeDouble(double v) {
        this.buffer.writeDoubleLE(v);
    }

    public void writeFloat(float v) {
        this.buffer.writeFloatLE(v);
    }

    public void writeShort(int v) {
        this.buffer.writeShortLE(v);
    }

    public void writeLong(long v) throws IOException {
        this.buffer.writeLongLE(v);
    }

    public void writeInt(int v) throws IOException {
        this.buffer.writeIntLE(v);
    }

    public void writeUTF(String v) throws IOException {
        this.writeShort(ByteBufUtil.utf8Bytes((CharSequence)v));
        this.buffer.writeCharSequence((CharSequence)v, StandardCharsets.UTF_8);
    }
}

