/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model;

import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.util.GsonUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.imageio.ImageIO;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.util.JsonUtil;
import net.raphimc.viabedrock.api.util.MathUtil;

public class ResourcePack {
    public static final int TYPE_INVALID = 0;
    public static final int TYPE_ADDON = 1;
    public static final int TYPE_CACHED = 2;
    public static final int TYPE_COPY_PROTECTED = 3;
    public static final int TYPE_BEHAVIOR = 4;
    public static final int TYPE_PERSONA_PIECE = 5;
    public static final int TYPE_RESOURCE = 6;
    public static final int TYPE_SKINS = 7;
    public static final int TYPE_WORLD_TEMPLATE = 8;
    private static final byte[] CONTENTS_JSON_ENCRYPTED_MAGIC = new byte[]{-4, -71, -49, -101};
    public static boolean VALIDATE_MANIFEST = true;
    private final UUID packId;
    private final String version;
    private String contentKey;
    private final String subPackName;
    private final String contentId;
    private final boolean scripting;
    private final boolean raytracingCapable;
    private byte[] hash;
    private boolean premium;
    private int type;
    private byte[] compressedData;
    private int maxChunkSize;
    private boolean[] receivedChunks;
    private Content content;

    public ResourcePack(UUID packId, String version, String contentKey, String subPackName, String contentId, boolean scripting, boolean raytracingCapable, long compressedSize, int type) {
        this.packId = packId;
        this.version = version;
        this.contentKey = contentKey;
        this.subPackName = subPackName;
        this.contentId = contentId;
        this.scripting = scripting;
        this.raytracingCapable = raytracingCapable;
        this.compressedData = new byte[(int)compressedSize];
        this.type = type;
    }

    public boolean processDataChunk(int chunkIndex, byte[] data) throws NoSuchAlgorithmException, IOException, InvalidAlgorithmParameterException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (this.receivedChunks[chunkIndex]) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received duplicate resource pack chunk data: " + this.packId);
            return false;
        }
        int offset = chunkIndex * this.maxChunkSize;
        if (offset + data.length > this.compressedData.length) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received resource pack chunk data with invalid offset: " + this.packId);
            return false;
        }
        System.arraycopy(data, 0, this.compressedData, offset, data.length);
        this.receivedChunks[chunkIndex] = true;
        if (this.hasReceivedAllChunks()) {
            this.decompressAndDecrypt();
            return true;
        }
        return false;
    }

    public boolean isDecompressed() {
        return this.compressedData == null;
    }

    public UUID packId() {
        return this.packId;
    }

    public String version() {
        return this.version;
    }

    public String contentKey() {
        return this.contentKey;
    }

    public void setContentKey(String contentKey) {
        this.contentKey = contentKey;
    }

    public String subPackName() {
        return this.subPackName;
    }

    public String contentId() {
        return this.contentId;
    }

    public boolean scripting() {
        return this.scripting;
    }

    public boolean raytracingCapable() {
        return this.raytracingCapable;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public boolean premium() {
        return this.premium;
    }

    public void setPremium(boolean premium) {
        this.premium = premium;
    }

    public int type() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int compressedDataLength() {
        if (this.compressedData == null) {
            return 0;
        }
        return this.compressedData.length;
    }

    public void setCompressedDataLength(int length, int maxChunkSize) {
        this.compressedData = new byte[length];
        this.maxChunkSize = maxChunkSize;
        this.receivedChunks = new boolean[MathUtil.ceil((float)this.compressedData.length / (float)maxChunkSize)];
    }

    public Content content() {
        if (!this.isDecompressed()) {
            throw new IllegalStateException("Pack is not decompressed");
        }
        return this.content;
    }

    private void decompressAndDecrypt() throws NoSuchAlgorithmException, IOException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        ZipEntry zipEntry;
        MessageDigest sha256;
        byte[] hash;
        if (this.hash != null && !Arrays.equals(hash = (sha256 = MessageDigest.getInstance("SHA-256")).digest(this.compressedData), this.hash)) {
            throw new IllegalStateException("Resource pack hash mismatch: " + this.packId);
        }
        this.content = new Content();
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(this.compressedData));
        byte[] buf = new byte[4096];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int len;
            while ((len = zipInputStream.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            this.content.put(zipEntry.getName(), baos.toByteArray());
            baos.reset();
        }
        this.compressedData = null;
        if (!this.content.containsKey("manifest.json")) {
            for (String path : new HashSet(this.content.keySet())) {
                String newPath = path.substring(path.indexOf(47) + 1);
                this.content.put(newPath, this.content.remove(path));
            }
        }
        if (!this.contentKey.isEmpty()) {
            Cipher aesCfb8 = Cipher.getInstance("AES/CFB8/NoPadding");
            byte[] contentKeyBytes = this.contentKey.getBytes(StandardCharsets.ISO_8859_1);
            aesCfb8.init(2, (Key)new SecretKeySpec(contentKeyBytes, "AES"), new IvParameterSpec(Arrays.copyOfRange(contentKeyBytes, 0, 16)));
            ByteBuf contents = Unpooled.wrappedBuffer((byte[])((byte[])this.content.get("contents.json")));
            contents.skipBytes(4);
            byte[] magic = new byte[4];
            contents.readBytes(magic);
            if (!Arrays.equals(magic, CONTENTS_JSON_ENCRYPTED_MAGIC)) {
                throw new IllegalStateException("contents.json magic mismatch: " + Arrays.toString(CONTENTS_JSON_ENCRYPTED_MAGIC) + " != " + Arrays.toString(magic));
            }
            contents.readerIndex(16);
            short contentIdLength = contents.readUnsignedByte();
            byte[] contentIdBytes = new byte[contentIdLength];
            contents.readBytes(contentIdBytes);
            String contentId = new String(contentIdBytes, StandardCharsets.UTF_8);
            if (!this.contentId.equalsIgnoreCase(contentId)) {
                throw new IllegalStateException("contents.json contentId mismatch: " + this.contentId + " != " + contentId);
            }
            contents.readerIndex(256);
            byte[] encryptedContents = new byte[contents.readableBytes()];
            contents.readBytes(encryptedContents);
            this.content.put("contents.json", aesCfb8.doFinal(encryptedContents));
            JsonObject contentsJson = this.content.getJson("contents.json");
            JsonArray contentArray = contentsJson.getAsJsonArray("content");
            block11: for (JsonElement element : contentArray) {
                JsonObject contentItem = element.getAsJsonObject();
                if (!contentItem.has("key")) continue;
                String key = contentItem.get("key").getAsString();
                String path = contentItem.get("path").getAsString();
                if (!this.content.containsKey(path)) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing resource pack file: " + path);
                    continue;
                }
                switch (path) {
                    case "manifest.json": 
                    case "pack_icon.png": 
                    case "README.txt": {
                        continue block11;
                    }
                }
                byte[] encryptedData = (byte[])this.content.get(path);
                byte[] keyBytes = key.getBytes(StandardCharsets.ISO_8859_1);
                aesCfb8.init(2, (Key)new SecretKeySpec(keyBytes, "AES"), new IvParameterSpec(Arrays.copyOfRange(keyBytes, 0, 16)));
                this.content.put(path, aesCfb8.doFinal(encryptedData));
            }
        }
        if (VALIDATE_MANIFEST) {
            JsonObject manifestJson = this.content.getJson("manifest.json");
            int formatVersion = manifestJson.get("format_version").getAsInt();
            if (formatVersion != 1 && formatVersion != 2) {
                throw new IllegalStateException("Unsupported resource pack format version: " + formatVersion);
            }
            JsonObject headerObj = manifestJson.getAsJsonObject("header");
            UUID packId = UUID.fromString(headerObj.get("uuid").getAsString());
            if (!this.packId.equals(packId)) {
                throw new IllegalStateException("manifest.json packId mismatch: " + this.packId + " != " + packId);
            }
            JsonArray versionArray = headerObj.getAsJsonArray("version");
            StringBuilder version = new StringBuilder();
            for (JsonElement digit : versionArray) {
                version.append(digit.getAsString()).append(".");
            }
            version.deleteCharAt(version.length() - 1);
            if (!this.version.contentEquals(version)) {
                throw new IllegalStateException("manifest.json version mismatch: " + this.version + " != " + version);
            }
        }
    }

    private boolean hasReceivedAllChunks() {
        for (boolean receivedChunk : this.receivedChunks) {
            if (receivedChunk) continue;
            return false;
        }
        return true;
    }

    public static class Content
    extends HashMap<String, byte[]> {
        private final Map<String, Map<String, String>> langCache = new HashMap<String, Map<String, String>>();

        public String getString(String path) {
            byte[] bytes = (byte[])this.get(path);
            if (bytes == null) {
                return null;
            }
            return new String(bytes, StandardCharsets.UTF_8);
        }

        public boolean putString(String path, String string) {
            return this.put(path, string.getBytes(StandardCharsets.UTF_8)) != null;
        }

        public List<String> getLines(String path) {
            String string = this.getString(path);
            if (string == null) {
                return null;
            }
            return Collections.unmodifiableList(Arrays.asList(string.split("\\n")));
        }

        public boolean putLines(String path, List<String> lines) {
            return this.putString(path, String.join((CharSequence)"\\n", lines));
        }

        public Map<String, String> getLang(String path) {
            return this.langCache.computeIfAbsent(path, k -> {
                List<String> lines = this.getLines((String)k);
                return Collections.unmodifiableMap(lines.stream().filter(line -> !line.startsWith("##")).filter(line -> line.contains("=")).map(line -> line.contains("##") ? line.substring(0, line.indexOf("##")) : line).map(String::trim).map(line -> line.split("=", 2)).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1])));
            });
        }

        public boolean putLang(String path, Map<String, String> lang) {
            this.langCache.put(path, lang);
            ArrayList<String> lines = new ArrayList<String>();
            for (Map.Entry<String, String> entry : lang.entrySet()) {
                lines.add(entry.getKey() + "=" + entry.getValue());
            }
            return this.putLines(path, lines);
        }

        public JsonObject getJson(String path) {
            String string = this.getString(path);
            if (string == null) {
                return null;
            }
            return GsonUtil.getGson().fromJson(string.trim(), JsonObject.class);
        }

        public JsonObject getSortedJson(String path) {
            return JsonUtil.sort(this.getJson(path), Comparator.naturalOrder());
        }

        public boolean putJson(String path, JsonObject json) {
            return this.putString(path, GsonUtil.getGson().toJson(json));
        }

        public BufferedImage getImage(String path) {
            byte[] bytes = (byte[])this.get(path);
            if (bytes == null) {
                return null;
            }
            try {
                return ImageIO.read(new ByteArrayInputStream(bytes));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean putImage(String path, BufferedImage image) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)image, "png", baos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.put(path, baos.toByteArray()) != null;
        }

        public byte[] toZip() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(0x400000);
            ZipOutputStream zipOutputStream = new ZipOutputStream(baos);
            for (Map.Entry entry : this.entrySet()) {
                zipOutputStream.putNextEntry(new ZipEntry((String)entry.getKey()));
                zipOutputStream.write((byte[])entry.getValue());
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
            return baos.toByteArray();
        }
    }
}

