/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.entity;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import com.viaversion.viaversion.util.Pair;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.entity.PlayerEntity;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.model.Position2f;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.storage.ChunkTracker;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.PacketSyncStorage;
import net.raphimc.viabedrock.protocol.storage.PlayerListStorage;
import net.raphimc.viabedrock.protocol.storage.SpawnPositionStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class ClientPlayerEntity
extends PlayerEntity {
    private final AtomicInteger TELEPORT_ID = new AtomicInteger(1);
    private final GameSessionStorage gameSession;
    private boolean initiallySpawned;
    private boolean respawning;
    private boolean changingDimension;
    private boolean wasInsideUnloadedChunk;
    private int pendingTeleportId = 0;
    private boolean waitingForPositionSync = false;
    private Position3f prevPosition;
    private boolean prevOnGround;
    private long authInput;
    private int gameType;

    public ClientPlayerEntity(UserConnection user, long uniqueId, long runtimeId, int javaId, UUID javaUuid) {
        super(user, uniqueId, runtimeId, javaId, javaUuid);
        this.gameSession = user.get(GameSessionStorage.class);
    }

    @Override
    public void tick() throws Exception {
        super.tick();
        if (this.gameSession.getMovementMode() >= 1) {
            this.sendAuthInputPacketToServer(this.initiallySpawned ? 2 : 0);
        }
        if (this.respawning && this.gameSession.getMovementMode() == 0) {
            this.sendMovePlayerPacketToServer((short)1);
        }
    }

    public void closeDownloadingTerrainScreen() throws Exception {
        SpawnPositionStorage spawnPositionStorage = this.user.get(SpawnPositionStorage.class);
        ChunkTracker chunkTracker = this.user.get(ChunkTracker.class);
        PacketWrapper spawnPosition = PacketWrapper.create(ClientboundPackets1_19_4.SPAWN_POSITION, this.user);
        spawnPosition.write(Type.POSITION1_14, spawnPositionStorage.getSpawnPosition(chunkTracker.getDimensionId()));
        spawnPosition.write(Type.FLOAT, Float.valueOf(0.0f));
        spawnPosition.send(BedrockProtocol.class);
    }

    public void sendPlayerPositionPacketToClient(boolean keepRotation) throws Exception {
        this.sendPlayerPositionPacketToClient(keepRotation, true);
    }

    public void sendPlayerPositionPacketToClient(boolean keepRotation, boolean fakeTeleport) throws Exception {
        PacketWrapper playerPosition = PacketWrapper.create(ClientboundPackets1_19_4.PLAYER_POSITION, this.user);
        this.writePlayerPositionPacketToClient(playerPosition, keepRotation, fakeTeleport);
        playerPosition.send(BedrockProtocol.class);
    }

    public void writePlayerPositionPacketToClient(PacketWrapper wrapper, boolean keepRotation, boolean fakeTeleport) {
        wrapper.write(Type.DOUBLE, Double.valueOf(this.position.x()));
        wrapper.write(Type.DOUBLE, (double)this.position.y() - (double)this.eyeOffset());
        wrapper.write(Type.DOUBLE, Double.valueOf(this.position.z()));
        wrapper.write(Type.FLOAT, Float.valueOf(keepRotation ? 0.0f : this.rotation.y()));
        wrapper.write(Type.FLOAT, Float.valueOf(keepRotation ? 0.0f : this.rotation.x()));
        wrapper.write(Type.BYTE, (byte)(keepRotation ? 24 : 0));
        wrapper.write(Type.VAR_INT, this.nextTeleportId() * (fakeTeleport ? -1 : 1));
    }

    public void sendMovePlayerPacketToServer(short mode) throws Exception {
        PacketWrapper movePlayer = PacketWrapper.create(ServerboundBedrockPackets.MOVE_PLAYER, this.user);
        this.writeMovementPacketToServer(movePlayer, mode);
        movePlayer.sendToServer(BedrockProtocol.class);
    }

    public void writeMovementPacketToServer(PacketWrapper wrapper, short mode) {
        wrapper.write(BedrockTypes.UNSIGNED_VAR_LONG, this.runtimeId);
        wrapper.write(BedrockTypes.POSITION_3F, this.position);
        wrapper.write(BedrockTypes.POSITION_3F, this.rotation);
        wrapper.write(Type.UNSIGNED_BYTE, mode);
        wrapper.write(Type.BOOLEAN, this.onGround);
        wrapper.write(BedrockTypes.UNSIGNED_VAR_LONG, 0L);
        wrapper.write(BedrockTypes.UNSIGNED_VAR_LONG, 0L);
    }

    public void sendAuthInputPacketToServer(int playMode) throws Exception {
        if (!this.prevOnGround && this.onGround) {
            this.prevOnGround = true;
            this.sendMovePlayerPacketToServer((short)0);
        }
        if (this.prevPosition == null) {
            this.prevPosition = this.position;
        }
        float[] motion = this.calculateDirectionVector(this.position.x(), this.position.z(), this.prevPosition.x(), this.prevPosition.z(), this.rotation.y());
        this.fixDirectionVector(motion);
        this.prevPosition = this.position;
        PacketWrapper playerAuthInput = PacketWrapper.create(ServerboundBedrockPackets.PLAYER_AUTH_INPUT, this.user);
        playerAuthInput.write(BedrockTypes.FLOAT_LE, Float.valueOf(this.rotation.x()));
        playerAuthInput.write(BedrockTypes.FLOAT_LE, Float.valueOf(this.rotation.y()));
        playerAuthInput.write(BedrockTypes.POSITION_3F, this.position);
        playerAuthInput.write(BedrockTypes.POSITION_2F, new Position2f(motion[0], motion[1]));
        playerAuthInput.write(BedrockTypes.FLOAT_LE, Float.valueOf(this.rotation.z()));
        playerAuthInput.write(BedrockTypes.UNSIGNED_VAR_LONG, this.authInput);
        playerAuthInput.write(BedrockTypes.UNSIGNED_VAR_INT, 1);
        playerAuthInput.write(BedrockTypes.UNSIGNED_VAR_INT, playMode);
        playerAuthInput.write(BedrockTypes.UNSIGNED_VAR_INT, 0);
        playerAuthInput.write(BedrockTypes.UNSIGNED_VAR_LONG, Long.valueOf(this.age));
        playerAuthInput.write(BedrockTypes.POSITION_3F, new Position3f(0.0f, 0.0f, 0.0f));
        playerAuthInput.write(BedrockTypes.POSITION_2F, new Position2f(0.0f, 0.0f));
        this.authInput = 0L;
    }

    public void sendPlayerActionPacketToServer(int action, int face) throws Exception {
        PacketWrapper playerAction = PacketWrapper.create(ServerboundBedrockPackets.PLAYER_ACTION, this.user);
        playerAction.write(BedrockTypes.UNSIGNED_VAR_LONG, this.runtimeId);
        playerAction.write(BedrockTypes.VAR_INT, action);
        playerAction.write(BedrockTypes.BLOCK_POSITION, new Position(0, 0, 0));
        playerAction.write(BedrockTypes.BLOCK_POSITION, new Position(0, 0, 0));
        playerAction.write(BedrockTypes.VAR_INT, face);
        playerAction.sendToServer(BedrockProtocol.class);
    }

    public void updatePlayerPosition(PacketWrapper wrapper, boolean onGround) throws Exception {
        if (!this.preMove(null, false)) {
            wrapper.cancel();
            return;
        }
        this.onGround = onGround;
        if (this.gameSession.getMovementMode() == 0) {
            this.writeMovementPacketToServer(wrapper, (short)0);
        } else {
            wrapper.cancel();
        }
    }

    public void updatePlayerPosition(PacketWrapper wrapper, double x, double y, double z, boolean onGround) throws Exception {
        Position3f newPosition = new Position3f((float)x, (float)y + this.eyeOffset(), (float)z);
        if (!this.preMove(newPosition, false)) {
            wrapper.cancel();
            return;
        }
        this.position = newPosition;
        this.onGround = onGround;
        if (this.gameSession.getMovementMode() == 0) {
            this.writeMovementPacketToServer(wrapper, (short)0);
        } else {
            wrapper.cancel();
        }
    }

    public void updatePlayerPosition(PacketWrapper wrapper, double x, double y, double z, float yaw, float pitch, boolean onGround) throws Exception {
        Position3f newPosition = new Position3f((float)x, (float)y + this.eyeOffset(), (float)z);
        Position3f newRotation = new Position3f(pitch, yaw, yaw);
        if (!this.preMove(newPosition, true)) {
            wrapper.cancel();
            return;
        }
        this.position = newPosition;
        this.rotation = newRotation;
        this.onGround = onGround;
        if (this.gameSession.getMovementMode() == 0) {
            this.writeMovementPacketToServer(wrapper, (short)0);
        } else {
            wrapper.cancel();
        }
    }

    public void updatePlayerPosition(PacketWrapper wrapper, float yaw, float pitch, boolean onGround) throws Exception {
        Position3f newRotation = new Position3f(pitch, yaw, yaw);
        if (!this.preMove(null, false)) {
            wrapper.cancel();
            return;
        }
        this.rotation = newRotation;
        this.onGround = onGround;
        if (this.gameSession.getMovementMode() == 0) {
            this.writeMovementPacketToServer(wrapper, (short)0);
        } else {
            wrapper.cancel();
        }
    }

    public void confirmTeleport(int teleportId) throws Exception {
        if (teleportId < 0) {
            if (this.pendingTeleportId == -teleportId) {
                this.pendingTeleportId = 0;
            }
        } else {
            if (!this.initiallySpawned || this.respawning) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received teleport confirm for teleport id " + teleportId + " but player is not spawned yet");
            }
            if (this.gameSession.getMovementMode() == 0) {
                this.sendPlayerActionPacketToServer(30, 0);
            } else if (this.gameSession.getMovementMode() >= 1) {
                this.authInput |= 0x25L;
            }
        }
    }

    public int nextTeleportId() {
        this.pendingTeleportId = this.TELEPORT_ID.getAndIncrement();
        return this.pendingTeleportId;
    }

    @Override
    public void setPosition(Position3f position) {
        this.prevPosition = position;
        super.setPosition(position);
    }

    @Override
    public void setOnGround(boolean onGround) {
        this.prevOnGround = onGround;
        super.setOnGround(onGround);
    }

    @Override
    public String name() {
        PlayerListStorage playerList = this.user.get(PlayerListStorage.class);
        Pair<Long, String> entry = playerList.getPlayer(this.javaUuid);
        if (entry != null) {
            return entry.value();
        }
        return this.name;
    }

    public boolean isInitiallySpawned() {
        return this.initiallySpawned;
    }

    public void setInitiallySpawned() {
        this.initiallySpawned = true;
        this.respawning = false;
    }

    public boolean isRespawning() {
        return this.respawning;
    }

    public void setRespawning(boolean respawning) {
        this.respawning = respawning;
    }

    public boolean isChangingDimension() {
        return this.changingDimension;
    }

    public void setChangingDimension(boolean changingDimension) {
        this.changingDimension = changingDimension;
    }

    public int getGameType() {
        return this.gameType;
    }

    public void setGameType(int gameType) {
        this.gameType = gameType;
    }

    private boolean preMove(Position3f newPosition, boolean positionLook) throws Exception {
        ChunkTracker chunkTracker = this.user.get(ChunkTracker.class);
        if (this.waitingForPositionSync) {
            if (this.pendingTeleportId == 0 && positionLook) {
                this.waitingForPositionSync = false;
            }
            return false;
        }
        if (chunkTracker.isInUnloadedChunkSection(this.position)) {
            this.wasInsideUnloadedChunk = true;
            if (!this.position.equals(newPosition)) {
                if (!this.initiallySpawned || this.respawning || this.changingDimension) {
                    this.sendPlayerPositionPacketToClient(false);
                } else {
                    this.waitingForPositionSync = true;
                    this.sendPlayerPositionPacketToClient(true);
                }
            }
            return false;
        }
        if (this.wasInsideUnloadedChunk) {
            this.wasInsideUnloadedChunk = false;
            this.waitingForPositionSync = true;
            this.sendPlayerPositionPacketToClient(true);
            if (this.changingDimension) {
                this.user.get(PacketSyncStorage.class).syncWithClient(() -> {
                    this.sendPlayerActionPacketToServer(14, 0);
                    this.closeDownloadingTerrainScreen();
                    this.changingDimension = false;
                    this.respawning = false;
                    return null;
                });
            }
            return false;
        }
        if (newPosition != null && chunkTracker.isInUnloadedChunkSection(newPosition)) {
            this.waitingForPositionSync = true;
            this.sendPlayerPositionPacketToClient(true);
            return false;
        }
        if (!this.initiallySpawned || this.respawning || this.changingDimension) {
            if (!this.position.equals(newPosition)) {
                this.sendPlayerPositionPacketToClient(false);
            }
            return false;
        }
        return true;
    }

    private float[] calculateDirectionVector(float x, float z, float prevX, float prevZ, float yaw) {
        float dx = x - prevX;
        float dz = z - prevZ;
        double magnitude = Math.sqrt(dx * dx + dz * dz);
        double directionX = magnitude > 0.0 ? (double)dx / magnitude : 0.0;
        double directionZ = magnitude > 0.0 ? (double)dz / magnitude : 0.0;
        directionX = Math.max(-1.0, Math.min(1.0, directionX));
        directionZ = Math.max(-1.0, Math.min(1.0, directionZ));
        double angle = Math.toRadians(-yaw);
        double newDirectionX = directionX * Math.cos(angle) - directionZ * Math.sin(angle);
        double newDirectionZ = directionX * Math.sin(angle) + directionZ * Math.cos(angle);
        directionX = newDirectionX;
        directionZ = newDirectionZ;
        return new float[]{(float)directionX, (float)directionZ};
    }

    private void fixDirectionVector(float[] vector) {
        if (Math.abs(vector[0]) <= 0.5f) {
            vector[0] = 0.0f;
        }
        if (Math.abs(vector[1]) <= 0.5f) {
            vector[1] = 0.0f;
        }
        if (Math.abs(vector[0]) <= 0.8f) {
            vector[0] = Math.signum(vector[0]) * 0.70710677f;
        }
        if (Math.abs(vector[1]) <= 0.8f) {
            vector[1] = Math.signum(vector[1]) * 0.70710677f;
        }
        if (Math.abs(vector[0]) > 0.8f) {
            vector[0] = Math.signum(vector[0]);
        }
        if (Math.abs(vector[1]) > 0.8f) {
            vector[1] = Math.signum(vector[1]);
        }
    }
}

