/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.scoreboard;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.util.Pair;
import java.util.Objects;
import java.util.UUID;
import net.raphimc.viabedrock.api.util.StringUtil;
import net.raphimc.viabedrock.protocol.storage.PlayerListStorage;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class ScoreboardEntry {
    public static final int ACTION_CHANGE = 0;
    public static final int ACTION_REMOVE = 1;
    private boolean isPlayerId;
    private Long entityId;
    private String fakePlayerName;
    private int score;
    private String javaName;

    public ScoreboardEntry(int score, boolean isPlayerId, Long entityId, String fakePlayerName) {
        this.updateTarget(isPlayerId, entityId, fakePlayerName);
        this.score = score;
    }

    public boolean isSameTarget(ScoreboardEntry entry) {
        return this.isPlayerId == entry.isPlayerId && Objects.equals(this.entityId, entry.entityId) && Objects.equals(this.fakePlayerName, entry.fakePlayerName);
    }

    public void updateTarget(boolean isPlayerId, Long entityId, String fakePlayerName) {
        this.isPlayerId = isPlayerId;
        this.entityId = entityId;
        this.fakePlayerName = fakePlayerName;
    }

    public boolean isValid() {
        return this.entityId != null || this.fakePlayerName != null;
    }

    public boolean isPlayerId() {
        return this.isPlayerId;
    }

    public Long entityId() {
        return this.entityId;
    }

    public String fakePlayerName() {
        return this.fakePlayerName;
    }

    public int score() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public String javaName() {
        return this.javaName;
    }

    public void updateJavaName(UserConnection user) {
        if (this.entityId != null && this.isPlayerId) {
            PlayerListStorage playerList = user.get(PlayerListStorage.class);
            Pair<UUID, String> player = playerList.getPlayer(this.entityId);
            this.javaName = player != null ? player.value() : StringUtil.encodeLong(this.entityId) + user.get(ResourcePacksStorage.class).getTranslations().get("commands.scoreboard.players.offlinePlayerName");
        } else if (this.entityId != null) {
            this.javaName = String.valueOf(this.entityId);
        } else if (this.fakePlayerName != null) {
            this.javaName = this.fakePlayerName;
        }
    }
}

