/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.scoreboard;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import java.util.HashMap;
import java.util.Map;
import net.raphimc.viabedrock.api.model.scoreboard.ScoreboardEntry;
import net.raphimc.viabedrock.protocol.BedrockProtocol;

public class ScoreboardObjective {
    private final String name;
    private final Map<Long, ScoreboardEntry> entries;
    private final boolean ascending;

    public ScoreboardObjective(String name, boolean ascending) {
        this.name = name;
        this.entries = new HashMap<Long, ScoreboardEntry>();
        this.ascending = ascending;
    }

    public ScoreboardEntry getEntry(long scoreboardId) {
        return this.entries.get(scoreboardId);
    }

    public ScoreboardEntry getEntryWithSameTarget(ScoreboardEntry entry) {
        for (ScoreboardEntry value : this.entries.values()) {
            if (!value.isSameTarget(entry)) continue;
            return value;
        }
        return null;
    }

    public ScoreboardEntry getEntryForPlayer(long playerListId) {
        for (ScoreboardEntry value : this.entries.values()) {
            if (value.entityId() == null || !value.isPlayerId() || playerListId != value.entityId()) continue;
            return value;
        }
        return null;
    }

    public void addEntry(UserConnection user, long scoreboardId, ScoreboardEntry entry) throws Exception {
        this.entries.put(scoreboardId, entry);
        entry.updateJavaName(user);
        this.updateEntry(user, entry, 0);
    }

    public void updateEntry(UserConnection user, ScoreboardEntry entry) throws Exception {
        this.updateEntry(user, entry, 1);
        entry.updateJavaName(user);
        this.updateEntry(user, entry, 0);
    }

    public void removeEntry(UserConnection user, long scoreboardId) throws Exception {
        ScoreboardEntry entry = this.entries.remove(scoreboardId);
        this.updateEntry(user, entry, 1);
    }

    public void updateEntry(UserConnection user, ScoreboardEntry entry, int action) throws Exception {
        PacketWrapper updateScore = PacketWrapper.create(ClientboundPackets1_19_4.UPDATE_SCORE, user);
        updateScore.write(Type.STRING, entry.javaName());
        updateScore.write(Type.VAR_INT, action);
        updateScore.write(Type.STRING, this.name);
        if (action == 0) {
            updateScore.write(Type.VAR_INT, this.ascending ? -entry.score() : entry.score());
        }
        updateScore.send(BedrockProtocol.class);
    }
}

