/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.modinterface;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.model.SkinData;
import net.raphimc.viabedrock.protocol.types.primitive.ImageType;

public class BedrockSkinUtilityInterface {
    public static final String CHANNEL = "bedrockskin:data";
    private static final int VERSION = 1;
    private static final int MESSAGE_CAPE = 0;
    private static final int MESSAGE_SKIN_INFORMATION = 1;
    private static final int MESSAGE_SKIN_DATA = 2;
    private static final int MAX_PAYLOAD_SIZE = 0x100000;

    public static void sendSkin(UserConnection user, UUID uuid, SkinData skin) throws Exception {
        PacketWrapper pluginMessage;
        if (skin.skinData() == null || skin.persona()) {
            return;
        }
        boolean hasGeometry = !skin.geometryData().isEmpty() && !skin.geometryData().toLowerCase(Locale.ROOT).equals("null");
        byte[] skinData = ImageType.getImageData(skin.skinData());
        int maxPayloadSize = 1048552;
        int chunkCount = (int)Math.ceil((double)skinData.length / 1048552.0);
        PacketWrapper pluginMessage2 = PacketWrapper.create(ClientboundPackets1_19_4.PLUGIN_MESSAGE, user);
        pluginMessage2.write(Type.STRING, CHANNEL);
        pluginMessage2.write(Type.INT, 1);
        pluginMessage2.write(Type.INT, 1);
        pluginMessage2.write(Type.UUID, uuid);
        pluginMessage2.write(Type.INT, skin.skinData().getWidth());
        pluginMessage2.write(Type.INT, skin.skinData().getHeight());
        pluginMessage2.write(Type.BOOLEAN, hasGeometry);
        if (hasGeometry) {
            BedrockSkinUtilityInterface.writeString(pluginMessage2, skin.geometryData());
            BedrockSkinUtilityInterface.writeString(pluginMessage2, skin.skinResourcePatch());
        }
        pluginMessage2.write(Type.INT, chunkCount);
        pluginMessage2.send(BedrockProtocol.class);
        for (int i = 0; i < chunkCount; ++i) {
            pluginMessage = PacketWrapper.create(ClientboundPackets1_19_4.PLUGIN_MESSAGE, user);
            pluginMessage.write(Type.STRING, CHANNEL);
            pluginMessage.write(Type.INT, 2);
            pluginMessage.write(Type.UUID, uuid);
            pluginMessage.write(Type.INT, i);
            if (chunkCount == 1) {
                pluginMessage.write(Type.REMAINING_BYTES, skinData);
            } else {
                pluginMessage.write(Type.REMAINING_BYTES, Arrays.copyOfRange(skinData, i * 1048552, Math.min((i + 1) * 1048552, skinData.length)));
            }
            pluginMessage.send(BedrockProtocol.class);
        }
        if (skin.capeData() != null) {
            byte[] capeData = ImageType.getImageData(skin.capeData());
            pluginMessage = PacketWrapper.create(ClientboundPackets1_19_4.PLUGIN_MESSAGE, user);
            pluginMessage.write(Type.STRING, CHANNEL);
            pluginMessage.write(Type.INT, 0);
            pluginMessage.write(Type.INT, 1);
            pluginMessage.write(Type.UUID, uuid);
            pluginMessage.write(Type.INT, skin.capeData().getWidth());
            pluginMessage.write(Type.INT, skin.capeData().getHeight());
            BedrockSkinUtilityInterface.writeString(pluginMessage, skin.capeId());
            pluginMessage.write(Type.INT, capeData.length);
            pluginMessage.write(Type.REMAINING_BYTES, capeData);
            pluginMessage.send(BedrockProtocol.class);
        }
    }

    private static void writeString(PacketWrapper wrapper, String s) {
        wrapper.write(Type.INT, s.length());
        wrapper.write(Type.REMAINING_BYTES, s.getBytes(StandardCharsets.UTF_8));
    }
}

