/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.util;

import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.libs.gson.JsonParser;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import net.lenni0451.mcstructs.core.TextFormatting;
import net.lenni0451.mcstructs.text.serializer.LegacyStringDeserializer;
import net.lenni0451.mcstructs.text.serializer.TextComponentSerializer;
import net.lenni0451.mcstructs_bedrock.text.BedrockTextFormatting;

public class JsonUtil {
    public static String textToJson(String text) {
        return TextComponentSerializer.V1_19_4.serialize(LegacyStringDeserializer.parse(text, '\u00a7', c -> Optional.ofNullable(BedrockTextFormatting.getByCode(c.charValue())).map(f -> {
            if (f.isColor()) {
                return new TextFormatting(f.getRgbValue());
            }
            if (f.equals((Object)BedrockTextFormatting.OBFUSCATED)) {
                return TextFormatting.OBFUSCATED;
            }
            if (f.equals((Object)BedrockTextFormatting.BOLD)) {
                return TextFormatting.BOLD;
            }
            if (f.equals((Object)BedrockTextFormatting.ITALIC)) {
                return TextFormatting.ITALIC;
            }
            if (f.equals((Object)BedrockTextFormatting.RESET)) {
                return TextFormatting.RESET;
            }
            throw new IllegalArgumentException("Unknown formatting: " + (Object)f);
        }).orElse(null)));
    }

    public static JsonElement textToComponent(String text) {
        return JsonParser.parseString(JsonUtil.textToJson(text));
    }

    public static <T extends JsonElement> T sort(T element, Comparator<String> comparator) {
        if (element == null) {
            return null;
        }
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                array.set(i, JsonUtil.sort(array.get(i), comparator));
            }
            return (T)array;
        }
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            JsonObject sorted = new JsonObject();
            ArrayList<String> keys = new ArrayList<String>(object.keySet());
            keys.sort(comparator);
            for (String key : keys) {
                sorted.add(key, JsonUtil.sort(object.get(key), comparator));
            }
            return (T)sorted;
        }
        return element;
    }
}

