/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.netty;

import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class PacketEncapsulationCodec
extends ByteToMessageCodec<ByteBuf> {
    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) {
        int packetId = Type.VAR_INT.readPrimitive(in);
        int header = packetId & 0x3FF;
        BedrockTypes.UNSIGNED_VAR_INT.writePrimitive(out, header);
        out.writeBytes(in);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        int header = BedrockTypes.UNSIGNED_VAR_INT.readPrimitive(in);
        int packetId = header & 0x3FF;
        int senderId = header >>> 10 & 3;
        int clientId = header >>> 12 & 3;
        if (senderId != 0) {
            throw new UnsupportedOperationException("Sender ID " + senderId + " is not supported");
        }
        if (clientId != 0) {
            throw new UnsupportedOperationException("Client ID " + clientId + " is not supported");
        }
        ByteBuf packet = ctx.alloc().buffer();
        Type.VAR_INT.writePrimitive(packet, packetId);
        packet.writeBytes(in);
        out.add(packet);
    }
}

