/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class ZLibCompression
extends ByteToMessageCodec<ByteBuf> {
    private final byte[] deflateBuffer = new byte[8192];
    private final byte[] inflateBuffer = new byte[8192];
    private Deflater deflater;
    private Inflater inflater;

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        if (this.inflater != null) {
            this.inflater.end();
        }
        if (this.deflater != null) {
            this.deflater.end();
        }
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) {
        if (this.deflater == null) {
            this.deflater = new Deflater(-1, true);
        }
        byte[] uncompressedData = new byte[in.readableBytes()];
        in.readBytes(uncompressedData);
        this.deflater.setInput(uncompressedData);
        this.deflater.finish();
        while (!this.deflater.finished()) {
            out.writeBytes(this.deflateBuffer, 0, this.deflater.deflate(this.deflateBuffer));
        }
        this.deflater.reset();
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (this.inflater == null) {
            this.inflater = new Inflater(true);
        }
        byte[] compressedData = new byte[in.readableBytes()];
        in.readBytes(compressedData);
        this.inflater.setInput(compressedData);
        ByteBuf uncompressedData = ctx.alloc().buffer();
        while (!this.inflater.finished()) {
            uncompressedData.writeBytes(this.inflateBuffer, 0, this.inflater.inflate(this.inflateBuffer));
        }
        this.inflater.reset();
        out.add(uncompressedData);
    }
}

