/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.platform;

import com.google.common.collect.Range;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.ProtocolManager;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.io.File;
import java.util.logging.Logger;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.ViaBedrockConfig;
import net.raphimc.viabedrock.api.BedrockProtocolVersion;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.EmptyBaseProtocol;

public interface ViaBedrockPlatform {
    default public void init(File dataFolder) {
        ViaBedrockConfig config = new ViaBedrockConfig(new File(dataFolder, "viabedrock.yml"));
        config.reloadConfig();
        ViaBedrock.init(this, config);
        Via.getManager().getSubPlatforms().add("ViaBedrock-0.0.2-SNAPSHOT");
        ProtocolManager protocolManager = Via.getManager().getProtocolManager();
        protocolManager.registerProtocol((Protocol)new BedrockProtocol(), ProtocolVersion.v1_20, BedrockProtocolVersion.bedrockLatest);
        protocolManager.registerBaseProtocol(new EmptyBaseProtocol(), (Range<Integer>)Range.singleton((Comparable)Integer.valueOf(BedrockProtocolVersion.bedrockLatest.getVersion())));
        this.getServerPacksFolder().mkdirs();
    }

    public Logger getLogger();

    public File getDataFolder();

    default public File getDataCacheFolder() {
        return new File(this.getDataFolder(), "viabedrock");
    }

    default public File getServerPacksFolder() {
        return new File(this.getDataCacheFolder(), "server_packs");
    }
}

