/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.platform.providers.ViaProviders;
import com.viaversion.viaversion.api.protocol.AbstractProtocol;
import com.viaversion.viaversion.api.protocol.packet.Direction;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.packet.mapping.PacketMappings;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.exception.CancelException;
import com.viaversion.viaversion.protocols.base.ClientboundLoginPackets;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ServerboundPackets1_19_4;
import java.util.EnumSet;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.util.JsonUtil;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.BedrockMappingData;
import net.raphimc.viabedrock.protocol.packetmapping.ClientboundPacketMappings;
import net.raphimc.viabedrock.protocol.packets.ChatPackets;
import net.raphimc.viabedrock.protocol.packets.ClientPlayerPackets;
import net.raphimc.viabedrock.protocol.packets.EntityPackets;
import net.raphimc.viabedrock.protocol.packets.HudPackets;
import net.raphimc.viabedrock.protocol.packets.JoinPackets;
import net.raphimc.viabedrock.protocol.packets.LoginPackets;
import net.raphimc.viabedrock.protocol.packets.OtherPlayerPackets;
import net.raphimc.viabedrock.protocol.packets.PlayPackets;
import net.raphimc.viabedrock.protocol.packets.ResourcePackPackets;
import net.raphimc.viabedrock.protocol.packets.StatusPackets;
import net.raphimc.viabedrock.protocol.packets.WorldPackets;
import net.raphimc.viabedrock.protocol.providers.BlobCacheProvider;
import net.raphimc.viabedrock.protocol.providers.DiskResourcePackProvider;
import net.raphimc.viabedrock.protocol.providers.NettyPipelineProvider;
import net.raphimc.viabedrock.protocol.providers.ResourcePackProvider;
import net.raphimc.viabedrock.protocol.providers.SkinProvider;
import net.raphimc.viabedrock.protocol.storage.BlobCache;
import net.raphimc.viabedrock.protocol.storage.ChannelStorage;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.PacketSyncStorage;
import net.raphimc.viabedrock.protocol.storage.PlayerListStorage;
import net.raphimc.viabedrock.protocol.storage.ScoreboardTracker;
import net.raphimc.viabedrock.protocol.storage.SpawnPositionStorage;
import net.raphimc.viabedrock.protocol.task.BlobCacheTickTask;
import net.raphimc.viabedrock.protocol.task.ChunkTrackerTickTask;
import net.raphimc.viabedrock.protocol.task.EntityTrackerTickTask;
import net.raphimc.viabedrock.protocol.task.KeepAliveTask;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class BedrockProtocol
extends AbstractProtocol<ClientboundBedrockPackets, ClientboundPackets1_19_4, ServerboundBedrockPackets, ServerboundPackets1_19_4> {
    public static final BedrockMappingData MAPPINGS = new BedrockMappingData();
    private static final EnumSet<ClientboundBedrockPackets> BEFORE_START_GAME_WHITELIST = EnumSet.of(ClientboundBedrockPackets.RESOURCE_PACKS_INFO, new ClientboundBedrockPackets[]{ClientboundBedrockPackets.RESOURCE_PACK_DATA_INFO, ClientboundBedrockPackets.RESOURCE_PACK_CHUNK_DATA, ClientboundBedrockPackets.RESOURCE_PACK_STACK, ClientboundBedrockPackets.DISCONNECT, ClientboundBedrockPackets.PLAY_STATUS, ClientboundBedrockPackets.NETWORK_STACK_LATENCY, ClientboundBedrockPackets.AVAILABLE_COMMANDS, ClientboundBedrockPackets.START_GAME, ClientboundBedrockPackets.PACKET_VIOLATION_WARNING});

    public BedrockProtocol() {
        super(ClientboundBedrockPackets.class, ClientboundPackets1_19_4.class, ServerboundBedrockPackets.class, ServerboundPackets1_19_4.class);
    }

    @Override
    protected void registerPackets() {
        StatusPackets.register(this);
        LoginPackets.register(this);
        PlayPackets.register(this);
        ResourcePackPackets.register(this);
        JoinPackets.register(this);
        ChatPackets.register(this);
        ClientPlayerPackets.register(this);
        OtherPlayerPackets.register(this);
        WorldPackets.register(this);
        EntityPackets.register(this);
        HudPackets.register(this);
        this.registerClientbound(ClientboundBedrockPackets.PACKET_VIOLATION_WARNING, ClientboundPackets1_19_4.DISCONNECT, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    int type = wrapper.read(BedrockTypes.VAR_INT) + 1;
                    int severity = wrapper.read(BedrockTypes.VAR_INT) + 1;
                    int packetIdCause = wrapper.read(BedrockTypes.VAR_INT) - 1;
                    String context = wrapper.read(BedrockTypes.STRING);
                    String[] types = new String[]{"Unknown", "Malformed packet"};
                    String[] severities = new String[]{"Unknown", "Warning", "Final warning", "Terminating connection"};
                    String reason = "\u00a74Packet violation warning: \u00a7c" + (type >= 0 && type <= types.length ? types[type] : Integer.valueOf(type)) + " (" + (severity >= 0 && severity <= severities.length ? severities[severity] : Integer.valueOf(severity)) + ")\nViolating Packet: " + (ServerboundBedrockPackets.getPacket(packetIdCause) != null ? ServerboundBedrockPackets.getPacket(packetIdCause).name() : Integer.valueOf(packetIdCause)) + "\n" + (context.isEmpty() ? "No context provided" : " Context: '" + context + "'") + "\n\nPlease report this issue on the ViaBedrock GitHub page!";
                    wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(reason));
                });
            }
        });
        for (ClientboundBedrockPackets clientboundBedrockPackets : (ClientboundBedrockPackets[])this.unmappedClientboundPacketType.getEnumConstants()) {
            if (this.hasRegisteredClientbound(clientboundBedrockPackets)) continue;
            this.cancelClientbound(clientboundBedrockPackets);
        }
        for (Enum enum_ : (ServerboundPackets1_19_4[])this.unmappedServerboundPacketType.getEnumConstants()) {
            if (this.hasRegisteredServerbound(enum_)) continue;
            this.cancelServerbound(enum_);
        }
    }

    @Override
    public void register(ViaProviders providers) {
        providers.require(NettyPipelineProvider.class);
        providers.register(ResourcePackProvider.class, new DiskResourcePackProvider());
        providers.register(BlobCacheProvider.class, new BlobCacheProvider());
        providers.register(SkinProvider.class, new SkinProvider());
        Via.getPlatform().runRepeatingSync(new ChunkTrackerTickTask(), 5L);
        Via.getPlatform().runRepeatingSync(new EntityTrackerTickTask(), 1L);
        Via.getPlatform().runRepeatingSync(new BlobCacheTickTask(), 1L);
        Via.getPlatform().runRepeatingSync(new KeepAliveTask(), 20L);
    }

    @Override
    public void init(UserConnection user) {
        user.put(new SpawnPositionStorage(user));
        user.put(new BlobCache(user));
        user.put(new PlayerListStorage(user));
        user.put(new PacketSyncStorage(user));
        user.put(new ChannelStorage(user));
        user.put(new ScoreboardTracker(user));
    }

    @Override
    public BedrockMappingData getMappingData() {
        return MAPPINGS;
    }

    @Override
    protected PacketMappings createClientboundPacketMappings() {
        return new ClientboundPacketMappings();
    }

    @Override
    public void transform(Direction direction, State state, PacketWrapper packetWrapper) throws Exception {
        ClientboundBedrockPackets packet;
        if (direction == Direction.CLIENTBOUND && state == State.PLAY && !packetWrapper.user().has(GameSessionStorage.class) && (packet = ClientboundBedrockPackets.getPacket(packetWrapper.getId())) != null && !BEFORE_START_GAME_WHITELIST.contains(packet)) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received packet " + packet + " before START_GAME packet. Ignoring it.");
            throw CancelException.generate();
        }
        super.transform(direction, state, packetWrapper);
    }

    public static void kickForIllegalState(UserConnection user, String reason) {
        BedrockProtocol.kickForIllegalState(user, reason, null);
    }

    public static void kickForIllegalState(UserConnection user, String reason, Throwable e) {
        ViaBedrock.getPlatform().getLogger().log(Level.SEVERE, "Illegal state: " + reason, e);
        try {
            PacketWrapper disconnect = PacketWrapper.create((PacketType)((Object)(user.getProtocolInfo().getState() == State.PLAY ? ClientboundPackets1_19_4.DISCONNECT : ClientboundLoginPackets.LOGIN_DISCONNECT)), user);
            disconnect.write(Type.COMPONENT, JsonUtil.textToComponent("\u00a74ViaBedrock encountered an error:\n\u00a7c" + reason + "\n\n\u00a7rPlease report this issue on the ViaBedrock GitHub page."));
            disconnect.send(BedrockProtocol.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (user.getChannel() != null) {
            user.getChannel().flush();
            user.getChannel().close();
        }
    }
}

