/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.data.MappingDataBase;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrayList;
import com.viaversion.viaversion.libs.fastutil.ints.IntList;
import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.libs.gson.JsonPrimitive;
import com.viaversion.viaversion.libs.opennbt.NBTIO;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.util.GsonUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.BedrockProtocolVersion;
import net.raphimc.viabedrock.api.chunk.block_state.BlockStateUpgrader;
import net.raphimc.viabedrock.api.model.BedrockBlockState;
import net.raphimc.viabedrock.api.model.BlockState;
import net.raphimc.viabedrock.api.model.ResourcePack;
import net.raphimc.viabedrock.api.util.JsonUtil;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class BedrockMappingData
extends MappingDataBase {
    private ResourcePack vanillaResourcePack;
    private CompoundTag registries;
    private CompoundTag tags;
    private BiMap<BlockState, Integer> javaBlockStates;
    private BlockStateUpgrader blockStateUpgrader;
    private List<BedrockBlockState> bedrockBlockStates;
    private Map<BlockState, BlockState> bedrockToJavaBlockStates;
    private IntList preWaterloggedStates;
    private BiMap<String, Integer> legacyBlocks;
    private Int2ObjectMap<BedrockBlockState> legacyBlockStates;
    private BiMap<String, Integer> biomes;
    private Map<String, CompoundTag> biomeDefinitions;
    private Map<String, Map<String, Object>> biomeExtraData;
    private BiMap<String, Integer> items;
    private Map<String, String> entityIdentifiers;
    private BufferedImage steveSkin;
    private JsonObject skinGeometry;

    public BedrockMappingData() {
        super(BedrockProtocolVersion.bedrockLatest.getName(), ProtocolVersion.v1_20.getName());
    }

    @Override
    public void load() {
        Object blockState;
        if (Via.getManager().isDebug()) {
            this.getLogger().info("Loading " + this.unmappedVersion + " -> " + this.mappedVersion + " mappings...");
        }
        this.vanillaResourcePack = this.readResourcePack("bedrock/vanilla.mcpack", UUID.fromString("0575c61f-a5da-4b7f-9961-ffda2908861e"), "0.0.1");
        this.registries = this.readNBT("java/registries.nbt");
        this.tags = this.readNBT("java/tags.nbt");
        JsonArray javaBlockStatesJson = this.readJson("java/mapping-1.20.json").getAsJsonArray("blockstates");
        this.javaBlockStates = HashBiMap.create((int)javaBlockStatesJson.size());
        for (int i = 0; i < javaBlockStatesJson.size(); ++i) {
            blockState = BlockState.fromString(javaBlockStatesJson.get(i).getAsString());
            this.javaBlockStates.put(blockState, (Object)i);
        }
        this.blockStateUpgrader = new BlockStateUpgrader();
        ListTag bedrockBlockStatesTag = (ListTag)this.readNBT("bedrock/block_palette.1_20_0.nbt").get("blocks");
        this.bedrockBlockStates = new ArrayList<BedrockBlockState>(bedrockBlockStatesTag.size());
        blockState = bedrockBlockStatesTag.getValue().iterator();
        while (blockState.hasNext()) {
            Tag tag = (Tag)blockState.next();
            this.bedrockBlockStates.add(BedrockBlockState.fromNbt((CompoundTag)tag));
        }
        JsonObject blockMappings = this.readJson("custom/blockstate_mappings.json");
        this.bedrockToJavaBlockStates = new HashMap<BlockState, BlockState>(blockMappings.size());
        for (Map.Entry entry : blockMappings.entrySet()) {
            BlockState blockState2;
            BlockState bedrockBlockState = BlockState.fromString((String)entry.getKey());
            if (this.bedrockToJavaBlockStates.put(bedrockBlockState, blockState2 = BlockState.fromString(((JsonElement)entry.getValue()).getAsString())) == null) continue;
            throw new RuntimeException("Duplicate bedrock -> java block mapping for " + bedrockBlockState.toBlockStateString());
        }
        JsonArray preWaterloggedStatesJson = this.readJson("custom/pre_waterlogged_states.json").getAsJsonArray("blockstates");
        this.preWaterloggedStates = new IntArrayList(preWaterloggedStatesJson.size());
        for (Object entry : preWaterloggedStatesJson) {
            this.preWaterloggedStates.add((int)((Integer)this.javaBlockStates.get((Object)BlockState.fromString(((JsonElement)entry).getAsString()))));
        }
        JsonObject jsonObject = this.readJson("bedrock/block_legacy_id_map.json");
        this.legacyBlocks = HashBiMap.create((int)jsonObject.size());
        for (Map.Entry entry : jsonObject.entrySet()) {
            String identifier = (String)entry.getKey();
            int n = ((JsonElement)entry.getValue()).getAsInt();
            this.legacyBlocks.put((Object)identifier.toLowerCase(Locale.ROOT), (Object)n);
        }
        this.buildLegacyBlockStateMappings();
        JsonArray biomesJson = this.readJson("bedrock/biomes.json", JsonArray.class);
        this.biomes = HashBiMap.create((int)biomesJson.size());
        for (Object entry : biomesJson) {
            JsonObject jsonObject2 = ((JsonElement)entry).getAsJsonObject();
            String string = jsonObject2.get("name").getAsString();
            int id = jsonObject2.get("id").getAsInt();
            this.biomes.put((Object)string, (Object)id);
        }
        CompoundTag compoundTag = this.readNBT("bedrock/biome_definitions.nbt");
        this.biomeDefinitions = new HashMap<String, CompoundTag>(compoundTag.size());
        for (Map.Entry entry : compoundTag.getValue().entrySet()) {
            this.biomeDefinitions.put((String)entry.getKey(), (CompoundTag)entry.getValue());
        }
        JsonObject biomeExtraDataJson = this.readJson("custom/biome_extra_data.json");
        this.biomeExtraData = new HashMap<String, Map<String, Object>>(biomeExtraDataJson.size());
        for (Map.Entry<String, JsonElement> entry : biomeExtraDataJson.entrySet()) {
            String dataName = entry.getKey();
            JsonObject extraDataJson = entry.getValue().getAsJsonObject();
            HashMap<String, Object> extraData = new HashMap<String, Object>(extraDataJson.size());
            for (Map.Entry<String, JsonElement> extraDataEntry : extraDataJson.entrySet()) {
                JsonPrimitive primitive = extraDataEntry.getValue().getAsJsonPrimitive();
                if (primitive.isString()) {
                    extraData.put(extraDataEntry.getKey(), primitive.getAsString());
                    continue;
                }
                if (primitive.isNumber()) {
                    extraData.put(extraDataEntry.getKey(), primitive.getAsNumber().intValue());
                    continue;
                }
                if (primitive.isBoolean()) {
                    extraData.put(extraDataEntry.getKey(), primitive.getAsBoolean());
                    continue;
                }
                throw new IllegalArgumentException("Unknown extra data type: " + extraDataEntry.getValue().getClass().getName());
            }
            this.biomeExtraData.put(dataName, extraData);
        }
        JsonArray jsonArray = this.readJson("bedrock/runtime_item_states.1_20_0.json", JsonArray.class);
        this.items = HashBiMap.create((int)jsonArray.size());
        for (JsonElement entry : jsonArray) {
            JsonObject itemEntry = entry.getAsJsonObject();
            String identifier = itemEntry.get("name").getAsString();
            int id = itemEntry.get("id").getAsInt();
            this.items.put((Object)identifier, (Object)id);
        }
        JsonObject jsonObject3 = this.readJson("custom/entity_identifiers.json");
        this.entityIdentifiers = new HashMap<String, String>(jsonObject3.size());
        for (Map.Entry<String, JsonElement> entry : jsonObject3.entrySet()) {
            String bedrockIdentifier = entry.getKey();
            String javaIdentifier = entry.getValue().getAsString();
            this.entityIdentifiers.put(bedrockIdentifier, javaIdentifier);
        }
        this.steveSkin = this.readImage("bedrock/skin/steve.png");
        this.skinGeometry = JsonUtil.sort(this.readJson("bedrock/skin/geometry.json"), Comparator.naturalOrder());
    }

    public ResourcePack getVanillaResourcePack() {
        return this.vanillaResourcePack;
    }

    public CompoundTag getRegistries() {
        return this.registries;
    }

    public CompoundTag getTags() {
        return this.tags;
    }

    public BiMap<BlockState, Integer> getJavaBlockStates() {
        return Maps.unmodifiableBiMap(this.javaBlockStates);
    }

    public BlockStateUpgrader getBlockStateUpgrader() {
        return this.blockStateUpgrader;
    }

    public List<BedrockBlockState> getBedrockBlockStates() {
        return Collections.unmodifiableList(this.bedrockBlockStates);
    }

    public Map<BlockState, BlockState> getBedrockToJavaBlockStates() {
        return Collections.unmodifiableMap(this.bedrockToJavaBlockStates);
    }

    public IntList getPreWaterloggedStates() {
        return this.preWaterloggedStates;
    }

    public BiMap<String, Integer> getLegacyBlocks() {
        return Maps.unmodifiableBiMap(this.legacyBlocks);
    }

    public Int2ObjectMap<BedrockBlockState> getLegacyBlockStates() {
        return this.legacyBlockStates;
    }

    public BiMap<String, Integer> getBiomes() {
        return Maps.unmodifiableBiMap(this.biomes);
    }

    public Map<String, CompoundTag> getBiomeDefinitions() {
        return Collections.unmodifiableMap(this.biomeDefinitions);
    }

    public Map<String, Map<String, Object>> getBiomeExtraData() {
        return Collections.unmodifiableMap(this.biomeExtraData);
    }

    public BiMap<String, Integer> getItems() {
        return Maps.unmodifiableBiMap(this.items);
    }

    public Map<String, String> getEntityIdentifiers() {
        return Collections.unmodifiableMap(this.entityIdentifiers);
    }

    public BufferedImage getSteveSkin() {
        return this.steveSkin;
    }

    public JsonObject getSkinGeometry() {
        return this.skinGeometry;
    }

    @Override
    protected Logger getLogger() {
        return ViaBedrock.getPlatform().getLogger();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResourcePack readResourcePack(String file, UUID uuid, String version) {
        file = "assets/viabedrock/data/" + file;
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(file);){
            byte[] bytes = ByteStreams.toByteArray((InputStream)inputStream);
            ResourcePack resourcePack2 = new ResourcePack(uuid, version, "", "", "", false, false, 0L, 6);
            resourcePack2.setCompressedDataLength(bytes.length, bytes.length);
            resourcePack2.processDataChunk(0, bytes);
            ResourcePack resourcePack = resourcePack2;
            return resourcePack;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Could not read " + file, e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> readTextList(String file) {
        file = "assets/viabedrock/data/" + file;
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(file);){
            if (inputStream == null) {
                this.getLogger().severe("Could not open " + file);
                List<String> list2 = Collections.emptyList();
                return list2;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not read " + file, e);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompoundTag readNBT(String file) {
        file = "assets/viabedrock/data/" + file;
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(file);){
            if (inputStream == null) {
                this.getLogger().severe("Could not open " + file);
                CompoundTag compoundTag2 = null;
                return compoundTag2;
            }
            CompoundTag compoundTag = NBTIO.readTag(new GZIPInputStream(inputStream));
            return compoundTag;
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not read " + file, e);
            return null;
        }
    }

    private JsonObject readJson(String file) {
        return this.readJson(file, JsonObject.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T readJson(String file, Class<T> classOfT) {
        file = "assets/viabedrock/data/" + file;
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(file);){
            if (inputStream == null) {
                this.getLogger().severe("Could not open " + file);
                T t = null;
                return t;
            }
            T t = GsonUtil.getGson().fromJson((Reader)new InputStreamReader(inputStream), classOfT);
            return t;
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not read " + file, e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage readImage(String file) {
        file = "assets/viabedrock/data/" + file;
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(file);){
            if (inputStream == null) {
                this.getLogger().severe("Could not open " + file);
                BufferedImage bufferedImage2 = null;
                return bufferedImage2;
            }
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not read " + file, e);
            return null;
        }
    }

    private void buildLegacyBlockStateMappings() {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("assets/viabedrock/data/bedrock/r12_to_current_block_map.bin");){
            if (inputStream == null) {
                this.getLogger().severe("Could not open r12_to_current_block_map.bin");
                return;
            }
            byte[] bytes = ByteStreams.toByteArray((InputStream)inputStream);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
            this.legacyBlockStates = new Int2ObjectOpenHashMap<BedrockBlockState>();
            while (buf.isReadable()) {
                String identifier = ((String)BedrockTypes.STRING.read(buf)).toLowerCase(Locale.ROOT);
                short metadata = buf.readShortLE();
                CompoundTag current = (CompoundTag)BedrockTypes.NETWORK_TAG.read(buf);
                if (!this.legacyBlocks.containsKey((Object)identifier)) {
                    this.getLogger().warning("Unknown block identifier in r12_to_current_block_map.bin: " + identifier);
                    continue;
                }
                int id = (Integer)this.legacyBlocks.get((Object)identifier);
                this.legacyBlockStates.put(id << 6 | metadata & 0x3F, BedrockBlockState.fromNbt(current));
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Could not read r12_to_current_block_map.bin", e);
            this.legacyBlockStates = null;
        }
    }
}

