/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.data;

import com.viaversion.viaversion.libs.opennbt.tag.builtin.ByteTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.FloatTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.util.MathUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;

public class BiomeRegistry {
    public static ListTag buildJavaBiomeRegistry(Map<String, CompoundTag> biomeDefinitions) {
        ListTag javaBiomes = new ListTag();
        javaBiomes.add(BiomeRegistry.getTheVoidBiome());
        Map<String, Object> fogColor = BedrockProtocol.MAPPINGS.getBiomeExtraData().get("fog_color");
        Map<String, Object> waterFogColor = BedrockProtocol.MAPPINGS.getBiomeExtraData().get("water_fog_color");
        Map<String, Object> foliageColor = BedrockProtocol.MAPPINGS.getBiomeExtraData().get("foliage_color");
        Map<String, Object> grassColor = BedrockProtocol.MAPPINGS.getBiomeExtraData().get("grass_color");
        Map<String, Object> grassColorModifier = BedrockProtocol.MAPPINGS.getBiomeExtraData().get("grass_color_modifier");
        Map<String, Object> moodSound = BedrockProtocol.MAPPINGS.getBiomeExtraData().get("mood_sound");
        for (Map.Entry<String, CompoundTag> entry : biomeDefinitions.entrySet()) {
            String bedrockIdentifier = entry.getKey();
            String javaIdentifier = "minecraft:" + bedrockIdentifier;
            CompoundTag bedrockBiome = entry.getValue();
            CompoundTag javaBiome = new CompoundTag();
            int bedrockId = (Integer)BedrockProtocol.MAPPINGS.getBiomes().getOrDefault((Object)bedrockIdentifier, (Object)-1);
            int javaId = bedrockId + 1;
            if (bedrockId == -1) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing biome mapping for " + bedrockIdentifier);
                continue;
            }
            javaBiome.put("name", new StringTag(javaIdentifier));
            javaBiome.put("id", new IntTag(javaId));
            CompoundTag element = new CompoundTag();
            javaBiome.put("element", element);
            element.put("temperature", bedrockBiome.get("temperature"));
            element.put("downfall", bedrockBiome.get("downfall"));
            element.put("has_precipitation", bedrockBiome.get("rain"));
            List tags = ((ListTag)bedrockBiome.get("tags")).getValue().stream().map(StringTag.class::cast).map(StringTag::getValue).collect(Collectors.toList());
            CompoundTag effects = new CompoundTag();
            element.put("effects", effects);
            float blue_spores = ((FloatTag)bedrockBiome.get("blue_spores")).asFloat();
            float white_ash = ((FloatTag)bedrockBiome.get("white_ash")).asFloat();
            float red_spores = ((FloatTag)bedrockBiome.get("red_spores")).asFloat();
            float ash = ((FloatTag)bedrockBiome.get("ash")).asFloat();
            if (blue_spores > 0.0f) {
                effects.put("particle", BiomeRegistry.createParticle("minecraft:warped_spore", blue_spores / 10.0f));
            } else if (white_ash > 0.0f) {
                effects.put("particle", BiomeRegistry.createParticle("minecraft:white_ash", white_ash / 10.0f));
            } else if (red_spores > 0.0f) {
                effects.put("particle", BiomeRegistry.createParticle("minecraft:crimson_spore", red_spores / 10.0f));
            } else if (ash > 0.0f) {
                effects.put("particle", BiomeRegistry.createParticle("minecraft:ash", ash / 10.0f));
            }
            int waterColorR = (int)(((FloatTag)bedrockBiome.get("waterColorR")).asFloat() * 255.0f);
            int waterColorG = (int)(((FloatTag)bedrockBiome.get("waterColorG")).asFloat() * 255.0f);
            int waterColorB = (int)(((FloatTag)bedrockBiome.get("waterColorB")).asFloat() * 255.0f);
            int waterColorA = (int)(((FloatTag)bedrockBiome.get("waterColorA")).asFloat() * 255.0f);
            int waterTransparency = (int)(((FloatTag)bedrockBiome.get("waterTransparency")).asFloat() * 255.0f);
            int waterColor = (waterColorR << 16) + (waterColorG << 8) + waterColorB;
            effects.put("water_color", new IntTag(waterColor));
            for (String tag : tags) {
                if (fogColor.containsKey(tag)) {
                    effects.put("fog_color", new IntTag((Integer)fogColor.get(tag)));
                }
                if (foliageColor.containsKey(tag)) {
                    effects.put("foliage_color", new IntTag((Integer)foliageColor.get(tag)));
                }
                if (grassColor.containsKey(tag)) {
                    effects.put("grass_color", new IntTag((Integer)grassColor.get(tag)));
                }
                if (grassColorModifier.containsKey(tag)) {
                    effects.put("grass_color_modifier", new StringTag((String)grassColorModifier.get(tag)));
                }
                if (!moodSound.containsKey(tag)) continue;
                effects.put("mood_sound", BiomeRegistry.createMoodSound((String)moodSound.get(tag)));
            }
            if (waterFogColor.containsKey(bedrockIdentifier)) {
                effects.put("water_fog_color", new IntTag((Integer)waterFogColor.get(bedrockIdentifier)));
            }
            if (!effects.contains("fog_color")) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing fog color for " + bedrockIdentifier + ": " + bedrockBiome);
            } else if (!effects.contains("water_fog_color")) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing water fog color for " + bedrockIdentifier + ": " + bedrockBiome);
            } else if (!effects.contains("mood_sound")) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing mood sound for " + bedrockIdentifier + ": " + bedrockBiome);
            }
            if (tags.contains("the_end")) {
                effects.put("sky_color", new IntTag(0));
            } else {
                effects.put("sky_color", new IntTag(BiomeRegistry.getSkyColor(((FloatTag)bedrockBiome.get("temperature")).asFloat())));
            }
            javaBiomes.add(javaBiome);
        }
        return javaBiomes;
    }

    private static CompoundTag getTheVoidBiome() {
        CompoundTag biome = new CompoundTag();
        biome.put("name", new StringTag("minecraft:the_void"));
        biome.put("id", new IntTag(0));
        CompoundTag element = new CompoundTag();
        biome.put("element", element);
        element.put("temperature", new FloatTag(0.5f));
        element.put("downfall", new FloatTag(0.5f));
        element.put("has_precipitation", new ByteTag(0));
        CompoundTag effects = new CompoundTag();
        element.put("effects", effects);
        effects.put("sky_color", new IntTag(8103167));
        effects.put("water_fog_color", new IntTag(329011));
        effects.put("fog_color", new IntTag(12638463));
        effects.put("water_color", new IntTag(4159204));
        effects.put("mood_sound", BiomeRegistry.createMoodSound("minecraft:ambient.cave"));
        return biome;
    }

    private static CompoundTag createParticle(String name, float probability) {
        CompoundTag particle = new CompoundTag();
        particle.put("probability", new FloatTag(probability));
        CompoundTag options = new CompoundTag();
        particle.put("options", options);
        options.put("type", new StringTag(name));
        return particle;
    }

    private static CompoundTag createMoodSound(String soundId) {
        CompoundTag moodSound = new CompoundTag();
        moodSound.put("tick_delay", new IntTag(6000));
        moodSound.put("offset", new FloatTag(2.0f));
        moodSound.put("sound", new StringTag(soundId));
        moodSound.put("block_search_extent", new IntTag(8));
        return moodSound;
    }

    private static int getSkyColor(float temperature) {
        float f = temperature / 3.0f;
        f = MathUtil.clamp(f, -1.0f, 1.0f);
        return Color.HSBtoRGB(0.62222224f - f * 0.05f, 0.5f + f * 0.1f, 1.0f) & 0xFFFFFF;
    }
}

