/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.model;

import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import java.util.Arrays;
import java.util.Objects;

public class BedrockItem
implements Item {
    private int id;
    private short data;
    private byte amount;
    private CompoundTag tag;
    private String[] canPlace;
    private String[] canBreak;
    private long blockingTicks;
    private int blockRuntimeId;
    private boolean usingNetId;
    private int netId;

    public BedrockItem(int id) {
        this(id, 0, 1);
    }

    public BedrockItem(int id, short data, byte amount) {
        this(id, data, amount, null);
    }

    public BedrockItem(int id, short data, byte amount, CompoundTag tag) {
        this(id, data, amount, tag, new String[0], new String[0], 0L, 0, false, 0);
    }

    public BedrockItem(int id, short data, byte amount, CompoundTag tag, String[] canPlace, String[] canBreak, long blockingTicks, int blockRuntimeId, boolean usingNetId, int netId) {
        this.id = id;
        this.data = data;
        this.amount = amount;
        this.tag = tag;
        this.canPlace = canPlace;
        this.canBreak = canBreak;
        this.blockingTicks = blockingTicks;
        this.blockRuntimeId = blockRuntimeId;
        this.usingNetId = usingNetId;
        this.netId = netId;
    }

    @Override
    public int identifier() {
        return this.id;
    }

    @Override
    public void setIdentifier(int identifier) {
        this.id = identifier % 65536;
    }

    @Override
    public short data() {
        return this.data;
    }

    @Override
    public void setData(short data) {
        this.data = data < 0 ? (short)0 : data;
    }

    public void setData(int data) {
        this.setData((short)(data % 65536));
    }

    @Override
    public int amount() {
        return this.amount & 0xFF;
    }

    @Override
    public void setAmount(int amount) {
        this.amount = amount < 0 || amount > 255 ? (byte)0 : (byte)amount;
    }

    @Override
    public CompoundTag tag() {
        return this.tag;
    }

    @Override
    public void setTag(CompoundTag tag) {
        this.tag = tag;
    }

    public String[] canPlace() {
        return this.canPlace;
    }

    public void setCanPlace(String[] canPlace) {
        this.canPlace = canPlace;
    }

    public String[] canBreak() {
        return this.canBreak;
    }

    public void setCanBreak(String[] canBreak) {
        this.canBreak = canBreak;
    }

    public long blockingTicks() {
        return this.blockingTicks;
    }

    public void setBlockingTicks(long blockingTicks) {
        this.blockingTicks = blockingTicks;
    }

    public int blockRuntimeId() {
        return this.blockRuntimeId;
    }

    public void setBlockRuntimeId(int blockRuntimeId) {
        this.blockRuntimeId = blockRuntimeId;
    }

    public boolean usingNetId() {
        return this.usingNetId;
    }

    public void setUsingNetId(boolean usingNetId) {
        this.usingNetId = usingNetId;
    }

    public int netId() {
        return this.netId;
    }

    public void setNetId(int netId) {
        this.netId = netId;
    }

    @Override
    public BedrockItem copy() {
        return new BedrockItem(this.id, this.data, this.amount, this.tag != null ? this.tag.clone() : null, (String[])this.canPlace.clone(), (String[])this.canBreak.clone(), this.blockingTicks, this.blockRuntimeId, this.usingNetId, this.netId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BedrockItem that = (BedrockItem)o;
        return this.id == that.id && this.data == that.data && this.amount == that.amount && this.blockingTicks == that.blockingTicks && this.blockRuntimeId == that.blockRuntimeId && this.usingNetId == that.usingNetId && this.netId == that.netId && Objects.equals(this.tag, that.tag) && Arrays.equals(this.canPlace, that.canPlace) && Arrays.equals(this.canBreak, that.canBreak);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.data, this.amount, this.tag, this.blockingTicks, this.blockRuntimeId, this.usingNetId, this.netId);
        result = 31 * result + Arrays.hashCode(this.canPlace);
        result = 31 * result + Arrays.hashCode(this.canBreak);
        return result;
    }

    public String toString() {
        return "BedrockItem{id=" + this.id + ", data=" + this.data + ", amount=" + this.amount + ", tag=" + this.tag + ", canPlace=" + Arrays.toString(this.canPlace) + ", canBreak=" + Arrays.toString(this.canBreak) + ", blockingTicks=" + this.blockingTicks + ", blockRuntimeId=" + this.blockRuntimeId + ", usingNetId=" + this.usingNetId + ", netId=" + this.netId + '}';
    }
}

