/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CommandData {
    public static final int FLAG_TEST_USAGE = 1;
    public static final int FLAG_HIDDEN_FROM_COMMAND_BLOCK = 2;
    public static final int FLAG_HIDDEN_FROM_PLAYER = 4;
    public static final int FLAG_HIDDEN_FROM_AUTOMATION = 8;
    public static final int FLAG_LOCAL_SYNC = 16;
    public static final int FLAG_EXECUTE_DISALLOWED = 32;
    public static final int FLAG_MESSAGE_TYPE = 64;
    public static final int FLAG_NOT_CHEAT = 128;
    public static final int FLAG_ASYNC = 256;
    private final String name;
    private final String description;
    private final int flags;
    private final short permission;
    private final EnumData alias;
    private final ParamData[][] parameters;

    public CommandData(String name, String description, int flags, short permission, EnumData alias, ParamData[][] parameters) {
        this.name = name;
        this.description = description;
        this.flags = flags;
        this.permission = permission;
        this.alias = alias;
        this.parameters = parameters;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public int flags() {
        return this.flags;
    }

    public short permission() {
        return this.permission;
    }

    public EnumData alias() {
        return this.alias;
    }

    public ParamData[][] parameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandData that = (CommandData)o;
        return this.flags == that.flags && this.permission == that.permission && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.alias, that.alias) && Arrays.deepEquals((Object[])this.parameters, (Object[])that.parameters);
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.description, this.flags, this.permission, this.alias);
        result = 31 * result + Arrays.deepHashCode((Object[])this.parameters);
        return result;
    }

    public String toString() {
        return "CommandData{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", flags=" + this.flags + ", permission=" + this.permission + ", alias=" + this.alias + ", parameters=" + Arrays.toString((Object[])this.parameters) + '}';
    }

    public static class ParamData {
        public static final int TYPE_INT = 1;
        public static final int TYPE_FLOAT1 = 2;
        public static final int TYPE_FLOAT2 = 3;
        public static final int TYPE_VALUE = 4;
        public static final int TYPE_WILDCARD_INT = 5;
        public static final int TYPE_OPERATOR = 6;
        public static final int TYPE_COMPARE_OPERATOR = 7;
        public static final int TYPE_TARGET1 = 8;
        public static final int TYPE_TARGET2 = 10;
        public static final int TYPE_FILE_PATH = 17;
        public static final int TYPE_INT_RANGE = 23;
        public static final int TYPE_EQUIPMENT_SLOT = 43;
        public static final int TYPE_STRING = 44;
        public static final int TYPE_BLOCK_POSITION = 52;
        public static final int TYPE_POSITION = 53;
        public static final int TYPE_MESSAGE = 56;
        public static final int TYPE_TEXT = 58;
        public static final int TYPE_JSON = 62;
        public static final int TYPE_BLOCK_STATES = 72;
        public static final int TYPE_COMMAND = 75;
        public static final short FLAG_SUPPRESS_ENUM_AUTOCOMPLETION = 1;
        public static final short FLAG_HAS_SEMANTIC_CONSTRAINT = 2;
        public static final short FLAG_ENUM_AS_CHAINED_COMMAND = 4;
        private final String name;
        private final boolean optional;
        private final short flags;
        private final Integer type;
        private final EnumData enumData;
        private final String postfix;

        public ParamData(String name, boolean optional, short flags, Integer type, EnumData enumData, String postfix) {
            this.name = name;
            this.optional = optional;
            this.flags = flags;
            this.type = type;
            this.enumData = enumData;
            this.postfix = postfix;
        }

        public String name() {
            return this.name;
        }

        public boolean optional() {
            return this.optional;
        }

        public short flags() {
            return this.flags;
        }

        public Integer type() {
            return this.type;
        }

        public EnumData enumData() {
            return this.enumData;
        }

        public String postfix() {
            return this.postfix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParamData paramData = (ParamData)o;
            return this.optional == paramData.optional && this.flags == paramData.flags && Objects.equals(this.name, paramData.name) && Objects.equals(this.type, paramData.type) && Objects.equals(this.enumData, paramData.enumData) && Objects.equals(this.postfix, paramData.postfix);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.optional, this.flags, this.type, this.enumData, this.postfix);
        }

        public String toString() {
            return "ParamData{name='" + this.name + '\'' + ", optional=" + this.optional + ", flags=" + this.flags + ", type=" + this.type + ", enumData=" + this.enumData + ", postfix='" + this.postfix + '\'' + '}';
        }
    }

    public static class EnumData {
        public static final short FLAG_CHEATS_ENABLED = 0;
        public static final short FLAG_OPERATOR_PERMISSIONS = 1;
        public static final short FLAG_HOST_PERMISSIONS = 2;
        public static final short FLAG_ALLOW_ALIASES = 3;
        private final String name;
        private final Map<String, Set<Short>> values;
        private final boolean dynamic;

        public EnumData(String name, Set<String> values, boolean dynamic) {
            this.name = name;
            this.values = new HashMap<String, Set<Short>>();
            for (String value : values) {
                this.values.put(value, new HashSet());
            }
            this.dynamic = dynamic;
        }

        public String name() {
            return this.name;
        }

        public Map<String, Set<Short>> values() {
            return this.values;
        }

        public void addValues(Set<String> values) {
            for (String value : values) {
                this.values.put(value, new HashSet());
            }
        }

        public boolean dynamic() {
            return this.dynamic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnumData enumData = (EnumData)o;
            return this.dynamic == enumData.dynamic && Objects.equals(this.name, enumData.name) && Objects.equals(this.values, enumData.values);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.values, this.dynamic);
        }

        public String toString() {
            return "EnumData{name='" + this.name + '\'' + ", values=" + this.values + ", dynamic=" + this.dynamic + '}';
        }
    }
}

