/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.model;

import java.util.Objects;
import java.util.UUID;

public class CommandOrigin {
    public static final int TYPE_PLAYER = 0;
    public static final int TYPE_BLOCK = 1;
    public static final int TYPE_MINECART_BLOCK = 2;
    public static final int TYPE_DEV_CONSOLE = 3;
    public static final int TYPE_TEST = 4;
    public static final int TYPE_AUTOMATION_PLAYER = 5;
    public static final int TYPE_CLIENT_AUTOMATION = 6;
    public static final int TYPE_DEDICATED_SERVER = 7;
    public static final int TYPE_ENTITY = 8;
    public static final int TYPE_VIRTUAL = 9;
    public static final int TYPE_GAME_ARGUMENT = 10;
    public static final int TYPE_ENTITY_SERVER = 11;
    public static final int TYPE_PRECOMPILED = 12;
    public static final int TYPE_GAME_DIRECTOR_ENTITY_SERVER = 13;
    public static final int TYPE_SCRIPT = 14;
    public static final int TYPE_EXECUTE_CONTEXT = 15;
    private final int type;
    private final UUID uuid;
    private final String requestId;
    private final long event;

    public CommandOrigin(int type, UUID uuid, String requestId) {
        this(type, uuid, requestId, -1L);
    }

    public CommandOrigin(int type, UUID uuid, String requestId, long event) {
        this.type = type;
        this.uuid = uuid;
        this.requestId = requestId;
        this.event = event;
    }

    public CommandOrigin(CommandOrigin type) {
        this.type = type.type;
        this.uuid = type.uuid;
        this.requestId = type.requestId;
        this.event = type.event;
    }

    public int type() {
        return this.type;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public String requestId() {
        return this.requestId;
    }

    public long event() {
        return this.event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandOrigin that = (CommandOrigin)o;
        return this.type == that.type && this.event == that.event && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.requestId, that.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.uuid, this.requestId, this.event);
    }

    public String toString() {
        return "CommandOrigin{type=" + this.type + ", uuid=" + this.uuid + ", requestId='" + this.requestId + '\'' + ", event=" + this.event + '}';
    }
}

