/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.model;

import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import java.util.Objects;

public class PlayerAbilities {
    private final long uniqueEntityId;
    private final int playerPermission;
    private final int commandPermission;
    private final Int2ObjectMap<Abilities> abilityLayers;

    public PlayerAbilities(long uniqueEntityId, int playerPermission, int commandPermission, Int2ObjectMap<Abilities> abilityLayers) {
        this.uniqueEntityId = uniqueEntityId;
        this.playerPermission = playerPermission;
        this.commandPermission = commandPermission;
        this.abilityLayers = abilityLayers;
    }

    public long uniqueEntityId() {
        return this.uniqueEntityId;
    }

    public int playerPermission() {
        return this.playerPermission;
    }

    public int commandPermission() {
        return this.commandPermission;
    }

    public Int2ObjectMap<Abilities> abilityLayers() {
        return this.abilityLayers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerAbilities that = (PlayerAbilities)o;
        return this.uniqueEntityId == that.uniqueEntityId && this.playerPermission == that.playerPermission && this.commandPermission == that.commandPermission && Objects.equals(this.abilityLayers, that.abilityLayers);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueEntityId, this.playerPermission, this.commandPermission, this.abilityLayers);
    }

    public String toString() {
        return "PlayerAbilities{uniqueEntityId=" + this.uniqueEntityId + ", playerPermission=" + this.playerPermission + ", commandPermission=" + this.commandPermission + ", abilityLayers=" + this.abilityLayers + '}';
    }

    public static class Abilities {
        private final int abilitiesSet;
        private final int abilityValues;
        private final float walkSpeed;
        private final float flySpeed;

        public Abilities(int abilitiesSet, int abilityValues, float walkSpeed, float flySpeed) {
            this.abilitiesSet = abilitiesSet;
            this.abilityValues = abilityValues;
            this.walkSpeed = walkSpeed;
            this.flySpeed = flySpeed;
        }

        public int abilitiesSet() {
            return this.abilitiesSet;
        }

        public int abilityValues() {
            return this.abilityValues;
        }

        public float walkSpeed() {
            return this.walkSpeed;
        }

        public float flySpeed() {
            return this.flySpeed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Abilities abilities = (Abilities)o;
            return this.abilitiesSet == abilities.abilitiesSet && this.abilityValues == abilities.abilityValues && Float.compare(abilities.walkSpeed, this.walkSpeed) == 0 && Float.compare(abilities.flySpeed, this.flySpeed) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.abilitiesSet, this.abilityValues, Float.valueOf(this.walkSpeed), Float.valueOf(this.flySpeed));
        }

        public String toString() {
            return "Abilities{abilitiesSet=" + this.abilitiesSet + ", abilityValues=" + this.abilityValues + ", walkSpeed=" + this.walkSpeed + ", flySpeed=" + this.flySpeed + '}';
        }
    }
}

