/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.model;

import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Objects;

public class SkinData {
    private final String skinId;
    private final String playFabId;
    private final String skinResourcePatch;
    private final BufferedImage skinData;
    private final List<AnimationData> animations;
    private final BufferedImage capeData;
    private final String geometryData;
    private final String geometryDataEngineVersion;
    private final String animationData;
    private final boolean premium;
    private final boolean persona;
    private final boolean capeOnClassic;
    private final boolean primaryUser;
    private final String capeId;
    private final String fullSkinId;
    private final String armSize;
    private final String skinColor;
    private final List<PersonaPieceData> personaPieces;
    private final List<PersonaPieceTintData> tintColors;
    private final boolean overridingPlayerAppearance;

    public SkinData(String skinId, String playFabId, String skinResourcePatch, BufferedImage skinData, List<AnimationData> animations, BufferedImage capeData, String geometryData, String geometryDataEngineVersion, String animationData, boolean premium, boolean persona, boolean capeOnClassic, boolean primaryUser, String capeId, String fullSkinId, String armSize, String skinColor, List<PersonaPieceData> personaPieces, List<PersonaPieceTintData> tintColors, boolean overridingPlayerAppearance) {
        this.skinId = skinId;
        this.playFabId = playFabId;
        this.skinResourcePatch = skinResourcePatch;
        this.skinData = skinData;
        this.animations = animations;
        this.capeData = capeData;
        this.geometryData = geometryData;
        this.geometryDataEngineVersion = geometryDataEngineVersion;
        this.animationData = animationData;
        this.premium = premium;
        this.persona = persona;
        this.capeOnClassic = capeOnClassic;
        this.primaryUser = primaryUser;
        this.capeId = capeId;
        this.fullSkinId = fullSkinId;
        this.armSize = armSize;
        this.skinColor = skinColor;
        this.personaPieces = personaPieces;
        this.tintColors = tintColors;
        this.overridingPlayerAppearance = overridingPlayerAppearance;
    }

    public String skinId() {
        return this.skinId;
    }

    public String playFabId() {
        return this.playFabId;
    }

    public String skinResourcePatch() {
        return this.skinResourcePatch;
    }

    public BufferedImage skinData() {
        return this.skinData;
    }

    public List<AnimationData> animations() {
        return this.animations;
    }

    public BufferedImage capeData() {
        return this.capeData;
    }

    public String geometryData() {
        return this.geometryData;
    }

    public String geometryDataEngineVersion() {
        return this.geometryDataEngineVersion;
    }

    public String animationData() {
        return this.animationData;
    }

    public boolean premium() {
        return this.premium;
    }

    public boolean persona() {
        return this.persona;
    }

    public boolean capeOnClassic() {
        return this.capeOnClassic;
    }

    public boolean primaryUser() {
        return this.primaryUser;
    }

    public String capeId() {
        return this.capeId;
    }

    public String fullSkinId() {
        return this.fullSkinId;
    }

    public String armSize() {
        return this.armSize;
    }

    public String skinColor() {
        return this.skinColor;
    }

    public List<PersonaPieceData> personaPieces() {
        return this.personaPieces;
    }

    public List<PersonaPieceTintData> tintColors() {
        return this.tintColors;
    }

    public boolean overridingPlayerAppearance() {
        return this.overridingPlayerAppearance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkinData skinData1 = (SkinData)o;
        return this.premium == skinData1.premium && this.persona == skinData1.persona && this.capeOnClassic == skinData1.capeOnClassic && this.primaryUser == skinData1.primaryUser && this.overridingPlayerAppearance == skinData1.overridingPlayerAppearance && Objects.equals(this.skinId, skinData1.skinId) && Objects.equals(this.playFabId, skinData1.playFabId) && Objects.equals(this.skinResourcePatch, skinData1.skinResourcePatch) && Objects.equals(this.skinData, skinData1.skinData) && Objects.equals(this.animations, skinData1.animations) && Objects.equals(this.capeData, skinData1.capeData) && Objects.equals(this.geometryData, skinData1.geometryData) && Objects.equals(this.geometryDataEngineVersion, skinData1.geometryDataEngineVersion) && Objects.equals(this.animationData, skinData1.animationData) && Objects.equals(this.capeId, skinData1.capeId) && Objects.equals(this.fullSkinId, skinData1.fullSkinId) && Objects.equals(this.armSize, skinData1.armSize) && Objects.equals(this.skinColor, skinData1.skinColor) && Objects.equals(this.personaPieces, skinData1.personaPieces) && Objects.equals(this.tintColors, skinData1.tintColors);
    }

    public int hashCode() {
        return Objects.hash(this.skinId, this.playFabId, this.skinResourcePatch, this.skinData, this.animations, this.capeData, this.geometryData, this.geometryDataEngineVersion, this.animationData, this.premium, this.persona, this.capeOnClassic, this.primaryUser, this.capeId, this.fullSkinId, this.armSize, this.skinColor, this.personaPieces, this.tintColors, this.overridingPlayerAppearance);
    }

    public String toString() {
        return "SkinData{skinId='" + this.skinId + '\'' + ", playFabId='" + this.playFabId + '\'' + ", skinResourcePatch='" + this.skinResourcePatch + '\'' + ", skinData=" + this.skinData + ", animations=" + this.animations + ", capeData=" + this.capeData + ", geometryData='" + this.geometryData + '\'' + ", geometryDataEngineVersion='" + this.geometryDataEngineVersion + '\'' + ", animationData='" + this.animationData + '\'' + ", premium=" + this.premium + ", persona=" + this.persona + ", capeOnClassic=" + this.capeOnClassic + ", primaryUser=" + this.primaryUser + ", capeId='" + this.capeId + '\'' + ", fullSkinId='" + this.fullSkinId + '\'' + ", armSize='" + this.armSize + '\'' + ", skinColor='" + this.skinColor + '\'' + ", personaPieces=" + this.personaPieces + ", tintColors=" + this.tintColors + ", overridingPlayerAppearance=" + this.overridingPlayerAppearance + '}';
    }

    public static class PersonaPieceTintData {
        private final String type;
        private final List<String> colors;

        public PersonaPieceTintData(String type, List<String> colors) {
            this.type = type;
            this.colors = colors;
        }

        public String type() {
            return this.type;
        }

        public List<String> colors() {
            return this.colors;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersonaPieceTintData that = (PersonaPieceTintData)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.colors, that.colors);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.colors);
        }

        public String toString() {
            return "PersonaPieceTintData{type='" + this.type + '\'' + ", colors=" + this.colors + '}';
        }
    }

    public static class PersonaPieceData {
        private final String id;
        private final String type;
        private final String packId;
        private final boolean defaultPiece;
        private final String productId;

        public PersonaPieceData(String id, String type, String packId, boolean defaultPiece, String productId) {
            this.id = id;
            this.type = type;
            this.packId = packId;
            this.defaultPiece = defaultPiece;
            this.productId = productId;
        }

        public String id() {
            return this.id;
        }

        public String type() {
            return this.type;
        }

        public String packId() {
            return this.packId;
        }

        public boolean isDefault() {
            return this.defaultPiece;
        }

        public String productId() {
            return this.productId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersonaPieceData that = (PersonaPieceData)o;
            return this.defaultPiece == that.defaultPiece && Objects.equals(this.id, that.id) && Objects.equals(this.type, that.type) && Objects.equals(this.packId, that.packId) && Objects.equals(this.productId, that.productId);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.type, this.packId, this.defaultPiece, this.productId);
        }

        public String toString() {
            return "PersonaPieceData{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", packId='" + this.packId + '\'' + ", defaultPiece=" + this.defaultPiece + ", productId='" + this.productId + '\'' + '}';
        }
    }

    public static class AnimationData {
        private final BufferedImage image;
        private final int type;
        private final float frames;
        private final int expression;

        public AnimationData(BufferedImage image, int type, float frames, int expression) {
            this.image = image;
            this.type = type;
            this.frames = frames;
            this.expression = expression;
        }

        public BufferedImage image() {
            return this.image;
        }

        public int type() {
            return this.type;
        }

        public float frames() {
            return this.frames;
        }

        public int expression() {
            return this.expression;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnimationData that = (AnimationData)o;
            return this.type == that.type && Float.compare(that.frames, this.frames) == 0 && this.expression == that.expression && Objects.equals(this.image, that.image);
        }

        public int hashCode() {
            return Objects.hash(this.image, this.type, Float.valueOf(this.frames), this.expression);
        }

        public String toString() {
            return "AnimationData{image=" + this.image + ", type=" + this.type + ", frames=" + this.frames + ", expression=" + this.expression + '}';
        }
    }
}

