/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packets;

import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.fastutil.ints.IntIntPair;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ServerboundPackets1_19_4;
import com.viaversion.viaversion.util.Pair;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import net.lenni0451.mcstructs_bedrock.text.components.RootBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.components.TranslationBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.serializer.BedrockComponentSerializer;
import net.lenni0451.mcstructs_bedrock.text.utils.BedrockTranslator;
import net.lenni0451.mcstructs_bedrock.text.utils.TranslatorOptions;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.util.JsonUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.model.CommandData;
import net.raphimc.viabedrock.protocol.model.CommandOrigin;
import net.raphimc.viabedrock.protocol.storage.AuthChainData;
import net.raphimc.viabedrock.protocol.storage.CommandsStorage;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class ChatPackets {
    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.TEXT, ClientboundPackets1_19_4.SYSTEM_CHAT, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    short type = wrapper.read(Type.UNSIGNED_BYTE);
                    boolean needsTranslation = wrapper.read(Type.BOOLEAN);
                    Function<String, String> translator = k -> wrapper.user().get(ResourcePacksStorage.class).getTranslations().getOrDefault(k, (String)k);
                    String originalMessage = null;
                    try {
                        switch (type) {
                            case 1: 
                            case 7: 
                            case 8: {
                                String sourceName = wrapper.read(BedrockTypes.STRING);
                                String message = originalMessage = wrapper.read(BedrockTypes.STRING);
                                if (needsTranslation) {
                                    message = BedrockTranslator.translate(message, translator, new Object[0], new TranslatorOptions[0]);
                                }
                                if (type == 1 && !sourceName.isEmpty()) {
                                    message = BedrockTranslator.translate("chat.type.text", translator, new String[]{sourceName, message}, TranslatorOptions.SKIP_ARGS_TRANSLATION);
                                } else if (type == 7) {
                                    message = BedrockTranslator.translate("chat.type.text", translator, new String[]{sourceName, BedrockTranslator.translate("\u00a77\u00a7o%commands.message.display.incoming", translator, new String[]{sourceName, message}, new TranslatorOptions[0])}, TranslatorOptions.SKIP_ARGS_TRANSLATION);
                                }
                                wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(message));
                                wrapper.write(Type.BOOLEAN, false);
                                break;
                            }
                            case 9: 
                            case 10: 
                            case 11: {
                                String message = originalMessage = wrapper.read(BedrockTypes.STRING);
                                RootBedrockComponent rootComponent = BedrockComponentSerializer.deserialize(message);
                                rootComponent.forEach(c -> {
                                    if (c instanceof TranslationBedrockComponent) {
                                        ((TranslationBedrockComponent)c).setTranslator(translator);
                                    }
                                });
                                message = rootComponent.asString();
                                if (needsTranslation) {
                                    message = BedrockTranslator.translate(message, translator, new Object[0], new TranslatorOptions[0]);
                                }
                                wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(message));
                                wrapper.write(Type.BOOLEAN, false);
                                break;
                            }
                            case 0: 
                            case 5: 
                            case 6: {
                                String message = originalMessage = wrapper.read(BedrockTypes.STRING);
                                if (needsTranslation) {
                                    message = BedrockTranslator.translate(message, translator, new Object[0], new TranslatorOptions[0]);
                                }
                                wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(message));
                                wrapper.write(Type.BOOLEAN, type == 5);
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 4: {
                                String message = originalMessage = wrapper.read(BedrockTypes.STRING);
                                Object[] parameters = wrapper.read(BedrockTypes.STRING_ARRAY);
                                if (needsTranslation) {
                                    message = BedrockTranslator.translate(message, translator, parameters, new TranslatorOptions[0]);
                                }
                                wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(message));
                                wrapper.write(Type.BOOLEAN, type == 3 || type == 4);
                                break;
                            }
                            default: {
                                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown text type: " + type);
                                wrapper.cancel();
                                break;
                            }
                        }
                    }
                    catch (Throwable e) {
                        ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Error while translating '" + originalMessage + "' (" + type + ")", e);
                        wrapper.cancel();
                    }
                });
                this.read(BedrockTypes.STRING);
                this.read(BedrockTypes.STRING);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.COMMAND_OUTPUT, ClientboundPackets1_19_4.SYSTEM_CHAT, wrapper -> {
            CommandOrigin originData = wrapper.read(BedrockTypes.COMMAND_ORIGIN);
            short type = wrapper.read(Type.UNSIGNED_BYTE);
            wrapper.read(BedrockTypes.UNSIGNED_VAR_INT);
            if (type != 3) {
                BedrockProtocol.kickForIllegalState(wrapper.user(), "Unhandled command output type: " + type);
                wrapper.cancel();
                return;
            }
            if (originData.type() != 0) {
                BedrockProtocol.kickForIllegalState(wrapper.user(), "Unhandled command origin type: " + originData.type());
                wrapper.cancel();
                return;
            }
            Function<String, String> translator = k -> wrapper.user().get(ResourcePacksStorage.class).getTranslations().getOrDefault(k, (String)k);
            StringBuilder message = new StringBuilder();
            int messageCount = wrapper.read(BedrockTypes.UNSIGNED_VAR_INT);
            for (int i = 0; i < messageCount; ++i) {
                boolean internal = wrapper.read(Type.BOOLEAN);
                String messageId = wrapper.read(BedrockTypes.STRING);
                Object[] parameters = wrapper.read(BedrockTypes.STRING_ARRAY);
                message.append(internal ? "\u00a7r" : "\u00a7c");
                message.append(BedrockTranslator.translate(messageId, translator, parameters, new TranslatorOptions[0]));
                if (i == messageCount - 1) continue;
                message.append("\n");
            }
            if (type == 4) {
                wrapper.read(BedrockTypes.STRING);
            }
            wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(message.toString()));
            wrapper.write(Type.BOOLEAN, false);
        });
        protocol.registerClientbound(ClientboundBedrockPackets.AVAILABLE_COMMANDS, ClientboundPackets1_19_4.DECLARE_COMMANDS, wrapper -> {
            CommandData[] commands = wrapper.read(BedrockTypes.COMMAND_DATA_ARRAY);
            wrapper.user().put(new CommandsStorage(wrapper.user(), commands));
            wrapper.write(Type.VAR_INT, 2);
            wrapper.write(Type.BYTE, (byte)0);
            wrapper.write(Type.VAR_INT_ARRAY_PRIMITIVE, new int[]{1});
            wrapper.write(Type.BYTE, (byte)22);
            wrapper.write(Type.VAR_INT_ARRAY_PRIMITIVE, new int[0]);
            wrapper.write(Type.STRING, "args");
            wrapper.write(Type.VAR_INT, 5);
            wrapper.write(Type.VAR_INT, 2);
            wrapper.write(Type.STRING, "minecraft:ask_server");
            wrapper.write(Type.VAR_INT, 0);
        });
        protocol.registerServerbound(ServerboundPackets1_19_4.CHAT_MESSAGE, ServerboundBedrockPackets.TEXT, new PacketHandlers(){

            @Override
            public void register() {
                this.create(Type.UNSIGNED_BYTE, (short)1);
                this.create(Type.BOOLEAN, false);
                this.handler(wrapper -> wrapper.write(BedrockTypes.STRING, wrapper.user().get(EntityTracker.class).getClientPlayer().name()));
                this.map(Type.STRING, BedrockTypes.STRING);
                this.handler(wrapper -> wrapper.write(BedrockTypes.STRING, wrapper.user().get(AuthChainData.class).getXuid()));
                this.create(BedrockTypes.STRING, "");
                this.handler(PacketWrapper::clearInputBuffer);
                this.handler(wrapper -> {
                    GameSessionStorage gameSession = wrapper.user().get(GameSessionStorage.class);
                    if (gameSession.isChatRestricted()) {
                        wrapper.cancel();
                        PacketWrapper systemChat = PacketWrapper.create(ClientboundPackets1_19_4.SYSTEM_CHAT, wrapper.user());
                        systemChat.write(Type.COMPONENT, JsonUtil.textToComponent("\u00a7e" + wrapper.user().get(ResourcePacksStorage.class).getTranslations().get("permissions.chatmute")));
                        systemChat.write(Type.BOOLEAN, false);
                        systemChat.send(BedrockProtocol.class);
                    }
                });
            }
        });
        protocol.registerServerbound(ServerboundPackets1_19_4.CHAT_COMMAND, ServerboundBedrockPackets.COMMAND_REQUEST, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING, BedrockTypes.STRING, c -> '/' + c);
                this.handler(wrapper -> {
                    UUID uuid = wrapper.user().getProtocolInfo().getUuid();
                    wrapper.write(BedrockTypes.COMMAND_ORIGIN, new CommandOrigin(0, uuid, ""));
                });
                this.create(Type.BOOLEAN, false);
                this.create(BedrockTypes.VAR_INT, 34);
                this.handler(PacketWrapper::clearInputBuffer);
                this.handler(wrapper -> {
                    GameSessionStorage gameSession = wrapper.user().get(GameSessionStorage.class);
                    if (!gameSession.areCommandsEnabled()) {
                        wrapper.cancel();
                        PacketWrapper systemChat = PacketWrapper.create(ClientboundPackets1_19_4.SYSTEM_CHAT, wrapper.user());
                        systemChat.write(Type.COMPONENT, JsonUtil.textToComponent("\u00a7e" + wrapper.user().get(ResourcePacksStorage.class).getTranslations().get("commands.generic.disabled")));
                        systemChat.write(Type.BOOLEAN, false);
                        systemChat.send(BedrockProtocol.class);
                    }
                });
            }
        });
        protocol.registerServerbound(ServerboundPackets1_19_4.TAB_COMPLETE, null, wrapper -> {
            wrapper.cancel();
            CommandsStorage commands = wrapper.user().get(CommandsStorage.class);
            int id = wrapper.read(Type.VAR_INT);
            String command = wrapper.read(Type.STRING);
            if (!command.startsWith("/")) {
                return;
            }
            Pair<IntIntPair, List<Pair<String, String>>> completions = commands.complete(command.substring(1));
            PacketWrapper tabComplete = PacketWrapper.create(ClientboundPackets1_19_4.TAB_COMPLETE, wrapper.user());
            tabComplete.write(Type.VAR_INT, id);
            tabComplete.write(Type.VAR_INT, completions.key().keyInt());
            tabComplete.write(Type.VAR_INT, completions.key().valueInt());
            tabComplete.write(Type.VAR_INT, completions.value().size());
            for (Pair<String, String> completion : completions.value()) {
                tabComplete.write(Type.STRING, completion.key());
                tabComplete.write(Type.OPTIONAL_COMPONENT, completion.value() != null ? JsonUtil.textToComponent(completion.value()) : null);
            }
            tabComplete.send(BedrockProtocol.class);
        });
    }
}

