/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packets;

import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ServerboundPackets1_19_4;
import com.viaversion.viaversion.util.Pair;
import java.util.UUID;
import net.raphimc.viabedrock.api.model.entity.ClientPlayerEntity;
import net.raphimc.viabedrock.api.util.BitSets;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.rewriter.GameTypeRewriter;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.PlayerListStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;
import net.raphimc.viabedrock.protocol.types.JavaTypes;

public class ClientPlayerPackets {
    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.RESPAWN, ClientboundPackets1_19_4.PLAYER_POSITION, wrapper -> {
            Position3f position = wrapper.read(BedrockTypes.POSITION_3F);
            short state = wrapper.read(Type.UNSIGNED_BYTE);
            wrapper.read(BedrockTypes.UNSIGNED_VAR_LONG);
            if (state != 1) {
                wrapper.cancel();
                return;
            }
            ClientPlayerEntity clientPlayer = wrapper.user().get(EntityTracker.class).getClientPlayer();
            clientPlayer.setPosition(position);
            if (!clientPlayer.isInitiallySpawned()) {
                clientPlayer.setRespawning(true);
            } else {
                clientPlayer.sendPlayerActionPacketToServer(7, -1);
                clientPlayer.closeDownloadingTerrainScreen();
            }
            clientPlayer.writePlayerPositionPacketToClient(wrapper, true, true);
        });
        protocol.registerClientbound(ClientboundBedrockPackets.PLAYER_ACTION, null, wrapper -> {
            wrapper.cancel();
            wrapper.read(BedrockTypes.UNSIGNED_VAR_LONG);
            int action = wrapper.read(BedrockTypes.VAR_INT);
            wrapper.read(BedrockTypes.BLOCK_POSITION);
            wrapper.read(BedrockTypes.BLOCK_POSITION);
            wrapper.read(BedrockTypes.VAR_INT);
            ClientPlayerEntity clientPlayer = wrapper.user().get(EntityTracker.class).getClientPlayer();
            if (action == 14 && clientPlayer.isChangingDimension()) {
                clientPlayer.closeDownloadingTerrainScreen();
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.CORRECT_PLAYER_MOVE_PREDICTION, null, wrapper -> {
            wrapper.cancel();
            BedrockProtocol.kickForIllegalState(wrapper.user(), "Received CorrectPlayerMovePrediction packet, but the client does not support movement corrections.");
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_PLAYER_GAME_TYPE, ClientboundPackets1_19_4.GAME_EVENT, new PacketHandlers(){

            @Override
            protected void register() {
                this.create(Type.UNSIGNED_BYTE, (short)3);
                this.handler(wrapper -> {
                    GameSessionStorage gameSession = wrapper.user().get(GameSessionStorage.class);
                    EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                    int gameType = wrapper.read(BedrockTypes.VAR_INT);
                    entityTracker.getClientPlayer().setGameType(gameType);
                    short gameMode = GameTypeRewriter.getEffectiveGameMode(gameType, gameSession.getLevelGameType());
                    PacketWrapper playerInfoUpdate = PacketWrapper.create(ClientboundPackets1_19_4.PLAYER_INFO_UPDATE, wrapper.user());
                    playerInfoUpdate.write(JavaTypes.PROFILE_ACTIONS_ENUM_TYPE, BitSets.create(6, 2));
                    playerInfoUpdate.write(Type.VAR_INT, 1);
                    playerInfoUpdate.write(Type.UUID, entityTracker.getClientPlayer().javaUuid());
                    playerInfoUpdate.write(Type.VAR_INT, Integer.valueOf(gameMode));
                    playerInfoUpdate.send(BedrockProtocol.class);
                    wrapper.write(Type.FLOAT, Float.valueOf(gameMode));
                });
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_DEFAULT_GAME_TYPE, ClientboundPackets1_19_4.GAME_EVENT, new PacketHandlers(){

            @Override
            protected void register() {
                this.create(Type.UNSIGNED_BYTE, (short)3);
                this.handler(wrapper -> {
                    GameSessionStorage gameSession = wrapper.user().get(GameSessionStorage.class);
                    EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                    int gameType = wrapper.read(BedrockTypes.VAR_INT);
                    gameSession.setLevelGameType(gameType);
                    short gameMode = GameTypeRewriter.getEffectiveGameMode(entityTracker.getClientPlayer().getGameType(), gameType);
                    PacketWrapper playerInfoUpdate = PacketWrapper.create(ClientboundPackets1_19_4.PLAYER_INFO_UPDATE, wrapper.user());
                    playerInfoUpdate.write(JavaTypes.PROFILE_ACTIONS_ENUM_TYPE, BitSets.create(6, 2));
                    playerInfoUpdate.write(Type.VAR_INT, 1);
                    playerInfoUpdate.write(Type.UUID, entityTracker.getClientPlayer().javaUuid());
                    playerInfoUpdate.write(Type.VAR_INT, Integer.valueOf(gameMode));
                    playerInfoUpdate.send(BedrockProtocol.class);
                    wrapper.write(Type.FLOAT, Float.valueOf(gameMode));
                });
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.UPDATE_PLAYER_GAME_TYPE, ClientboundPackets1_19_4.PLAYER_INFO_UPDATE, wrapper -> {
            GameSessionStorage gameSession = wrapper.user().get(GameSessionStorage.class);
            EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
            PlayerListStorage playerList = wrapper.user().get(PlayerListStorage.class);
            int gameType = wrapper.read(BedrockTypes.VAR_INT);
            long playerListId = wrapper.read(BedrockTypes.VAR_LONG);
            Pair<UUID, String> playerListEntry = playerList.getPlayer(playerListId);
            if (playerListEntry == null) {
                wrapper.cancel();
                return;
            }
            short gameMode = GameTypeRewriter.getEffectiveGameMode(gameType, gameSession.getLevelGameType());
            wrapper.write(JavaTypes.PROFILE_ACTIONS_ENUM_TYPE, BitSets.create(6, 2));
            wrapper.write(Type.VAR_INT, 1);
            wrapper.write(Type.UUID, playerListEntry.key());
            wrapper.write(Type.VAR_INT, Integer.valueOf(gameMode));
            if (playerListEntry.key().equals(entityTracker.getClientPlayer().javaUuid())) {
                entityTracker.getClientPlayer().setGameType(gameType);
                PacketWrapper gameEvent = PacketWrapper.create(ClientboundPackets1_19_4.GAME_EVENT, wrapper.user());
                gameEvent.write(Type.UNSIGNED_BYTE, (short)3);
                gameEvent.write(Type.FLOAT, Float.valueOf(gameMode));
                gameEvent.send(BedrockProtocol.class);
            }
        });
        protocol.registerServerbound(ServerboundPackets1_19_4.CLIENT_STATUS, ServerboundBedrockPackets.RESPAWN, wrapper -> {
            int action = wrapper.read(Type.VAR_INT);
            if (action != 0) {
                wrapper.cancel();
                return;
            }
            EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
            wrapper.write(BedrockTypes.POSITION_3F, new Position3f(0.0f, 0.0f, 0.0f));
            wrapper.write(Type.UNSIGNED_BYTE, (short)2);
            wrapper.write(BedrockTypes.UNSIGNED_VAR_LONG, entityTracker.getClientPlayer().runtimeId());
        });
        protocol.registerServerbound(ServerboundPackets1_19_4.PLAYER_MOVEMENT, ServerboundBedrockPackets.MOVE_PLAYER, wrapper -> {
            EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
            entityTracker.getClientPlayer().updatePlayerPosition(wrapper, wrapper.read(Type.BOOLEAN));
        });
        protocol.registerServerbound(ServerboundPackets1_19_4.PLAYER_POSITION, ServerboundBedrockPackets.MOVE_PLAYER, wrapper -> {
            EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
            entityTracker.getClientPlayer().updatePlayerPosition(wrapper, wrapper.read(Type.DOUBLE), wrapper.read(Type.DOUBLE), wrapper.read(Type.DOUBLE), wrapper.read(Type.BOOLEAN));
        });
        protocol.registerServerbound(ServerboundPackets1_19_4.PLAYER_POSITION_AND_ROTATION, ServerboundBedrockPackets.MOVE_PLAYER, wrapper -> {
            EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
            entityTracker.getClientPlayer().updatePlayerPosition(wrapper, wrapper.read(Type.DOUBLE), wrapper.read(Type.DOUBLE), wrapper.read(Type.DOUBLE), wrapper.read(Type.FLOAT).floatValue(), wrapper.read(Type.FLOAT).floatValue(), wrapper.read(Type.BOOLEAN));
        });
        protocol.registerServerbound(ServerboundPackets1_19_4.PLAYER_ROTATION, ServerboundBedrockPackets.MOVE_PLAYER, wrapper -> {
            EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
            entityTracker.getClientPlayer().updatePlayerPosition(wrapper, wrapper.read(Type.FLOAT).floatValue(), wrapper.read(Type.FLOAT).floatValue(), wrapper.read(Type.BOOLEAN));
        });
        protocol.registerServerbound(ServerboundPackets1_19_4.TELEPORT_CONFIRM, null, wrapper -> {
            wrapper.cancel();
            EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
            entityTracker.getClientPlayer().confirmTeleport(wrapper.read(Type.VAR_INT));
        });
    }
}

