/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packets;

import com.viaversion.viaversion.api.minecraft.entities.Entity1_19_4Types;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntMap;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import com.viaversion.viaversion.util.Key;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.entity.ClientPlayerEntity;
import net.raphimc.viabedrock.api.model.entity.Entity;
import net.raphimc.viabedrock.api.util.MathUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.model.EntityLink;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class EntityPackets {
    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.ADD_ENTITY, ClientboundPackets1_19_4.SPAWN_ENTITY, wrapper -> {
            EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
            long uniqueEntityId = wrapper.read(BedrockTypes.VAR_LONG);
            long runtimeEntityId = wrapper.read(BedrockTypes.UNSIGNED_VAR_LONG);
            String identifier = wrapper.read(BedrockTypes.STRING);
            Position3f position = wrapper.read(BedrockTypes.POSITION_3F);
            Position3f motion = wrapper.read(BedrockTypes.POSITION_3F);
            Position3f rotation = wrapper.read(BedrockTypes.POSITION_3F);
            float bodyRotation = wrapper.read(BedrockTypes.FLOAT_LE).floatValue();
            int attributeCount = wrapper.read(BedrockTypes.UNSIGNED_VAR_INT);
            for (int i = 0; i < attributeCount; ++i) {
                String attributeIdentifier = wrapper.read(BedrockTypes.STRING);
                float min = wrapper.read(BedrockTypes.FLOAT_LE).floatValue();
                float max = wrapper.read(BedrockTypes.FLOAT_LE).floatValue();
                float f = wrapper.read(BedrockTypes.FLOAT_LE).floatValue();
            }
            Metadata[] metadata = wrapper.read(BedrockTypes.METADATA_ARRAY);
            Int2IntMap intProperties = wrapper.read(BedrockTypes.INT_PROPERTIES);
            Map<Integer, Float> floatProperties = wrapper.read(BedrockTypes.FLOAT_PROPERTIES);
            EntityLink[] entityLinks = wrapper.read(BedrockTypes.ENTITY_LINK_ARRAY);
            String javaIdentifier = BedrockProtocol.MAPPINGS.getEntityIdentifiers().get(Key.namespaced(identifier));
            if (javaIdentifier == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown bedrock entity identifier: " + identifier);
                wrapper.cancel();
                return;
            }
            Entity1_19_4Types javaEntityType = null;
            for (Entity1_19_4Types type : Entity1_19_4Types.values()) {
                if (type.isAbstractType() || !type.identifier().equals(javaIdentifier)) continue;
                javaEntityType = type;
                break;
            }
            if (javaEntityType == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown java entity identifier: " + javaIdentifier);
                wrapper.cancel();
                return;
            }
            Entity entity = entityTracker.addEntity(uniqueEntityId, runtimeEntityId, null, javaEntityType);
            entity.setPosition(position);
            entity.setRotation(rotation);
            wrapper.write(Type.VAR_INT, entity.javaId());
            wrapper.write(Type.UUID, entity.javaUuid());
            wrapper.write(Type.VAR_INT, javaEntityType.getId());
            wrapper.write(Type.DOUBLE, Double.valueOf(position.x()));
            wrapper.write(Type.DOUBLE, Double.valueOf(position.y()));
            wrapper.write(Type.DOUBLE, Double.valueOf(position.z()));
            wrapper.write(Type.BYTE, MathUtil.float2Byte(rotation.x()));
            wrapper.write(Type.BYTE, MathUtil.float2Byte(rotation.y()));
            wrapper.write(Type.BYTE, MathUtil.float2Byte(rotation.z()));
            wrapper.write(Type.VAR_INT, 0);
            wrapper.write(Type.SHORT, (short)0);
            wrapper.write(Type.SHORT, (short)0);
            wrapper.write(Type.SHORT, (short)0);
        });
        protocol.registerClientbound(ClientboundBedrockPackets.MOVE_ENTITY_ABSOLUTE, ClientboundPackets1_19_4.ENTITY_TELEPORT, wrapper -> {
            EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
            long runtimeEntityId = wrapper.read(BedrockTypes.UNSIGNED_VAR_LONG);
            short flags = wrapper.read(Type.UNSIGNED_BYTE);
            Position3f position = wrapper.read(BedrockTypes.POSITION_3F);
            float pitch = MathUtil.byte2Float(wrapper.read(Type.BYTE));
            float yaw = MathUtil.byte2Float(wrapper.read(Type.BYTE));
            float headYaw = MathUtil.byte2Float(wrapper.read(Type.BYTE));
            boolean onGround = (flags & 1) != 0;
            boolean teleported = (flags & 2) != 0;
            Entity entity = entityTracker.getEntityByRid(runtimeEntityId);
            if (entity == null) {
                wrapper.cancel();
                return;
            }
            entity.setPosition(position);
            entity.setOnGround(onGround);
            if (entity instanceof ClientPlayerEntity) {
                if (!teleported) {
                    wrapper.cancel();
                    return;
                }
                wrapper.setPacketType(ClientboundPackets1_19_4.PLAYER_POSITION);
                entityTracker.getClientPlayer().writePlayerPositionPacketToClient(wrapper, true, true);
                return;
            }
            entity.setRotation(new Position3f(pitch, yaw, headYaw));
            PacketWrapper entityHeadLook = PacketWrapper.create(ClientboundPackets1_19_4.ENTITY_HEAD_LOOK, wrapper.user());
            entityHeadLook.write(Type.VAR_INT, entity.javaId());
            entityHeadLook.write(Type.BYTE, MathUtil.float2Byte(headYaw));
            entityHeadLook.send(BedrockProtocol.class);
            wrapper.write(Type.VAR_INT, entity.javaId());
            wrapper.write(Type.DOUBLE, Double.valueOf(position.x()));
            wrapper.write(Type.DOUBLE, (double)position.y() - (double)entity.eyeOffset());
            wrapper.write(Type.DOUBLE, Double.valueOf(position.z()));
            wrapper.write(Type.BYTE, MathUtil.float2Byte(yaw));
            wrapper.write(Type.BYTE, MathUtil.float2Byte(pitch));
            wrapper.write(Type.BOOLEAN, onGround);
        });
        protocol.registerClientbound(ClientboundBedrockPackets.MOVE_ENTITY_DELTA, ClientboundPackets1_19_4.ENTITY_TELEPORT, wrapper -> {
            EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
            long runtimeEntityId = wrapper.read(BedrockTypes.UNSIGNED_VAR_LONG);
            int flags = wrapper.read(BedrockTypes.UNSIGNED_SHORT_LE);
            Entity entity = entityTracker.getEntityByRid(runtimeEntityId);
            if (entity == null) {
                wrapper.cancel();
                return;
            }
            if (entity instanceof ClientPlayerEntity) {
                if ((flags & 0x80) == 0 && (flags & 0x100) == 0) {
                    wrapper.cancel();
                    return;
                }
                float x = 0.0f;
                float y = 0.0f;
                float z = 0.0f;
                if ((flags & 1) != 0) {
                    x = wrapper.read(BedrockTypes.FLOAT_LE).floatValue();
                }
                if ((flags & 2) != 0) {
                    y = wrapper.read(BedrockTypes.FLOAT_LE).floatValue();
                }
                if ((flags & 4) != 0) {
                    z = wrapper.read(BedrockTypes.FLOAT_LE).floatValue();
                }
                entity.setPosition(new Position3f(x, y, z));
                wrapper.clearPacket();
                if ((flags & 0x100) != 0) {
                    wrapper.write(Type.VAR_INT, entity.javaId());
                    wrapper.write(Type.DOUBLE, Double.valueOf(entity.position().x()));
                    wrapper.write(Type.DOUBLE, (double)entity.position().y() - (double)entity.eyeOffset());
                    wrapper.write(Type.DOUBLE, Double.valueOf(entity.position().z()));
                    wrapper.write(Type.BYTE, MathUtil.float2Byte(entity.rotation().y()));
                    wrapper.write(Type.BYTE, MathUtil.float2Byte(entity.rotation().x()));
                    wrapper.write(Type.BOOLEAN, entity.isOnGround());
                } else {
                    wrapper.setPacketType(ClientboundPackets1_19_4.PLAYER_POSITION);
                    entityTracker.getClientPlayer().writePlayerPositionPacketToClient(wrapper, true, true);
                }
                return;
            }
            if ((flags & 1) != 0) {
                entity.setPosition(new Position3f(wrapper.read(BedrockTypes.FLOAT_LE).floatValue(), entity.position().y(), entity.position().z()));
            }
            if ((flags & 2) != 0) {
                entity.setPosition(new Position3f(entity.position().x(), wrapper.read(BedrockTypes.FLOAT_LE).floatValue(), entity.position().z()));
            }
            if ((flags & 4) != 0) {
                entity.setPosition(new Position3f(entity.position().x(), entity.position().y(), wrapper.read(BedrockTypes.FLOAT_LE).floatValue()));
            }
            if ((flags & 8) != 0) {
                entity.setRotation(new Position3f(MathUtil.byte2Float(wrapper.read(Type.BYTE)), entity.rotation().y(), entity.rotation().z()));
            }
            if ((flags & 0x10) != 0) {
                entity.setRotation(new Position3f(entity.rotation().x(), MathUtil.byte2Float(wrapper.read(Type.BYTE)), entity.rotation().z()));
            }
            if ((flags & 0x20) != 0) {
                entity.setRotation(new Position3f(entity.rotation().x(), entity.rotation().y(), MathUtil.byte2Float(wrapper.read(Type.BYTE))));
                PacketWrapper entityHeadLook = PacketWrapper.create(ClientboundPackets1_19_4.ENTITY_HEAD_LOOK, wrapper.user());
                entityHeadLook.write(Type.VAR_INT, entity.javaId());
                entityHeadLook.write(Type.BYTE, MathUtil.float2Byte(entity.rotation().z()));
                entityHeadLook.send(BedrockProtocol.class);
            }
            entity.setOnGround((flags & 0x40) != 0);
            wrapper.write(Type.VAR_INT, entity.javaId());
            wrapper.write(Type.DOUBLE, Double.valueOf(entity.position().x()));
            wrapper.write(Type.DOUBLE, (double)entity.position().y() - (double)entity.eyeOffset());
            wrapper.write(Type.DOUBLE, Double.valueOf(entity.position().z()));
            wrapper.write(Type.BYTE, MathUtil.float2Byte(entity.rotation().y()));
            wrapper.write(Type.BYTE, MathUtil.float2Byte(entity.rotation().x()));
            wrapper.write(Type.BOOLEAN, entity.isOnGround());
        });
        protocol.registerClientbound(ClientboundBedrockPackets.REMOVE_ENTITY, ClientboundPackets1_19_4.REMOVE_ENTITIES, wrapper -> {
            long uniqueEntityId;
            EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
            Entity entity = entityTracker.getEntityByUid(uniqueEntityId = wrapper.read(BedrockTypes.VAR_LONG).longValue());
            if (entity == null) {
                wrapper.cancel();
                return;
            }
            entityTracker.removeEntity(entity);
            wrapper.write(Type.VAR_INT_ARRAY_PRIMITIVE, new int[]{entity.javaId()});
        });
    }
}

