/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packets;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import com.viaversion.viaversion.util.Pair;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import net.lenni0451.mcstructs_bedrock.text.components.RootBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.components.TranslationBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.serializer.BedrockComponentSerializer;
import net.lenni0451.mcstructs_bedrock.text.utils.BedrockTranslator;
import net.lenni0451.mcstructs_bedrock.text.utils.TranslatorOptions;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.scoreboard.ScoreboardEntry;
import net.raphimc.viabedrock.api.model.scoreboard.ScoreboardObjective;
import net.raphimc.viabedrock.api.util.BitSets;
import net.raphimc.viabedrock.api.util.JsonUtil;
import net.raphimc.viabedrock.api.util.StringUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.model.SkinData;
import net.raphimc.viabedrock.protocol.providers.SkinProvider;
import net.raphimc.viabedrock.protocol.storage.PlayerListStorage;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import net.raphimc.viabedrock.protocol.storage.ScoreboardTracker;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;
import net.raphimc.viabedrock.protocol.types.JavaTypes;

public class HudPackets {
    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.PLAYER_LIST, ClientboundPackets1_19_4.PLAYER_INFO_UPDATE, wrapper -> {
            PlayerListStorage playerListStorage = wrapper.user().get(PlayerListStorage.class);
            ScoreboardTracker scoreboardTracker = wrapper.user().get(ScoreboardTracker.class);
            short action = wrapper.read(Type.UNSIGNED_BYTE);
            if (action == 0) {
                int i;
                int length = wrapper.read(BedrockTypes.UNSIGNED_VAR_INT);
                UUID[] uuids = new UUID[length];
                long[] playerListIds = new long[length];
                String[] names = new String[length];
                wrapper.write(JavaTypes.PROFILE_ACTIONS_ENUM_TYPE, BitSets.create(6, 0, 3, 5));
                wrapper.write(Type.VAR_INT, length);
                for (i = 0; i < length; ++i) {
                    uuids[i] = wrapper.read(BedrockTypes.UUID);
                    wrapper.write(Type.UUID, uuids[i]);
                    playerListIds[i] = wrapper.read(BedrockTypes.VAR_LONG);
                    names[i] = wrapper.read(BedrockTypes.STRING);
                    wrapper.write(Type.STRING, StringUtil.encodeUUID(uuids[i]));
                    wrapper.write(Type.VAR_INT, 5);
                    wrapper.write(Type.STRING, "xuid");
                    wrapper.write(Type.STRING, wrapper.read(BedrockTypes.STRING));
                    wrapper.write(Type.OPTIONAL_STRING, null);
                    wrapper.write(Type.STRING, "platform_chat_id");
                    wrapper.write(Type.STRING, wrapper.read(BedrockTypes.STRING));
                    wrapper.write(Type.OPTIONAL_STRING, null);
                    wrapper.write(Type.STRING, "device_os");
                    wrapper.write(Type.STRING, wrapper.read(BedrockTypes.INT_LE).toString());
                    wrapper.write(Type.OPTIONAL_STRING, null);
                    SkinData skin = wrapper.read(BedrockTypes.SKIN);
                    wrapper.write(Type.STRING, "is_teacher");
                    wrapper.write(Type.STRING, wrapper.read(Type.BOOLEAN).toString());
                    wrapper.write(Type.OPTIONAL_STRING, null);
                    wrapper.write(Type.STRING, "is_host");
                    wrapper.write(Type.STRING, wrapper.read(Type.BOOLEAN).toString());
                    wrapper.write(Type.OPTIONAL_STRING, null);
                    wrapper.write(Type.BOOLEAN, true);
                    wrapper.write(Type.OPTIONAL_COMPONENT, JsonUtil.textToComponent(names[i]));
                    Via.getManager().getProviders().get(SkinProvider.class).setSkin(wrapper.user(), uuids[i], skin);
                }
                for (i = 0; i < length; ++i) {
                    wrapper.read(Type.BOOLEAN);
                }
                ArrayList<UUID> toRemoveUUIDs = new ArrayList<UUID>();
                ArrayList<String> toRemoveNames = new ArrayList<String>();
                for (int i2 = 0; i2 < uuids.length; ++i2) {
                    Pair<ScoreboardObjective, ScoreboardEntry> scoreboardEntry;
                    Pair<Long, String> entry = playerListStorage.addPlayer(uuids[i2], playerListIds[i2], names[i2]);
                    if (entry != null) {
                        toRemoveUUIDs.add(uuids[i2]);
                        toRemoveNames.add(entry.value());
                    }
                    if ((scoreboardEntry = scoreboardTracker.getEntryForPlayer(playerListIds[i2])) == null) continue;
                    scoreboardEntry.key().updateEntry(wrapper.user(), scoreboardEntry.value());
                }
                if (!toRemoveUUIDs.isEmpty()) {
                    PacketWrapper playerInfoRemove = PacketWrapper.create(ClientboundPackets1_19_4.PLAYER_INFO_REMOVE, wrapper.user());
                    playerInfoRemove.write(Type.UUID_ARRAY, toRemoveUUIDs.toArray(new UUID[0]));
                    playerInfoRemove.send(BedrockProtocol.class);
                    PacketWrapper customChatCompletions = PacketWrapper.create(ClientboundPackets1_19_4.CUSTOM_CHAT_COMPLETIONS, wrapper.user());
                    customChatCompletions.write(Type.VAR_INT, 1);
                    customChatCompletions.write(Type.STRING_ARRAY, toRemoveNames.toArray(new String[0]));
                    customChatCompletions.send(BedrockProtocol.class);
                }
                PacketWrapper customChatCompletions = PacketWrapper.create(ClientboundPackets1_19_4.CUSTOM_CHAT_COMPLETIONS, wrapper.user());
                customChatCompletions.write(Type.VAR_INT, 0);
                customChatCompletions.write(Type.STRING_ARRAY, names);
                customChatCompletions.send(BedrockProtocol.class);
            } else if (action == 1) {
                wrapper.setPacketType(ClientboundPackets1_19_4.PLAYER_INFO_REMOVE);
                UUID[] uuids = wrapper.read(BedrockTypes.UUID_ARRAY);
                wrapper.write(Type.UUID_ARRAY, uuids);
                ArrayList<String> names = new ArrayList<String>();
                for (UUID uuid : uuids) {
                    Pair<Long, String> entry = playerListStorage.removePlayer(uuid);
                    if (entry == null) continue;
                    names.add(entry.value());
                    Pair<ScoreboardObjective, ScoreboardEntry> scoreboardEntry = scoreboardTracker.getEntryForPlayer(entry.key());
                    if (scoreboardEntry == null) continue;
                    scoreboardEntry.key().updateEntry(wrapper.user(), scoreboardEntry.value());
                }
                PacketWrapper customChatCompletions = PacketWrapper.create(ClientboundPackets1_19_4.CUSTOM_CHAT_COMPLETIONS, wrapper.user());
                customChatCompletions.write(Type.VAR_INT, 1);
                customChatCompletions.write(Type.STRING_ARRAY, names.toArray(new String[0]));
                customChatCompletions.send(BedrockProtocol.class);
            } else {
                BedrockProtocol.kickForIllegalState(wrapper.user(), "Unsupported player list action: " + action);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_TITLE, null, wrapper -> {
            int type = wrapper.read(BedrockTypes.VAR_INT);
            String text = wrapper.read(BedrockTypes.STRING);
            int fadeInTicks = wrapper.read(BedrockTypes.VAR_INT);
            int stayTicks = wrapper.read(BedrockTypes.VAR_INT);
            int fadeOutTicks = wrapper.read(BedrockTypes.VAR_INT);
            wrapper.read(BedrockTypes.STRING);
            wrapper.read(BedrockTypes.STRING);
            Function<String, String> translator = k -> wrapper.user().get(ResourcePacksStorage.class).getTranslations().getOrDefault(k, (String)k);
            String originalText = text;
            try {
                if (type >= 6 && type <= 8) {
                    RootBedrockComponent rootComponent = BedrockComponentSerializer.deserialize(text);
                    rootComponent.forEach(c -> {
                        if (c instanceof TranslationBedrockComponent) {
                            ((TranslationBedrockComponent)c).setTranslator(translator);
                        }
                    });
                    text = rootComponent.asString();
                }
                switch (type) {
                    case 0: 
                    case 1: {
                        wrapper.setPacketType(ClientboundPackets1_19_4.CLEAR_TITLES);
                        wrapper.write(Type.BOOLEAN, type == 1);
                        break;
                    }
                    case 2: 
                    case 6: {
                        wrapper.setPacketType(ClientboundPackets1_19_4.TITLE_TEXT);
                        wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(text));
                        break;
                    }
                    case 3: 
                    case 7: {
                        wrapper.setPacketType(ClientboundPackets1_19_4.TITLE_SUBTITLE);
                        wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(text));
                        break;
                    }
                    case 4: 
                    case 8: {
                        wrapper.setPacketType(ClientboundPackets1_19_4.ACTIONBAR);
                        wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(text));
                        break;
                    }
                    case 5: {
                        wrapper.setPacketType(ClientboundPackets1_19_4.TITLE_TIMES);
                        wrapper.write(Type.INT, fadeInTicks);
                        wrapper.write(Type.INT, stayTicks);
                        wrapper.write(Type.INT, fadeOutTicks);
                        break;
                    }
                    default: {
                        ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown title type: " + type);
                        wrapper.cancel();
                        break;
                    }
                }
            }
            catch (Throwable e) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Error while translating '" + originalText + "'", e);
                wrapper.cancel();
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_DISPLAY_OBJECTIVE, ClientboundPackets1_19_4.DISPLAY_SCOREBOARD, wrapper -> {
            ScoreboardTracker scoreboardTracker = wrapper.user().get(ScoreboardTracker.class);
            String displaySlot = wrapper.read(BedrockTypes.STRING);
            String objectiveName = wrapper.read(BedrockTypes.STRING);
            String displayName = wrapper.read(BedrockTypes.STRING);
            wrapper.read(BedrockTypes.STRING);
            boolean ascending = wrapper.read(BedrockTypes.VAR_INT) == 0;
            switch (displaySlot) {
                case "sidebar": {
                    wrapper.write(Type.BYTE, (byte)1);
                    break;
                }
                case "belowname": {
                    wrapper.write(Type.BYTE, (byte)2);
                    break;
                }
                case "list": {
                    wrapper.write(Type.BYTE, (byte)0);
                    break;
                }
                default: {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown scoreboard display slot: " + displaySlot);
                    wrapper.cancel();
                    return;
                }
            }
            wrapper.write(Type.STRING, objectiveName);
            if (objectiveName.isEmpty()) {
                return;
            }
            if (!scoreboardTracker.hasObjective(objectiveName)) {
                scoreboardTracker.addObjective(objectiveName, new ScoreboardObjective(objectiveName, ascending));
                Function<String, String> translator = k -> wrapper.user().get(ResourcePacksStorage.class).getTranslations().getOrDefault(k, (String)k);
                PacketWrapper scoreboardObjective = PacketWrapper.create(ClientboundPackets1_19_4.SCOREBOARD_OBJECTIVE, wrapper.user());
                scoreboardObjective.write(Type.STRING, objectiveName);
                scoreboardObjective.write(Type.BYTE, (byte)0);
                scoreboardObjective.write(Type.COMPONENT, JsonUtil.textToComponent(BedrockTranslator.translate(displayName, translator, new Object[0], new TranslatorOptions[0])));
                scoreboardObjective.write(Type.VAR_INT, 0);
                scoreboardObjective.send(BedrockProtocol.class);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_SCORE, null, wrapper -> {
            wrapper.cancel();
            ScoreboardTracker scoreboardTracker = wrapper.user().get(ScoreboardTracker.class);
            short action = wrapper.read(Type.UNSIGNED_BYTE);
            int count = wrapper.read(BedrockTypes.UNSIGNED_VAR_INT);
            for (int i = 0; i < count; ++i) {
                ScoreboardEntry entry;
                long scoreboardId = wrapper.read(BedrockTypes.VAR_LONG);
                String objectiveName = wrapper.read(BedrockTypes.STRING);
                int score = wrapper.read(BedrockTypes.INT_LE);
                if (action == 0) {
                    short type = wrapper.read(Type.UNSIGNED_BYTE);
                    Long entityId = null;
                    String fakePlayerName = null;
                    if (type == 1 || type == 2) {
                        entityId = wrapper.read(BedrockTypes.VAR_LONG);
                    } else if (type == 3) {
                        fakePlayerName = wrapper.read(BedrockTypes.STRING);
                    }
                    entry = new ScoreboardEntry(score, type == 1, entityId, fakePlayerName);
                } else if (action == 1) {
                    entry = null;
                } else {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown scoreboard action: " + action);
                    continue;
                }
                ScoreboardObjective objective = scoreboardTracker.getObjective(objectiveName);
                if (objective == null) continue;
                Pair<ScoreboardObjective, ScoreboardEntry> existingEntry = scoreboardTracker.getEntry(scoreboardId);
                if (existingEntry != null) {
                    existingEntry.key().removeEntry(wrapper.user(), scoreboardId);
                    if (entry == null) continue;
                    existingEntry.value().setScore(entry.score());
                    objective.addEntry(wrapper.user(), scoreboardId, existingEntry.value());
                    continue;
                }
                if (entry == null) continue;
                ScoreboardEntry sameTargetEntry = objective.getEntryWithSameTarget(entry);
                if (sameTargetEntry != null) {
                    sameTargetEntry.setScore(entry.score());
                    objective.updateEntry(wrapper.user(), sameTargetEntry, 0);
                    continue;
                }
                if (!entry.isValid()) continue;
                objective.addEntry(wrapper.user(), scoreboardId, entry);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_SCOREBOARD_IDENTITY, null, wrapper -> {
            wrapper.cancel();
            ScoreboardTracker scoreboardTracker = wrapper.user().get(ScoreboardTracker.class);
            short action = wrapper.read(Type.UNSIGNED_BYTE);
            int count = wrapper.read(BedrockTypes.UNSIGNED_VAR_INT);
            for (int i = 0; i < count; ++i) {
                ScoreboardEntry scoreboardEntry;
                long scoreboardId = wrapper.read(BedrockTypes.VAR_LONG);
                Pair<ScoreboardObjective, ScoreboardEntry> entry = scoreboardTracker.getEntry(scoreboardId);
                if (action == 0) {
                    ScoreboardEntry scoreboardEntry2;
                    long playerListId = wrapper.read(BedrockTypes.VAR_LONG);
                    if (entry == null || (scoreboardEntry2 = entry.value()).entityId() != null) continue;
                    scoreboardEntry2.updateTarget(true, playerListId, scoreboardEntry2.fakePlayerName());
                    entry.key().updateEntry(wrapper.user(), scoreboardEntry2);
                    continue;
                }
                if (action != 1 || entry == null || (scoreboardEntry = entry.value()).fakePlayerName() == null) continue;
                scoreboardEntry.updateTarget(false, null, scoreboardEntry.fakePlayerName());
                entry.key().updateEntry(wrapper.user(), scoreboardEntry);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.REMOVE_OBJECTIVE, ClientboundPackets1_19_4.SCOREBOARD_OBJECTIVE, new PacketHandlers(){

            @Override
            protected void register() {
                this.map(BedrockTypes.STRING, Type.STRING);
                this.create(Type.BYTE, (byte)1);
                this.handler(wrapper -> wrapper.user().get(ScoreboardTracker.class).removeObjective(wrapper.get(Type.STRING, 0)));
            }
        });
    }
}

